/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.swing.lib;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.objectweb.util.explorer.api.Entry;
import org.objectweb.util.explorer.api.IconProvider;
import org.objectweb.util.explorer.api.Tree;
import org.objectweb.util.explorer.core.common.api.Description;
import org.objectweb.util.explorer.core.menu.lib.DefaultMenuItemTreeView;
import org.objectweb.util.explorer.core.naming.lib.DefaultEntry;
import org.objectweb.util.explorer.interpreter.api.DescriptionInterpreter;
import org.objectweb.util.explorer.resolver.api.PropertyResolver;
import org.objectweb.util.explorer.swing.icon.IconFileProvider;
import org.objectweb.util.explorer.swing.icon.ObjectIconProvider;

public class DynamicTable
extends JTable {
    protected TableCellRenderer tableCellRenderer_ = new MyTableCellRenderer();
    protected PropertyResolver propertyResolver_;
    protected DescriptionInterpreter descriptionInterpreter_;
    protected Tree tree_;
    protected Icon objectIcon_;

    public DynamicTable() {
        this.addMouseListener(new MyMouseAdapter());
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.objectIcon_ = (Icon)new ObjectIconProvider().newIcon(null);
    }

    protected PropertyResolver getPropertyResolver() {
        return this.propertyResolver_;
    }

    protected DescriptionInterpreter getDescriptionInterpreter() {
        return this.descriptionInterpreter_;
    }

    protected Tree getTree() {
        return this.tree_;
    }

    protected Icon getImageIcon(Entry entry) {
        if (this.getPropertyResolver() != null) {
            Description desc = this.getPropertyResolver().resolve("icon", entry);
            IconProvider iconProvider = (IconProvider)this.getDescriptionInterpreter().interprete(desc, null);
            if (iconProvider != null) {
                Object object = iconProvider.newIcon(entry.getValue());
                if (object instanceof Icon) {
                    return (Icon)object;
                }
                if (object instanceof String) {
                    return (Icon)new IconFileProvider((String)object).newIcon(entry.getValue());
                }
                if (object instanceof URL) {
                    return (Icon)new IconFileProvider((URL)object).newIcon(entry.getValue());
                }
            }
        }
        return null;
    }

    public TableCellRenderer getCellRenderer(int row, int col) {
        return this.tableCellRenderer_;
    }

    public void setPropertyResolver(PropertyResolver propertyResolver) {
        this.propertyResolver_ = propertyResolver;
    }

    public void setDescriptionInterpreter(DescriptionInterpreter descriptionInterpreter) {
        this.descriptionInterpreter_ = descriptionInterpreter;
    }

    public void setTree(Tree tree) {
        this.tree_ = tree;
    }

    public void setData(String[] headers, Object[][] values) {
        this.setModel(new TableModel(headers, values));
    }

    protected final class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        protected MyTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value != null) {
                Entry entry = (Entry)value;
                this.setText(entry.getName().toString());
                Icon icon = DynamicTable.this.getImageIcon(entry);
                this.setIcon(icon == null ? DynamicTable.this.objectIcon_ : icon);
            } else {
                this.setIcon(null);
            }
            return this;
        }
    }

    protected final class MyMouseAdapter
    extends MouseAdapter {
        protected MyMouseAdapter() {
        }

        public void mousePressed(MouseEvent e) {
            this.popupLayout(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.popupLayout(e);
        }

        private void popupLayout(MouseEvent e) {
            if (e.isPopupTrigger()) {
                Point point = e.getPoint();
                int row = DynamicTable.this.rowAtPoint(point);
                int col = DynamicTable.this.columnAtPoint(point);
                if (row != -1 && col != -1) {
                    Entry object = (Entry)DynamicTable.this.getValueAt(row, col);
                    if (DynamicTable.this.getPropertyResolver() != null && DynamicTable.this.getDescriptionInterpreter() != null) {
                        Description desc = DynamicTable.this.getPropertyResolver().resolve("menu", object, null);
                        JPopupMenu menu = (JPopupMenu)DynamicTable.this.getDescriptionInterpreter().interprete(desc, new DefaultMenuItemTreeView(DynamicTable.this.getTree(), object, null));
                        if (menu != null) {
                            DynamicTable.this.changeSelection(row, col, false, false);
                            menu.show(DynamicTable.this, (int)point.getX(), (int)point.getY());
                        }
                    }
                }
            }
        }
    }

    protected class TableModel
    extends AbstractTableModel {
        protected String[] headers_;
        protected Object[][] values_;

        public TableModel(String[] headers, Object[][] values) {
            this.headers_ = headers;
            this.values_ = new Object[values.length][0];
            if (this.values_ != null) {
                for (int i = 0; i < values.length; ++i) {
                    this.values_[i] = new Object[values[i].length];
                    for (int j = 0; j < values[i].length; ++j) {
                        Object value = values[i][j];
                        if (value == null) continue;
                        if (value instanceof Entry) {
                            this.values_[i][j] = (Entry)value;
                            continue;
                        }
                        DefaultEntry newEntry = new DefaultEntry(value.toString(), value);
                        this.values_[i][j] = newEntry;
                    }
                }
            }
        }

        public String getColumnName(int column) {
            if (this.headers_ != null) {
                return this.headers_[column];
            }
            return super.getColumnName(column);
        }

        public int getColumnCount() {
            if (this.headers_ != null) {
                return this.headers_.length;
            }
            return 0;
        }

        public int getRowCount() {
            if (this.values_ != null) {
                return this.values_.length;
            }
            return 0;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.values_ != null) {
                return this.values_[rowIndex][columnIndex];
            }
            return null;
        }
    }
}

