/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.swing.lib;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.api.control.NameController;
import org.objectweb.fractal.api.control.SuperController;
import org.objectweb.fractal.api.factory.Factory;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.util.Fractal;
import org.objectweb.util.explorer.api.Context;
import org.objectweb.util.explorer.api.DropAction;
import org.objectweb.util.explorer.api.Entry;
import org.objectweb.util.explorer.api.IconProvider;
import org.objectweb.util.explorer.api.Info;
import org.objectweb.util.explorer.api.MenuItemTreeView;
import org.objectweb.util.explorer.api.RootContext;
import org.objectweb.util.explorer.api.RootEntry;
import org.objectweb.util.explorer.api.Tree;
import org.objectweb.util.explorer.api.TreeView;
import org.objectweb.util.explorer.context.api.ContextContainerFactory;
import org.objectweb.util.explorer.core.common.api.ContextContainer;
import org.objectweb.util.explorer.core.common.api.Description;
import org.objectweb.util.explorer.core.common.api.Synchronization;
import org.objectweb.util.explorer.core.common.api.TextComponent;
import org.objectweb.util.explorer.core.common.lib.BindingFeature;
import org.objectweb.util.explorer.core.common.lib.DefaultTreeView;
import org.objectweb.util.explorer.core.common.lib.RootContextContainer;
import org.objectweb.util.explorer.core.common.lib.TreeBindingFeature;
import org.objectweb.util.explorer.core.dnd.api.DnDDescription;
import org.objectweb.util.explorer.core.dnd.api.DnDDescriptions;
import org.objectweb.util.explorer.core.dnd.lib.DefaultDropTreeView;
import org.objectweb.util.explorer.core.dnd.lib.EntryTransferable;
import org.objectweb.util.explorer.core.menu.lib.DefaultMenuItemTreeView;
import org.objectweb.util.explorer.core.naming.lib.DefaultEntry;
import org.objectweb.util.explorer.core.role.api.RoleManager;
import org.objectweb.util.explorer.core.role.api.RoleProvider;
import org.objectweb.util.explorer.core.root.lib.DefaultRootEntry;
import org.objectweb.util.explorer.interpreter.api.DescriptionInterpreter;
import org.objectweb.util.explorer.resolver.api.PropertyResolver;
import org.objectweb.util.explorer.swing.api.Explorer;
import org.objectweb.util.explorer.swing.icon.IconFileProvider;
import org.objectweb.util.explorer.swing.menu.GenericAction;
import org.objectweb.util.trace.Trace;
import org.objectweb.util.trace.TraceSystem;

public class DynamicTree
extends JTree
implements Tree,
BindingController,
LifeCycleController,
Explorer,
Autoscroll {
    protected BindingFeature bindingFeature_ = new TreeBindingFeature();
    protected DefaultMutableTreeNode rootNode_;
    protected DefaultTreeModel treeModel_;
    protected List initialContext_ = new Vector();
    protected ContextContainer graphicalInitialContext_;
    protected List alreadyInInitialContext_ = new Vector();
    protected DefaultTreeSelectionModel selectionModel_;
    protected boolean popupEnabled_ = true;
    protected Map nodeStates_ = new HashMap();
    protected JMenuBar menuBar_ = null;
    protected JMenu actionMenu_ = null;
    protected JMenu roleMenu_ = null;
    protected JToolBar toolBar_ = null;
    protected int nbElementsToRemove_ = 0;
    protected boolean multipleRoles_ = false;
    protected boolean dndEnabled_ = true;
    protected DragSource dragSource_;
    protected DragGestureListener dragGestureListener_;
    protected DragSourceListener dragSourceListener_;
    protected int dragAction_ = 0x40000003;
    protected int acceptableActions_ = 0x40000003;
    protected DropTarget dropTarget_;
    protected DropTargetListener dropTargetListener_;
    static /* synthetic */ Class class$org$objectweb$util$explorer$api$RootContext;
    static /* synthetic */ Class class$javax$swing$JSeparator;
    static /* synthetic */ Class class$org$objectweb$util$explorer$api$Info;
    static /* synthetic */ Class class$org$objectweb$util$explorer$api$DropAction;

    private void initDragAndDrop() {
        this.dragSource_ = DragSource.getDefaultDragSource();
        this.dragSourceListener_ = new TreeDragSourceListener();
        this.dragGestureListener_ = new TreeDragGestureListener();
        this.dragSource_.createDefaultDragGestureRecognizer(this, this.dragAction_, this.dragGestureListener_);
        this.dropTargetListener_ = new TreeDropTargetListener();
        this.dropTarget_ = new DropTarget(this, this.acceptableActions_, this.dropTargetListener_, true);
    }

    public DynamicTree() {
        this.rootNode_ = new DefaultMutableTreeNode(new DefaultEntry("Root", this.graphicalInitialContext_));
        this.treeModel_ = new MyTreeModel(this.rootNode_);
        this.setModel(this.treeModel_);
        this.selectionModel_ = new DefaultTreeSelectionModel();
        this.selectionModel_.setSelectionMode(1);
        this.setSelectionModel(this.selectionModel_);
        this.addMouseListener(new MyMouseAdapter());
        this.addTreeWillExpandListener(new MyTreeWillExpandListener());
        this.addTreeExpansionListener(new MyTreeExpansionListener());
        this.addTreeSelectionListener(new MyTreeSelectionListener());
        this.setCellRenderer(new MyTreeCellRenderer());
        this.initDragAndDrop();
        this.setToolTipText("");
        this.setShowsRootHandles(true);
        this.collapseRow(0);
        this.expandRow(0);
        this.setRootVisible(false);
    }

    protected Trace getTrace() {
        return TraceSystem.get((String)"explorer");
    }

    protected Entry objectToEntry(Object o) {
        if (o != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)o;
            return (Entry)node.getUserObject();
        }
        return null;
    }

    protected String pathToString(DefaultMutableTreeNode node) {
        StringBuffer sf = new StringBuffer();
        Object[] o = node.getUserObjectPath();
        for (int i = 1; i < o.length; ++i) {
            sf.append(((Entry)o[i]).getName().toString());
            if (i == o.length - 1) continue;
            sf.append("/");
        }
        return sf.toString();
    }

    protected String pathToString(TreePath path) {
        if (path != null) {
            return this.pathToString((DefaultMutableTreeNode)path.getLastPathComponent());
        }
        return "";
    }

    protected DefaultMutableTreeNode getChildren(DefaultMutableTreeNode parent, String name) {
        Enumeration<TreeNode> enumeration = parent.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)enumeration.nextElement();
            Entry entry = (Entry)childNode.getUserObject();
            if (!name.equals(entry.getName())) continue;
            return childNode;
        }
        return null;
    }

    protected TreePath stringToPath(String path) {
        if (path != null && !path.equals("")) {
            StringTokenizer st = new StringTokenizer(path, "/");
            DefaultMutableTreeNode parentNode = this.rootNode_;
            DefaultMutableTreeNode childNode = null;
            while (st.hasMoreTokens()) {
                String currentPath = st.nextToken();
                childNode = this.getChildren(parentNode, currentPath);
                if (childNode != null) {
                    parentNode = childNode;
                    continue;
                }
                return new TreePath(parentNode.getPath());
            }
            return new TreePath(childNode.getPath());
        }
        return null;
    }

    protected TreePath getPath(Point p) {
        if (p != null) {
            return this.getPathForLocation((int)p.getX(), (int)p.getY());
        }
        return null;
    }

    protected Object getSelectedObject() {
        Entry entry = this.getSelectedEntry();
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    protected Entry getParentEntry() {
        Object object = this.getLastSelectedPathComponent();
        if (object != null) {
            return this.objectToEntry(((DefaultMutableTreeNode)object).getParent());
        }
        return null;
    }

    protected TreeView getTreeView() {
        return new DefaultTreeView(this, this.getSelectedEntry(), this.getParentEntry());
    }

    protected MenuItemTreeView getMenuItemTreeView() {
        return new DefaultMenuItemTreeView(this, this.getSelectedEntry(), this.getParentEntry());
    }

    protected void createGraphicalInitialContext() {
        this.getGraphicalInitialContext().clear();
        Description desc = this.getPropertyResolver().resolve("root", null);
        if (desc != null && !desc.isEmpty()) {
            RootContext rootContext = (RootContext)this.getDescriptionInterpreter().interprete(desc, class$org$objectweb$util$explorer$api$RootContext == null ? (class$org$objectweb$util$explorer$api$RootContext = DynamicTree.class$("org.objectweb.util.explorer.api.RootContext")) : class$org$objectweb$util$explorer$api$RootContext);
            RootEntry[] entries = rootContext.getEntries();
            for (int i = 0; i < entries.length; ++i) {
                this.addToInitialContext(entries[i]);
            }
        }
        for (int i = 0; i < this.initialContext_.size(); ++i) {
            RootEntry rootEntry = (RootEntry)this.initialContext_.get(i);
            DefaultRootEntry newRootEntry = new DefaultRootEntry(rootEntry.getName(), rootEntry.getValue(), rootEntry.getLevel());
            this.addToInitialContext(newRootEntry);
        }
    }

    protected void addToInitialContext(RootEntry entry) {
        if (entry != null) {
            this.getGraphicalInitialContext().addEntry(entry);
            this.refreshRootNode();
            String id = entry.getName().toString();
            if (!this.alreadyInInitialContext_.contains(id)) {
                TreePath path;
                if (entry.getLevel() > 0 && (path = this.stringToPath(id)) != null) {
                    this.expandPath(path);
                    this.openTree(path, entry.getLevel() - 1);
                }
                this.alreadyInInitialContext_.add(id);
            }
        }
    }

    protected void openTree(TreePath root, int level) {
        if (level > 0) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)root.getLastPathComponent();
            Enumeration<TreeNode> enumeration = node.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)enumeration.nextElement();
                TreePath p = new TreePath(childNode.getPath());
                this.expandPath(p);
                this.openTree(p, level - 1);
            }
        }
    }

    protected void updateInitialPathes(String currentName, String newName) {
        Object[] keys = this.nodeStates_.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            if (!keys[i].toString().startsWith(currentName)) continue;
            String suffixe = ((String)keys[i]).substring(currentName.length());
            String currentPath = currentName + suffixe;
            String newPath = newName + suffixe;
            this.nodeStates_.put(newPath, this.nodeStates_.get(currentPath));
            this.nodeStates_.remove(currentPath);
        }
    }

    protected PropertyResolver getPropertyResolver() {
        try {
            return (PropertyResolver)this.bindingFeature_.lookupFc("property-resolver");
        }
        catch (NoSuchInterfaceException e) {
            this.getTrace().warn("property-resolver: interface not found!");
            return null;
        }
    }

    protected DescriptionInterpreter getDescriptionInterpreter() {
        try {
            return (DescriptionInterpreter)this.bindingFeature_.lookupFc("description-interpreter");
        }
        catch (NoSuchInterfaceException e) {
            this.getTrace().warn("description-interpreter: interface not found!");
            return null;
        }
    }

    protected RoleManager getRoleManager() {
        try {
            return (RoleManager)this.bindingFeature_.lookupFc("role-manager");
        }
        catch (NoSuchInterfaceException e) {
            this.getTrace().warn("role-manager: interface not found!");
            return null;
        }
    }

    protected RoleProvider getRoleProvider() {
        try {
            return (RoleProvider)this.bindingFeature_.lookupFc("role-provider");
        }
        catch (NoSuchInterfaceException e) {
            this.getTrace().warn("role-provider: interface not found!");
            return null;
        }
    }

    protected TextComponent getTextComponent() {
        try {
            return (TextComponent)this.bindingFeature_.lookupFc("text-component");
        }
        catch (NoSuchInterfaceException e) {
            this.getTrace().warn("text-component: interface not found!");
            return null;
        }
    }

    protected org.objectweb.fractal.api.Component getTreeTemplate() {
        try {
            return (org.objectweb.fractal.api.Component)this.bindingFeature_.lookupFc("tree-tmpl");
        }
        catch (NoSuchInterfaceException e) {
            this.getTrace().warn("tree-tmpl: interface not found!");
            return null;
        }
    }

    protected ContextContainerFactory getContextContainerFactory() {
        try {
            return (ContextContainerFactory)this.bindingFeature_.lookupFc("context-container-factory");
        }
        catch (NoSuchInterfaceException e) {
            this.getTrace().warn("context-container-factory: interface not found!");
            return null;
        }
    }

    protected void dispatchSynchronization(TreeView treeView) {
        String[] clientIftNames = this.listFc();
        for (int i = 0; i < clientIftNames.length; ++i) {
            if (!clientIftNames[i].startsWith("synchronization")) continue;
            try {
                ((Synchronization)this.lookupFc(clientIftNames[i])).refresh(treeView);
                continue;
            }
            catch (NoSuchInterfaceException e) {
                this.getTrace().warn(e.getMessage());
                continue;
            }
            catch (Exception e) {
                this.getTrace().warn(e.getMessage());
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.getMessage(), "Error! (" + e.getClass().getName() + ")", 0);
            }
        }
    }

    protected void dispatchSynchronization() {
        this.dispatchSynchronization(this.getTreeView());
    }

    protected void refreshPath(TreePath treePath) {
        this.collapsePath(treePath);
        this.expandPath(treePath);
    }

    protected void refreshRootNode() {
        this.refreshPath(new TreePath(this.rootNode_.getPath()));
    }

    protected void refreshActionMenu(Entry entry) {
        this.refreshActionMenu(entry, this.getParentEntry(), this.getMenuItemTreeView());
    }

    protected void refreshActionMenu(Entry entry, Entry parentEntry, MenuItemTreeView menuItemTreeView) {
        if (this.actionMenu_ != null && entry != null) {
            this.actionMenu_.removeAll();
            Description desc = this.getPropertyResolver().resolve("menu", entry, parentEntry);
            if (desc != null && !desc.isEmpty()) {
                JPopupMenu menu = (JPopupMenu)this.getDescriptionInterpreter().interprete(desc, menuItemTreeView);
                Component[] componentList = menu.getComponents();
                for (int i = 0; i < componentList.length; ++i) {
                    if ((class$javax$swing$JSeparator == null ? DynamicTree.class$("javax.swing.JSeparator") : class$javax$swing$JSeparator).isAssignableFrom(componentList[i].getClass())) {
                        this.actionMenu_.addSeparator();
                        continue;
                    }
                    this.actionMenu_.add((JMenuItem)componentList[i]);
                }
                this.actionMenu_.setEnabled(true);
            } else {
                this.actionMenu_.setEnabled(false);
            }
        }
    }

    protected int displayIconInToolBar(Component[] componentList, boolean ignoreSeparator) {
        boolean iconDisplayed = false;
        int nbDisplayedElements = 0;
        for (int i = 0; i < componentList.length; ++i) {
            if (!(class$javax$swing$JSeparator == null ? DynamicTree.class$("javax.swing.JSeparator") : class$javax$swing$JSeparator).isAssignableFrom(componentList[i].getClass())) {
                if (!((GenericAction)((JMenuItem)componentList[i]).getAction()).isUserIcon()) continue;
                this.toolBar_.add(((JMenuItem)componentList[i]).getAction());
                ++nbDisplayedElements;
                iconDisplayed = true;
                continue;
            }
            if (!iconDisplayed || ignoreSeparator) continue;
            this.toolBar_.addSeparator();
            iconDisplayed = false;
            ++nbDisplayedElements;
        }
        return nbDisplayedElements;
    }

    protected void refreshToolBar(Entry entry) {
        this.refreshToolBar(entry, this.getParentEntry(), this.getMenuItemTreeView());
    }

    protected void refreshToolBar(Entry entry, Entry parentEntry, MenuItemTreeView menuItemTreeView) {
        if (this.toolBar_ != null && entry != null) {
            Description desc;
            if (this.nbElementsToRemove_ > 0) {
                int nbComp = this.toolBar_.getComponentCount();
                for (int i = nbComp - 1; i >= nbComp - this.nbElementsToRemove_; --i) {
                    this.toolBar_.remove(i);
                }
                this.nbElementsToRemove_ = 0;
            }
            if ((desc = this.getPropertyResolver().resolve("menu", entry, parentEntry)) != null && !desc.isEmpty()) {
                JPopupMenu menu = (JPopupMenu)this.getDescriptionInterpreter().interprete(desc, menuItemTreeView);
                this.nbElementsToRemove_ += this.displayIconInToolBar(menu.getComponents(), false);
            }
            if (this.toolBar_.getComponentCount() == 0) {
                this.toolBar_.setVisible(false);
            } else {
                this.toolBar_.setVisible(false);
                this.toolBar_.setVisible(true);
            }
        }
    }

    protected void refreshActionMenu() {
        this.refreshActionMenu(this.getSelectedEntry());
    }

    protected void refreshToolBar() {
        this.refreshToolBar(this.getSelectedEntry());
    }

    protected void refreshAllPathes() {
        String selectedPath = this.pathToString(this.getSelectionPath());
        this.createGraphicalInitialContext();
        this.refreshRootNode();
        this.selectPath(selectedPath);
        Entry selectedEntry = this.getSelectedEntry();
        this.refreshActionMenu(selectedEntry);
        this.refreshToolBar(selectedEntry);
    }

    protected void refreshRoleMenu() {
        block8: {
            if (this.menuBar_ == null) break block8;
            String[] roleList = this.getRoleProvider().getRoleList(true, true);
            String[] currentRoles = this.getRoleManager().getCurrentRoleIds();
            if (this.roleMenu_ == null) {
                this.roleMenu_ = new JMenu("Roles");
                this.menuBar_.add(this.roleMenu_);
            }
            this.roleMenu_.removeAll();
            if (roleList.length <= 0) {
                this.roleMenu_.setVisible(false);
            } else {
                this.roleMenu_.setVisible(true);
                if (this.multipleRoles_) {
                    List<String> theRoles = Arrays.asList(currentRoles);
                    for (int i = 0; i < roleList.length; ++i) {
                        JCheckBoxMenuItem cbMenuItem = new JCheckBoxMenuItem(new RoleSelected(roleList[i]));
                        cbMenuItem.setSelected(theRoles.contains(roleList[i]));
                        this.roleMenu_.add(cbMenuItem);
                    }
                } else {
                    ButtonGroup roleGroup = new ButtonGroup();
                    JRadioButtonMenuItem rbMenuItem = null;
                    for (int i = 0; i < roleList.length; ++i) {
                        rbMenuItem = new JRadioButtonMenuItem(new RoleSelected(roleList[i]));
                        if (currentRoles.length > 0) {
                            rbMenuItem.setSelected(currentRoles[0].equals(roleList[i]));
                        }
                        roleGroup.add(rbMenuItem);
                        this.roleMenu_.add(rbMenuItem);
                    }
                }
            }
        }
    }

    protected DefaultMutableTreeNode addObject(DefaultMutableTreeNode parent, Entry child) {
        Context context;
        Description desc = this.getPropertyResolver().resolve("wrapper", child);
        if (desc != null && (context = (Context)this.getDescriptionInterpreter().interprete(desc, this.getTreeView())) != null) {
            child.setWrapper(this.getContextContainerFactory().create(context));
        }
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child);
        if (parent == null) {
            parent = this.rootNode_;
        }
        this.treeModel_.insertNodeInto(childNode, parent, parent.getChildCount());
        return childNode;
    }

    protected void showMenu(Point p) {
        TreePath path = this.getPath(p);
        if (path != null) {
            this.selectionModel_.setSelectionPath(path);
            Description desc = this.getPropertyResolver().resolve("menu", this.getSelectedEntry(), this.getParentEntry());
            JPopupMenu menu = (JPopupMenu)this.getDescriptionInterpreter().interprete(desc, this.getMenuItemTreeView());
            if (menu != null) {
                menu.show(this, (int)p.getX(), (int)p.getY());
            }
        }
    }

    protected Icon getImageIcon(Entry entry) {
        if (this.getPropertyResolver() != null) {
            Description desc = this.getPropertyResolver().resolve("icon", entry);
            IconProvider iconProvider = (IconProvider)this.getDescriptionInterpreter().interprete(desc, this.getTreeView());
            if (iconProvider != null) {
                Object object = iconProvider.newIcon(entry.getValue());
                if (object instanceof Icon) {
                    return (Icon)object;
                }
                if (object instanceof String) {
                    return (Icon)new IconFileProvider((String)object).newIcon(entry.getValue());
                }
                if (object instanceof URL) {
                    return (Icon)new IconFileProvider((URL)object).newIcon(entry.getValue());
                }
            }
        }
        return null;
    }

    protected void displayInfo(Entry entry) {
        this.displayInfo(entry, this.getTreeView());
    }

    protected void displayInfo(Entry entry, TreeView treeView) {
        if (this.getTextComponent() != null) {
            Info info;
            String message = "";
            Description desc = this.getPropertyResolver().resolve("info", entry);
            if (desc != null && (info = (Info)this.getDescriptionInterpreter().interprete(desc, class$org$objectweb$util$explorer$api$Info == null ? (class$org$objectweb$util$explorer$api$Info = DynamicTree.class$("org.objectweb.util.explorer.api.Info")) : class$org$objectweb$util$explorer$api$Info)) != null) {
                message = info.getInfo(treeView);
            }
            this.getTextComponent().setText(message);
        }
    }

    public void refreshAll() {
        this.refreshAllPathes();
    }

    public void addEntry(Object name, Object value) {
        this.addEntry(name, value, 0);
    }

    public void addEntry(Object name, Object value, int level) {
        DefaultRootEntry rootEntry = new DefaultRootEntry(name, value, level);
        this.initialContext_.add(rootEntry);
        this.addToInitialContext(rootEntry);
    }

    public void selectPath(String path) {
        TreePath treePath = this.stringToPath(path);
        this.setSelectionPath(treePath);
    }

    public void clear() {
        this.initialContext_.clear();
    }

    public int getInitialContextSize() {
        return this.getGraphicalInitialContext().getSize();
    }

    public void removeEntry(Object name) {
        Iterator it = this.initialContext_.iterator();
        RootEntry elementToRemove = null;
        while (it.hasNext()) {
            RootEntry element = (RootEntry)it.next();
            if (!element.getName().toString().equals(name.toString())) continue;
            elementToRemove = element;
            break;
        }
        if (elementToRemove != null) {
            this.initialContext_.remove(elementToRemove);
        }
    }

    public void renameInitialEntry(Object currentName, Object newName) {
        Iterator it = this.initialContext_.iterator();
        while (it.hasNext()) {
            RootEntry element = (RootEntry)it.next();
            if (!element.getName().toString().equals(currentName.toString())) continue;
            element.setName(newName.toString());
            break;
        }
        this.updateInitialPathes(currentName.toString(), newName.toString());
        this.refreshAll();
        this.selectPath(newName.toString());
    }

    public org.objectweb.fractal.api.Component duplicate() {
        return this.duplicate(true);
    }

    public Entry getSelectedEntry() {
        Object object = this.getLastSelectedPathComponent();
        if (object != null) {
            return this.objectToEntry(object);
        }
        return null;
    }

    public org.objectweb.fractal.api.Component duplicate(boolean withData) {
        try {
            org.objectweb.fractal.api.Component tmpl = this.getTreeTemplate();
            Factory factory = (Factory)tmpl.getFcInterface("factory");
            org.objectweb.fractal.api.Component instance = factory.newFcInstance();
            NameController nameController = (NameController)instance.getFcInterface("name-controller");
            nameController.setFcName("tree-cpt-" + System.currentTimeMillis());
            org.objectweb.fractal.api.Component treeComponent = (org.objectweb.fractal.api.Component)this.lookupFc("tree-itself");
            SuperController sc = (SuperController)treeComponent.getFcInterface("super-controller");
            org.objectweb.fractal.api.Component[] superComponents = sc.getFcSuperComponents();
            if (superComponents != null && superComponents.length > 0) {
                org.objectweb.fractal.api.Component superComponent = superComponents[0];
                ContentController cc = (ContentController)superComponent.getFcInterface("content-controller");
                cc.addFcSubComponent(instance);
            }
            BindingController bc = (BindingController)instance.getFcInterface("binding-controller");
            bc.bindFc("property-resolver", this.bindingFeature_.lookupFc("property-resolver"));
            bc.bindFc("description-interpreter", this.bindingFeature_.lookupFc("description-interpreter"));
            bc.bindFc("context-container-factory", this.bindingFeature_.lookupFc("context-container-factory"));
            Fractal.getLifeCycleController((org.objectweb.fractal.api.Component)instance).startFc();
            if (withData) {
                Tree tree = (Tree)instance.getFcInterface("tree");
                Entry[] entries = this.getGraphicalInitialContext().getEntries(null);
                for (int i = 0; i < entries.length; ++i) {
                    try {
                        tree.addEntry(entries[i].getName(), entries[i].getValue(), 1);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            return instance;
        }
        catch (NoSuchInterfaceException ex) {
            ex.printStackTrace();
        }
        catch (IllegalLifeCycleException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalBindingException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException("Error during replication!!!");
        }
        return null;
    }

    public void renameSelectedNode(Object oldName, Object newName) {
        String selectedPath = this.pathToString(this.getSelectionPath());
        int index = selectedPath.lastIndexOf(oldName.toString());
        if (index == -1) {
            return;
        }
        String prefixe = selectedPath.substring(0, index);
        if (!selectedPath.equals(prefixe)) {
            this.updateInitialPathes(prefixe + oldName, prefixe + newName);
            this.refreshAll();
            this.selectPath(prefixe + newName);
        }
    }

    public void close() {
        this.dispatchSynchronization(null);
    }

    public JTree getTree() {
        return this;
    }

    public void setMenuBar(JMenuBar menuBar) {
        this.menuBar_ = menuBar;
        Description desc = this.getPropertyResolver().resolve("menu-bar", this.getSelectedEntry(), this.getParentEntry());
        if (desc != null) {
            JMenu[] menus = (JMenu[])this.getDescriptionInterpreter().interprete(desc, this.getMenuItemTreeView());
            for (int i = 0; i < menus.length; ++i) {
                this.menuBar_.add(menus[i]);
            }
        }
        this.actionMenu_ = new JMenu("Actions");
        this.actionMenu_.setEnabled(false);
        this.menuBar_.add(this.actionMenu_);
        this.refreshRoleMenu();
    }

    public void setToolBar(JToolBar toolBar) {
        this.toolBar_ = toolBar;
        if (this.toolBar_ != null) {
            Description desc = this.getPropertyResolver().resolve("menu-bar", this.getSelectedEntry(), this.getParentEntry());
            if (desc != null) {
                JMenu[] menus = (JMenu[])this.getDescriptionInterpreter().interprete(desc, this.getMenuItemTreeView());
                for (int i = 0; i < menus.length; ++i) {
                    int nbDisplayedElements = this.displayIconInToolBar(menus[i].getMenuComponents(), true);
                    if (nbDisplayedElements <= 0 || i >= menus.length - 1) continue;
                    this.toolBar_.addSeparator();
                }
            }
            if (this.toolBar_.getComponents().length == 0) {
                this.toolBar_.setVisible(false);
            } else {
                this.toolBar_.addSeparator();
            }
        }
    }

    public boolean isMultipleRoles() {
        return this.multipleRoles_;
    }

    public void setCurrentRoles(String[] roleIds) {
        this.getRoleManager().setCurrentRoleIds(roleIds);
        this.refreshRoleMenu();
        this.refreshAllPathes();
    }

    public void setMultipleRoles(boolean multipleRoles) {
        this.multipleRoles_ = multipleRoles;
        this.refreshRoleMenu();
    }

    public boolean isDragAndDropEnabled() {
        return this.dndEnabled_;
    }

    public boolean isPopupEnabled() {
        return this.popupEnabled_;
    }

    public void setDragAndDropEnabled(boolean dndEnabled) {
        this.dndEnabled_ = dndEnabled;
    }

    public void setPopupEnabled(boolean popupEnabled) {
        this.popupEnabled_ = popupEnabled;
    }

    public void bindFc(String itfName, Object itfValue) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        this.bindingFeature_.bindFc(itfName, itfValue);
    }

    public String[] listFc() {
        return this.bindingFeature_.listFc();
    }

    public Object lookupFc(String itfName) throws NoSuchInterfaceException {
        return this.bindingFeature_.lookupFc(itfName);
    }

    public void unbindFc(String itfName) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        this.bindingFeature_.unbindFc(itfName);
    }

    public String getFcState() {
        return null;
    }

    public void startFc() {
    }

    public void stopFc() {
    }

    protected ContextContainer getGraphicalInitialContext() {
        if (this.graphicalInitialContext_ == null) {
            this.graphicalInitialContext_ = this.getContextContainerFactory().create(new RootContextContainer());
            this.rootNode_ = new DefaultMutableTreeNode(new DefaultEntry("Root", this.graphicalInitialContext_));
            this.treeModel_ = new MyTreeModel(this.rootNode_);
            this.setModel(this.treeModel_);
        }
        return this.graphicalInitialContext_;
    }

    public String getToolTipText(MouseEvent evt) {
        StringBuffer label = new StringBuffer();
        TreePath currentPath = this.getPathForLocation(evt.getX(), evt.getY());
        if (currentPath != null) {
            String[] labels;
            Entry entry = this.objectToEntry(currentPath.getLastPathComponent());
            DnDDescriptions desc = (DnDDescriptions)this.getPropertyResolver().resolve("dnd", entry);
            if (desc != null && !desc.isEmpty() && (labels = desc.getActionsDescription()).length > 0) {
                label.append("<html>");
                label.append("Drop action:");
                for (int i = 0; i < labels.length; ++i) {
                    label.append("<br> - " + labels[i]);
                }
                label.append("</html>");
            }
        }
        return label.toString();
    }

    public void autoscroll(Point cursorLocn) {
        Rectangle rect = this.getVisibleRect();
        Dimension dim = this.getSize();
        if (cursorLocn.y > rect.y + rect.height - 10) {
            rect.y = Math.min(rect.y + 10, dim.height - rect.height);
        } else if (cursorLocn.y < rect.y + 10) {
            int i = rect.y + rect.height - 10;
            rect.y = Math.max(rect.y - 10, 0);
        }
        if (cursorLocn.x > rect.x + rect.width - 10) {
            rect.x = Math.min(rect.x + 10, dim.width - rect.width);
        } else if (cursorLocn.x < rect.x + 10) {
            rect.x = Math.max(rect.x - 10, 0);
        }
        this.scrollRectToVisible(rect);
    }

    public Insets getAutoscrollInsets() {
        Rectangle rect = this.getVisibleRect();
        Dimension dim = this.getSize();
        Insets inset = new Insets(rect.y + 10, rect.x + 10, dim.height - (rect.y + rect.height) + 10, dim.width - (rect.x + rect.width) + 10);
        return inset;
    }

    public void refreshGUI(Object object) {
        DefaultEntry entry = new DefaultEntry("SELECTED", object);
        this.displayInfo(entry, new DefaultTreeView(this, entry, null));
        this.refreshActionMenu(entry, null, new DefaultMenuItemTreeView(this, entry, null));
        this.refreshToolBar(entry, null, new DefaultMenuItemTreeView(this, entry, null));
    }

    public JPopupMenu getJPopupMenu(Object object) {
        DefaultEntry entry = new DefaultEntry("SELECTED", object);
        Description desc = this.getPropertyResolver().resolve("menu", entry, null);
        return (JPopupMenu)this.getDescriptionInterpreter().interprete(desc, new DefaultMenuItemTreeView(this, entry, null));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected final class RoleSelected
    extends AbstractAction {
        protected String roleId_;

        public RoleSelected(String roleId) {
            super(roleId);
            this.roleId_ = roleId;
        }

        public void actionPerformed(ActionEvent e) {
            if (DynamicTree.this.multipleRoles_) {
                String[] currentRoles = DynamicTree.this.getRoleManager().getCurrentRoleIds();
                Vector<String> theRoles = new Vector<String>(Arrays.asList(currentRoles));
                if (theRoles.contains(this.roleId_)) {
                    theRoles.remove(this.roleId_);
                } else {
                    theRoles.add(this.roleId_);
                }
                DynamicTree.this.getRoleManager().setCurrentRoleIds(theRoles.toArray(new String[theRoles.size()]));
            } else {
                String currentRoleId = DynamicTree.this.getRoleManager().getCurrentRoleIds()[0];
                if (!this.roleId_.equals(currentRoleId)) {
                    DynamicTree.this.getRoleManager().setCurrentRoleIds(new String[]{this.roleId_});
                }
            }
            DynamicTree.this.refreshAllPathes();
        }
    }

    protected class TreeDropTargetListener
    implements DropTargetListener {
        protected TreePath oldPath_ = null;
        protected boolean actionChanged_ = false;

        protected TreeDropTargetListener() {
        }

        protected String getDropActionName(int dropAction) {
            if (dropAction == 2) {
                return "move";
            }
            if (dropAction == 1) {
                return "copy";
            }
            if (dropAction == 0x40000000) {
                return "link";
            }
            return "";
        }

        protected String computeActionDesc(Entry entry, String dropAction) {
            DnDDescription dndDesc;
            DnDDescriptions desc = (DnDDescriptions)DynamicTree.this.getPropertyResolver().resolve("dnd", entry);
            if (desc != null && (dndDesc = desc.getDropAction(dropAction)) != null) {
                return dndDesc.getLabel();
            }
            return "";
        }

        public void dragEnter(DropTargetDragEvent dtde) {
            dtde.acceptDrag(dtde.getDropAction());
        }

        public void dragOver(DropTargetDragEvent dtde) {
            dtde.acceptDrag(dtde.getDropAction());
            String label = "";
            TreePath path = DynamicTree.this.getPath(dtde.getLocation());
            if (path == null) {
                this.oldPath_ = null;
                if (DynamicTree.this.getTextComponent() != null) {
                    DynamicTree.this.getTextComponent().setText("");
                }
            } else if (this.oldPath_ == null || path != null && !path.equals(this.oldPath_) || this.actionChanged_) {
                this.actionChanged_ = false;
                this.oldPath_ = path;
                Entry entry = DynamicTree.this.objectToEntry(path.getLastPathComponent());
                String value = this.computeActionDesc(entry, this.getDropActionName(dtde.getDropAction()));
                if (DynamicTree.this.getTextComponent() != null) {
                    DynamicTree.this.getTextComponent().setText(value);
                }
            }
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
            dtde.acceptDrag(dtde.getDropAction());
            this.actionChanged_ = true;
        }

        public void dragExit(DropTargetEvent dte) {
        }

        public void drop(DropTargetDropEvent dtde) {
            DataFlavor[] df = EntryTransferable.flavors_;
            DataFlavor chosen = null;
            for (int i = 0; i < df.length; ++i) {
                if (!dtde.isDataFlavorSupported(df[i])) continue;
                chosen = df[i];
                break;
            }
            if (DynamicTree.this.getTextComponent() != null) {
                DynamicTree.this.getTextComponent().setText("");
            }
            Entry dragEntry = null;
            try {
                dragEntry = (Entry)dtde.getTransferable().getTransferData(chosen);
            }
            catch (UnsupportedFlavorException e1) {
                DynamicTree.this.getTrace().warn("[" + this.getClass().getName() + "] UnsupportedFlavorException: " + e1.getMessage());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            TreePath path = DynamicTree.this.getPath(dtde.getLocation());
            if (path != null) {
                DropAction dropAction;
                DnDDescription dndDesc;
                DynamicTree.this.selectionModel.setSelectionPath(path);
                Entry dropEntry = DynamicTree.this.objectToEntry(DynamicTree.this.getLastSelectedPathComponent());
                DnDDescriptions desc = (DnDDescriptions)DynamicTree.this.getPropertyResolver().resolve("dnd", dropEntry);
                if (desc != null && (dndDesc = desc.getDropAction(this.getDropActionName(dtde.getDropAction()))) != null && (dropAction = (DropAction)DynamicTree.this.getDescriptionInterpreter().interprete(dndDesc.getCodeDescription(), class$org$objectweb$util$explorer$api$DropAction == null ? (class$org$objectweb$util$explorer$api$DropAction = DynamicTree.class$("org.objectweb.util.explorer.api.DropAction")) : class$org$objectweb$util$explorer$api$DropAction)) != null && dragEntry != null) {
                    try {
                        dropAction.execute(new DefaultDropTreeView(DynamicTree.this, dropEntry, DynamicTree.this.getParentEntry(), dragEntry));
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, e.getMessage(), "Drag & Drop error ! (" + e.getClass().getName() + ")", 0);
                    }
                    DynamicTree.this.refreshAllPathes();
                }
            }
        }
    }

    public class TreeDragSourceListener
    implements DragSourceListener {
        protected int dropAction_;

        protected int getDropAction(int gestureModifiers) {
            if (gestureModifiers == 16) {
                return 2;
            }
            if (gestureModifiers == 18) {
                return 1;
            }
            if (gestureModifiers == 19) {
                return 0x40000000;
            }
            return 0;
        }

        protected void setIcon(DragSourceDragEvent dsde) {
            DragSourceContext context = dsde.getDragSourceContext();
            this.dropAction_ = this.getDropAction(dsde.getGestureModifiers());
            if (this.dropAction_ == 1) {
                context.setCursor(DragSource.DefaultCopyDrop);
            } else if (this.dropAction_ == 2) {
                context.setCursor(DragSource.DefaultMoveDrop);
            } else if (this.dropAction_ == 0x40000000) {
                context.setCursor(DragSource.DefaultLinkDrop);
            } else {
                context.setCursor(DragSource.DefaultLinkNoDrop);
            }
        }

        protected void setForbiddenIcon(DragSourceEvent dse) {
            DragSourceContext context = dse.getDragSourceContext();
            if (this.dropAction_ == 1) {
                context.setCursor(DragSource.DefaultCopyNoDrop);
            } else if (this.dropAction_ == 2) {
                context.setCursor(DragSource.DefaultMoveNoDrop);
            } else if (this.dropAction_ == 0x40000000) {
                context.setCursor(DragSource.DefaultLinkNoDrop);
            } else {
                context.setCursor(DragSource.DefaultLinkNoDrop);
            }
        }

        public void dragEnter(DragSourceDragEvent dsde) {
            this.setIcon(dsde);
        }

        public void dragOver(DragSourceDragEvent dsde) {
        }

        public void dropActionChanged(DragSourceDragEvent dsde) {
            this.setIcon(dsde);
        }

        public void dragExit(DragSourceEvent dse) {
            this.setForbiddenIcon(dse);
        }

        public void dragDropEnd(DragSourceDropEvent dsde) {
        }
    }

    protected class TreeDragGestureListener
    implements DragGestureListener {
        protected TreeDragGestureListener() {
        }

        public void dragGestureRecognized(DragGestureEvent dge) {
            if (DynamicTree.this.dndEnabled_) {
                EntryTransferable transferable = new EntryTransferable(DynamicTree.this.getSelectedEntry());
                try {
                    DynamicTree.this.dragSource_.startDrag(dge, DragSource.DefaultLinkDrop, transferable, DynamicTree.this.dragSourceListener_);
                }
                catch (InvalidDnDOperationException idoe) {
                    System.out.println(idoe);
                }
            }
        }
    }

    final class MyTreeModel
    extends DefaultTreeModel {
        public MyTreeModel(TreeNode root) {
            super(root);
        }

        public boolean isLeaf(Object node) {
            Entry entry = DynamicTree.this.objectToEntry(node);
            return entry.getWrapper() == null && !(entry.getValue() instanceof Context);
        }
    }

    final class MyTreeSelectionListener
    implements TreeSelectionListener {
        MyTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            Entry selectedEntry = DynamicTree.this.getSelectedEntry();
            DynamicTree.this.displayInfo(selectedEntry);
            DynamicTree.this.refreshActionMenu(selectedEntry);
            DynamicTree.this.refreshToolBar(selectedEntry);
            DynamicTree.this.dispatchSynchronization();
        }
    }

    final class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        MyTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            Entry entry = DynamicTree.this.objectToEntry(value);
            Icon icon = DynamicTree.this.getImageIcon(entry);
            if (icon != null) {
                this.setIcon(icon);
            }
            this.setText(entry.getName().toString());
            return this;
        }
    }

    final class MyTreeExpansionListener
    implements TreeExpansionListener {
        MyTreeExpansionListener() {
        }

        public void treeCollapsed(TreeExpansionEvent event) {
        }

        public void treeExpanded(TreeExpansionEvent event) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
            if (!node.isLeaf()) {
                Enumeration<TreeNode> enumeration = node.children();
                while (enumeration.hasMoreElements()) {
                    DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)enumeration.nextElement();
                    Entry entry = (Entry)childNode.getUserObject();
                    String pathName = DynamicTree.this.pathToString(childNode);
                    if (!DynamicTree.this.nodeStates_.containsKey(pathName) || !((Boolean)DynamicTree.this.nodeStates_.get(pathName)).booleanValue()) continue;
                    DynamicTree.this.expandPath(new TreePath(childNode.getPath()));
                }
            }
        }
    }

    final class MyTreeWillExpandListener
    implements TreeWillExpandListener {
        MyTreeWillExpandListener() {
        }

        public void treeWillCollapse(TreeExpansionEvent event) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
            Entry e = (Entry)currentNode.getUserObject();
            DynamicTree.this.nodeStates_.put(DynamicTree.this.pathToString(currentNode), Boolean.FALSE);
        }

        public void treeWillExpand(TreeExpansionEvent event) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
            Entry e = (Entry)currentNode.getUserObject();
            DynamicTree.this.nodeStates_.put(DynamicTree.this.pathToString(currentNode), Boolean.TRUE);
            currentNode.removeAllChildren();
            Entry[] entries = e.getWrapper().getEntries(e.getValue());
            for (int i = 0; i < entries.length; ++i) {
                DefaultMutableTreeNode childNode = DynamicTree.this.addObject(currentNode, entries[i]);
            }
            DynamicTree.this.treeModel_.reload(currentNode);
        }
    }

    final class MyMouseAdapter
    extends MouseAdapter {
        MyMouseAdapter() {
        }

        public void mousePressed(MouseEvent e) {
            this.popupLayout(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.popupLayout(e);
        }

        private void popupLayout(MouseEvent e) {
            if (e.isPopupTrigger() && DynamicTree.this.popupEnabled_) {
                DynamicTree.this.showMenu(e.getPoint());
            }
        }
    }
}

