/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.swt.lib;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.util.explorer.api.Context;
import org.objectweb.util.explorer.api.DropAction;
import org.objectweb.util.explorer.api.Entry;
import org.objectweb.util.explorer.api.IconProvider;
import org.objectweb.util.explorer.api.Info;
import org.objectweb.util.explorer.api.MenuItemTreeView;
import org.objectweb.util.explorer.api.TreeView;
import org.objectweb.util.explorer.core.common.api.Description;
import org.objectweb.util.explorer.core.common.api.TextComponent;
import org.objectweb.util.explorer.core.common.lib.BindingFeature;
import org.objectweb.util.explorer.core.common.lib.DefaultTreeView;
import org.objectweb.util.explorer.core.common.lib.TreeBindingFeature;
import org.objectweb.util.explorer.core.dnd.api.DnDDescription;
import org.objectweb.util.explorer.core.dnd.api.DnDDescriptions;
import org.objectweb.util.explorer.core.dnd.lib.DefaultDropTreeView;
import org.objectweb.util.explorer.core.menu.api.MenuDescription;
import org.objectweb.util.explorer.core.menu.lib.DefaultMenuItemTreeView;
import org.objectweb.util.explorer.core.naming.lib.DefaultEntry;
import org.objectweb.util.explorer.interpreter.api.DescriptionInterpreter;
import org.objectweb.util.explorer.interpreter.lib.swt.IconFileProvider;
import org.objectweb.util.explorer.resolver.api.PropertyResolver;
import org.objectweb.util.explorer.swt.api.Explorer;
import org.objectweb.util.explorer.swt.lib.EntryTransfer;
import org.objectweb.util.trace.Trace;
import org.objectweb.util.trace.TraceSystem;

public class DynamicTree
extends Tree
implements org.objectweb.util.explorer.api.Tree,
BindingController,
Explorer {
    protected BindingFeature bindingFeature_ = null;
    protected Display display_ = null;
    public static Shell shell_ = null;
    protected Map nodeStates_ = null;
    protected Vector initialContext_ = null;
    protected Menu menuBar_ = null;
    protected MenuItem actionMenu_ = null;
    static /* synthetic */ Class class$org$objectweb$util$explorer$api$Context;
    static /* synthetic */ Class class$org$objectweb$util$explorer$api$IconProvider;
    static /* synthetic */ Class class$org$objectweb$util$explorer$api$Info;
    static /* synthetic */ Class class$org$objectweb$util$explorer$api$DropAction;

    private void initDragAndDrop() {
        Transfer[] types = new Transfer[]{EntryTransfer.getInstance()};
        int operations = 7;
        DragSource source = new DragSource((Control)this, operations);
        source.setTransfer(types);
        source.addDragListener((DragSourceListener)new MyDragSourceListener());
        DropTarget target = new DropTarget((Control)this, operations);
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)new MyDropTargetAdapter());
    }

    public DynamicTree() {
        super((Composite)new Shell(), 2048);
        this.setSize(400, 500);
        this.bindingFeature_ = new TreeBindingFeature();
        this.nodeStates_ = new HashMap();
        this.initialContext_ = new Vector();
        this.addListener(17, new MyExpensionListener());
        this.addListener(35, new MyMenuDetectListener());
        this.addListener(3, new MyMouseDownListener());
        this.addListener(13, new MySelectionListener());
        this.addTreeListener(new MyTreeListener());
        this.initDragAndDrop();
    }

    protected Trace getTrace() {
        return TraceSystem.get((String)"explorer");
    }

    protected Entry getTheSelectedEntry() {
        TreeItem[] items = this.getSelection();
        if (items != null && items.length > 0) {
            return (Entry)items[0].getData();
        }
        return null;
    }

    protected Entry getParentEntry() {
        TreeItem[] items = this.getSelection();
        if (items[0].getParentItem() != null) {
            return (Entry)items[0].getParentItem().getData();
        }
        return null;
    }

    protected TreeView getTreeView() {
        return new DefaultTreeView(this, this.getTheSelectedEntry(), this.getParentEntry());
    }

    protected MenuItemTreeView getMenuItemTreeView() {
        return new DefaultMenuItemTreeView(this, this.getTheSelectedEntry(), this.getParentEntry());
    }

    protected void addInitialEntry(Entry entry) {
        TreeItem item = new TreeItem((Tree)this, 0);
        item.setText(entry.getName().toString());
        item.setData((Object)entry);
        this.completeTreeItem(item);
        item.setExpanded(true);
    }

    protected void completeTreeItem(TreeItem treeItem) {
        Entry entry = (Entry)treeItem.getData();
        Image image = this.getImageIcon(entry);
        if (image != null) {
            treeItem.setImage(image);
        }
        if (entry.getWrapper() != null) {
            new TreeItem(treeItem, 0);
        } else {
            Context childContext;
            Description desc = this.getPropertyResolver().resolve("wrapper", entry);
            if (desc != null && (childContext = (Context)this.getDescriptionInterpreter().interprete(desc, class$org$objectweb$util$explorer$api$Context == null ? (class$org$objectweb$util$explorer$api$Context = DynamicTree.class$("org.objectweb.util.explorer.api.Context")) : class$org$objectweb$util$explorer$api$Context)) != null) {
                entry.setWrapper(childContext);
                new TreeItem(treeItem, 0);
            }
        }
    }

    protected String pathToString(TreeItem item) {
        if (item != null) {
            TreeItem current = item;
            String value = current.getText();
            while ((current = current.getParentItem()) != null) {
                value = current.getText() + "/" + value;
            }
            return value;
        }
        return "";
    }

    protected PropertyResolver getPropertyResolver() {
        try {
            return (PropertyResolver)this.bindingFeature_.lookupFc("property-resolver");
        }
        catch (NoSuchInterfaceException e) {
            this.getTrace().warn("property-resolver: interface not found!");
            return null;
        }
    }

    protected DescriptionInterpreter getDescriptionInterpreter() {
        try {
            return (DescriptionInterpreter)this.bindingFeature_.lookupFc("description-interpreter");
        }
        catch (NoSuchInterfaceException e) {
            this.getTrace().warn("description-interpreter: interface not found!");
            return null;
        }
    }

    protected TextComponent getTextComponent() {
        try {
            return (TextComponent)this.bindingFeature_.lookupFc("text-component");
        }
        catch (NoSuchInterfaceException e) {
            this.getTrace().warn("text-component: interface not found!");
            return null;
        }
    }

    protected Image getImageIcon(Entry entry) {
        Description desc = this.getPropertyResolver().resolve("icon", entry);
        IconProvider iconProvider = (IconProvider)this.getDescriptionInterpreter().interprete(desc, class$org$objectweb$util$explorer$api$IconProvider == null ? (class$org$objectweb$util$explorer$api$IconProvider = DynamicTree.class$("org.objectweb.util.explorer.api.IconProvider")) : class$org$objectweb$util$explorer$api$IconProvider);
        if (iconProvider != null) {
            Object object = iconProvider.newIcon(entry.getValue());
            if (object instanceof Image) {
                return (Image)object;
            }
            if (object instanceof String) {
                return (Image)new IconFileProvider((String)object).newIcon(entry.getValue());
            }
            if (object instanceof URL) {
                return (Image)new IconFileProvider((URL)object).newIcon(entry.getValue());
            }
        }
        return null;
    }

    protected void displayInfo(Entry entry) {
        if (this.getTextComponent() != null) {
            Info info;
            String message = "";
            Description desc = this.getPropertyResolver().resolve("info", entry);
            if (desc != null && (info = (Info)this.getDescriptionInterpreter().interprete(desc, class$org$objectweb$util$explorer$api$Info == null ? (class$org$objectweb$util$explorer$api$Info = DynamicTree.class$("org.objectweb.util.explorer.api.Info")) : class$org$objectweb$util$explorer$api$Info)) != null) {
                message = info.getInfo(this.getTreeView());
            }
            this.getTextComponent().setText(message);
        }
    }

    protected void refreshAllPathes() {
        System.out.println("---- BEGIN refreshAllPathes ----");
        this.removeAll();
        Iterator it = this.initialContext_.iterator();
        while (it.hasNext()) {
            Entry entry = (Entry)it.next();
            System.out.println("=> Adds " + entry.getName());
            this.addInitialEntry(entry);
        }
        System.out.println("---- END refreshAllPathes ----");
    }

    protected void refreshActionItem(Entry entry) {
        if (this.actionMenu_ != null && entry != null) {
            Description desc = this.getPropertyResolver().resolve("menu", entry, this.getParentEntry());
            if (desc != null && !desc.isEmpty()) {
                ((MenuDescription)desc).setDescriptionType("bar");
                Menu menu = (Menu)this.getDescriptionInterpreter().interprete(desc, this.getMenuItemTreeView());
                this.actionMenu_.setMenu(menu);
                this.actionMenu_.setEnabled(true);
            } else {
                this.actionMenu_.setEnabled(false);
            }
        }
    }

    protected void refreshActionItem() {
        this.refreshActionItem(this.getTheSelectedEntry());
    }

    public void refreshAll() {
        this.refreshAllPathes();
    }

    public void addEntry(Object name, Object value) {
        if (name != null && value != null) {
            DefaultEntry entry = new DefaultEntry(name, value);
            this.addInitialEntry(entry);
            this.initialContext_.add(entry);
        }
    }

    public void addEntry(Object name, Object value, int level) {
        throw new RuntimeException("NOT IMPLEMENTED YET!");
    }

    public void selectPath(String path) {
        throw new RuntimeException("NOT IMPLEMENTED YET!");
    }

    public void clear() {
        throw new RuntimeException("NOT IMPLEMENTED YET!");
    }

    public int getInitialContextSize() {
        throw new RuntimeException("NOT IMPLEMENTED YET!");
    }

    public void removeEntry(Object name) {
        throw new RuntimeException("NOT IMPLEMENTED YET!");
    }

    public void renameInitialEntry(Object currentName, Object newName) {
        throw new RuntimeException("NOT IMPLEMENTED YET!");
    }

    public Component duplicate() {
        throw new RuntimeException("NOT IMPLEMENTED YET!");
    }

    public Component duplicate(boolean withData) {
        throw new RuntimeException("NOT IMPLEMENTED YET!");
    }

    public Entry getSelectedEntry() {
        throw new RuntimeException("NOT IMPLEMENTED YET!");
    }

    public void renameSelectedNode(Object odlName, Object newName) {
        throw new RuntimeException("NOT IMPLEMENTED YET!");
    }

    public void close() {
        throw new RuntimeException("NOT IMPLEMENTED YET!");
    }

    public Tree getTree() {
        return this;
    }

    public void setDisplay(Display display) {
        this.display_ = display;
    }

    public void setShell(Shell shell) {
        shell_ = shell;
    }

    public void setMenuBar(Menu menu) {
        if (menu != null) {
            this.menuBar_ = menu;
            this.actionMenu_ = new MenuItem(menu, 64);
            this.actionMenu_.setText("Actions");
            this.actionMenu_.setEnabled(false);
        }
    }

    public void bindFc(String itfName, Object itfValue) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        this.bindingFeature_.bindFc(itfName, itfValue);
    }

    public String[] listFc() {
        return this.bindingFeature_.listFc();
    }

    public Object lookupFc(String itfName) throws NoSuchInterfaceException {
        return this.bindingFeature_.lookupFc(itfName);
    }

    public void unbindFc(String itfName) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        this.bindingFeature_.unbindFc(itfName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class MyDropTargetAdapter
    extends DropTargetAdapter {
        protected Entry dragEntry = null;
        protected TreeItem oldItem_ = null;
        protected boolean actionChanged_ = false;

        protected MyDropTargetAdapter() {
        }

        protected String getDropActionName(int dropAction) {
            if (dropAction == 2) {
                return "move";
            }
            if (dropAction == 1) {
                return "copy";
            }
            if (dropAction == 4) {
                return "link";
            }
            return "";
        }

        protected String computeActionDesc(Entry entry, String dropAction) {
            DnDDescription dndDesc;
            DnDDescriptions desc = (DnDDescriptions)DynamicTree.this.getPropertyResolver().resolve("dnd", entry);
            if (desc != null && (dndDesc = desc.getDropAction(dropAction)) != null) {
                return dndDesc.getLabel();
            }
            return "";
        }

        public void dragEnter(DropTargetEvent event) {
            super.dragEnter(event);
            this.dragEntry = DynamicTree.this.getTheSelectedEntry();
        }

        public void dragLeave(DropTargetEvent event) {
            super.dragLeave(event);
        }

        public void dragOperationChanged(DropTargetEvent event) {
            super.dragOperationChanged(event);
            this.actionChanged_ = true;
        }

        public void dragOver(DropTargetEvent event) {
            event.feedback = 25;
            TreeItem currentItem = (TreeItem)event.item;
            if (currentItem == null) {
                this.oldItem_ = null;
                if (DynamicTree.this.getTextComponent() != null) {
                    DynamicTree.this.getTextComponent().setText("");
                }
            } else if (this.oldItem_ == null || currentItem != null && !currentItem.equals(this.oldItem_) || this.actionChanged_) {
                this.actionChanged_ = false;
                this.oldItem_ = currentItem;
                String value = this.computeActionDesc((Entry)currentItem.getData(), this.getDropActionName(event.detail));
                if (DynamicTree.this.getTextComponent() != null) {
                    DynamicTree.this.getTextComponent().setText(value);
                }
            }
        }

        public void drop(DropTargetEvent event) {
            super.drop(event);
            if (event.data == null) {
                event.detail = 0;
                return;
            }
            if (DynamicTree.this.getTextComponent() != null) {
                DynamicTree.this.getTextComponent().setText("");
            }
            if (event.item != null) {
                DropAction dropAction;
                DnDDescription dndDesc;
                TreeItem item = (TreeItem)event.item;
                Entry dropEntry = (Entry)item.getData();
                DnDDescriptions desc = (DnDDescriptions)DynamicTree.this.getPropertyResolver().resolve("dnd", dropEntry);
                if (desc != null && (dndDesc = desc.getDropAction(this.getDropActionName(event.detail))) != null && (dropAction = (DropAction)DynamicTree.this.getDescriptionInterpreter().interprete(dndDesc.getCodeDescription(), class$org$objectweb$util$explorer$api$DropAction == null ? (class$org$objectweb$util$explorer$api$DropAction = DynamicTree.class$("org.objectweb.util.explorer.api.DropAction")) : class$org$objectweb$util$explorer$api$DropAction)) != null && this.dragEntry != null) {
                    try {
                        dropAction.execute(new DefaultDropTreeView(DynamicTree.this, dropEntry, DynamicTree.this.getParentEntry(), this.dragEntry));
                    }
                    catch (Exception e) {
                        DynamicTree.this.getTrace().warn(((Object)((Object)this)).getClass().getName() + ", " + e.getClass().getName() + ": " + e.getMessage());
                        MessageBox mb = new MessageBox(shell_, 33);
                        mb.setMessage(e.getClass().getName() + ":\n" + e.getMessage());
                        mb.setText("Exception (" + event.widget + ")");
                        mb.open();
                    }
                    DynamicTree.this.refreshAllPathes();
                }
            }
        }

        public void dropAccept(DropTargetEvent event) {
            super.dropAccept(event);
        }
    }

    protected class MyDragSourceListener
    implements DragSourceListener {
        protected Entry dragSourceEntry = null;

        protected MyDragSourceListener() {
        }

        public void dragStart(DragSourceEvent event) {
            this.dragSourceEntry = DynamicTree.this.getTheSelectedEntry();
        }

        public void dragFinished(DragSourceEvent event) {
        }

        public void dragSetData(DragSourceEvent event) {
            event.data = this.dragSourceEntry;
        }
    }

    final class MyTreeListener
    implements TreeListener {
        MyTreeListener() {
        }

        public void treeCollapsed(TreeEvent e) {
            DynamicTree.this.nodeStates_.put(DynamicTree.this.pathToString((TreeItem)e.item), Boolean.FALSE);
        }

        public void treeExpanded(TreeEvent e) {
            TreeItem item = (TreeItem)e.item;
            DynamicTree.this.getTrace().debug("treeExpanded: " + item.getText());
            DynamicTree.this.nodeStates_.put(DynamicTree.this.pathToString(item), Boolean.TRUE);
            TreeItem[] children = item.getItems();
            for (int i = 0; i < children.length; ++i) {
                TreeItem child = children[i];
                String childPath = DynamicTree.this.pathToString(child);
                if (!DynamicTree.this.nodeStates_.containsKey(childPath) || !((Boolean)DynamicTree.this.nodeStates_.get(childPath)).booleanValue()) continue;
                DynamicTree.this.getTrace().debug("Expand " + child.getText());
                TreeItem[] children2 = child.getItems();
                for (int j = 0; j < children2.length; ++j) {
                    children2[j].dispose();
                }
                child.setExpanded(true);
                DynamicTree.this.setRedraw(true);
            }
        }
    }

    final class MySelectionListener
    implements Listener {
        MySelectionListener() {
        }

        public void handleEvent(Event e) {
            Entry entry = DynamicTree.this.getTheSelectedEntry();
            DynamicTree.this.displayInfo(entry);
            DynamicTree.this.refreshActionItem(entry);
        }
    }

    final class MyMouseDownListener
    implements Listener {
        MyMouseDownListener() {
        }

        public void handleEvent(Event e) {
        }
    }

    final class MyMenuDetectListener
    implements Listener {
        MyMenuDetectListener() {
        }

        public void handleEvent(Event e) {
            Description desc;
            Entry entry = DynamicTree.this.getTheSelectedEntry();
            if (entry != null && (desc = DynamicTree.this.getPropertyResolver().resolve("menu", entry, DynamicTree.this.getParentEntry())) != null) {
                ((MenuDescription)desc).setDescriptionType("popup");
                Menu menu = (Menu)DynamicTree.this.getDescriptionInterpreter().interprete(desc, DynamicTree.this.getMenuItemTreeView());
                if (menu != null) {
                    menu.setLocation(e.x, e.y);
                    menu.setVisible(true);
                    while (!menu.isDisposed() && menu.isVisible()) {
                        if (DynamicTree.this.display_.readAndDispatch()) continue;
                        DynamicTree.this.display_.sleep();
                    }
                    menu.dispose();
                }
            }
        }
    }

    final class MyExpensionListener
    implements Listener {
        MyExpensionListener() {
        }

        public void handleEvent(Event e) {
            TreeItem currentItem = (TreeItem)e.item;
            DynamicTree.this.getTrace().debug("Expension listener: " + currentItem.getText());
            TreeItem[] itemChildren = currentItem.getItems();
            for (int i = 0; i < itemChildren.length; ++i) {
                if (itemChildren[i].getData() != null) {
                    return;
                }
                itemChildren[i].dispose();
            }
            Entry currentEntry = (Entry)currentItem.getData();
            Context context = currentEntry.getWrapper();
            Entry[] children = context.getEntries(currentEntry.getValue());
            for (int i = 0; i < children.length; ++i) {
                TreeItem item = new TreeItem(currentItem, 0);
                item.setText(children[i].getName().toString());
                item.setData((Object)children[i]);
                DynamicTree.this.completeTreeItem(item);
            }
        }
    }
}

