/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia.asm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.fractal.julia.asm.ClassGenerationException;
import org.objectweb.fractal.julia.asm.ClassGenerator;
import org.objectweb.fractal.julia.asm.ClassVersionHelper;
import org.objectweb.fractal.julia.asm.IllegalClassDescriptorException;
import org.objectweb.fractal.julia.loader.Loader;
import org.objectweb.fractal.julia.loader.Tree;

public class ContextClassGenerator
implements Opcodes,
ClassGenerator {
    private static final String SUPER = "org/objectweb/fractal/julia/InitializationContext";
    private static final String[] OPTIMIZATIONS = new String[]{"none", "mergeControllers", "mergeControllersAndInterceptors", "mergeControllersAndContent", "mergeControllersInterceptorsAndContent"};
    private String name;
    private ClassVisitor cv;
    private Tree args;
    private Loader loader;
    private ClassLoader classLoader;
    private Tree interfaceTypes;
    private Tree[] controllerTrees;
    private List controllerClasses;
    private Class contentClass;
    private Object controllerDesc;

    public byte[] generateClass(String name, Tree args, Loader loader, ClassLoader classLoader) throws ClassGenerationException {
        this.name = name.replace('.', '/');
        this.cv = new ClassWriter(1);
        this.args = args;
        this.loader = loader;
        this.classLoader = classLoader;
        this.cv.visit(ClassVersionHelper.getClassVersion(), 1, this.name, null, SUPER, new String[]{"org/objectweb/fractal/julia/loader/Generated"});
        this.cv.visitSource(null, null);
        FieldVisitor fv = this.cv.visitField(10, "componentType", "Lorg/objectweb/fractal/api/type/ComponentType;", null, null);
        if (fv != null) {
            fv.visitEnd();
        }
        if ((fv = this.cv.visitField(10, "internalComponentType", "Lorg/objectweb/fractal/api/type/ComponentType;", null, null)) != null) {
            fv.visitEnd();
        }
        MethodVisitor mv = this.cv.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, SUPER, "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = this.cv.visitMethod(1, "create", "()V", null, new String[]{"org/objectweb/fractal/api/factory/InstantiationException"});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, SUPER, "create", "()V");
        this.computeInterfaceTypes();
        this.generateCreateType(mv);
        this.generateCreateControllers(mv);
        this.generateCreateContent(mv);
        this.generateCreateInterfaces(mv);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        String mName = "getFcGeneratorParameters";
        String mDesc = "()Ljava/lang/String;";
        mv = this.cv.visitMethod(1, mName, mDesc, null, null);
        mv.visitCode();
        mv.visitLdcInsn((Object)args.toString());
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        this.cv.visitEnd();
        return ((ClassWriter)this.cv).toByteArray();
    }

    public void computeInterfaceTypes() {
        Tree[] functionalItfs = this.args.getSubTree(1).getSubTrees();
        Tree[] controlItfs = this.args.getSubTree(2).getSubTree(0).getSubTree(1).getSubTrees();
        Tree[] allItfs = new Tree[functionalItfs.length + controlItfs.length];
        int i = 0;
        while (i < controlItfs.length) {
            allItfs[i] = new Tree(new Tree[]{controlItfs[i].getSubTree(0), controlItfs[i].getSubTree(1), new Tree("false"), new Tree("false"), new Tree("false")});
            ++i;
        }
        int i2 = 0;
        while (i2 < functionalItfs.length) {
            allItfs[i2 + controlItfs.length] = functionalItfs[i2];
            ++i2;
        }
        this.interfaceTypes = new Tree(allItfs);
    }

    public void generateCreateType(MethodVisitor mv) {
        Label l = new Label();
        mv.visitFieldInsn(178, this.name, "componentType", "Lorg/objectweb/fractal/api/type/ComponentType;");
        mv.visitJumpInsn(199, l);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.name, "hints", "Ljava/lang/Object;");
        mv.visitTypeInsn(192, "org/objectweb/fractal/api/type/TypeFactory");
        mv.visitVarInsn(58, 1);
        int externalItfs = this.interfaceTypes.getSize();
        int i = 0;
        while (i < this.interfaceTypes.getSize()) {
            Tree itf = this.interfaceTypes.getSubTree(i);
            if (itf.getSubTree(0).toString().startsWith("/")) {
                --externalItfs;
            }
            ++i;
        }
        mv.visitVarInsn(25, 1);
        mv.visitIntInsn(17, externalItfs);
        mv.visitTypeInsn(189, "org/objectweb/fractal/api/type/InterfaceType");
        int j = 0;
        int i2 = 0;
        while (i2 < this.interfaceTypes.getSize()) {
            Tree itf = this.interfaceTypes.getSubTree(i2);
            if (!itf.getSubTree(0).toString().startsWith("/")) {
                mv.visitInsn(89);
                mv.visitIntInsn(17, j++);
                mv.visitVarInsn(25, 1);
                mv.visitLdcInsn((Object)itf.getSubTree(0).toString());
                mv.visitLdcInsn((Object)itf.getSubTree(1).toString());
                mv.visitInsn(itf.getSubTree(2).equals((Object)"true") ? 4 : 3);
                mv.visitInsn(itf.getSubTree(3).equals((Object)"true") ? 4 : 3);
                mv.visitInsn(itf.getSubTree(4).equals((Object)"true") ? 4 : 3);
                mv.visitMethodInsn(185, "org/objectweb/fractal/api/type/TypeFactory", "createFcItfType", "(Ljava/lang/String;Ljava/lang/String;ZZZ)Lorg/objectweb/fractal/api/type/InterfaceType;");
                mv.visitInsn(83);
            }
            ++i2;
        }
        mv.visitMethodInsn(185, "org/objectweb/fractal/api/type/TypeFactory", "createFcType", "([Lorg/objectweb/fractal/api/type/InterfaceType;)Lorg/objectweb/fractal/api/type/ComponentType;");
        mv.visitFieldInsn(179, this.name, "componentType", "Lorg/objectweb/fractal/api/type/ComponentType;");
        int internalIfts = this.interfaceTypes.getSize();
        int i3 = 0;
        while (i3 < this.interfaceTypes.getSize()) {
            Tree itf = this.interfaceTypes.getSubTree(i3);
            String name = itf.getSubTree(0).toString();
            if (name.startsWith("/") || name.equals("component") || name.endsWith("-controller")) {
                --internalIfts;
            }
            ++i3;
        }
        mv.visitVarInsn(25, 1);
        mv.visitIntInsn(17, internalIfts + 1);
        mv.visitTypeInsn(189, "org/objectweb/fractal/api/type/InterfaceType");
        j = 0;
        int i4 = 0;
        while (i4 < this.interfaceTypes.getSize()) {
            Tree itf = this.interfaceTypes.getSubTree(i4);
            String name = itf.getSubTree(0).toString();
            if (!(name.startsWith("/") || name.equals("component") || name.endsWith("-controller"))) {
                mv.visitInsn(89);
                mv.visitIntInsn(17, j++);
                mv.visitVarInsn(25, 1);
                mv.visitLdcInsn((Object)itf.getSubTree(0).toString());
                mv.visitLdcInsn((Object)itf.getSubTree(1).toString());
                mv.visitInsn(itf.getSubTree(2).equals((Object)"true") ? 3 : 4);
                mv.visitInsn(itf.getSubTree(3).equals((Object)"true") ? 4 : 3);
                mv.visitInsn(itf.getSubTree(4).equals((Object)"true") ? 4 : 3);
                mv.visitMethodInsn(185, "org/objectweb/fractal/api/type/TypeFactory", "createFcItfType", "(Ljava/lang/String;Ljava/lang/String;ZZZ)Lorg/objectweb/fractal/api/type/InterfaceType;");
                mv.visitInsn(83);
            }
            ++i4;
        }
        mv.visitInsn(89);
        mv.visitIntInsn(17, j++);
        mv.visitVarInsn(25, 1);
        mv.visitLdcInsn((Object)"/controllerDesc");
        mv.visitLdcInsn((Object)"java.lang.Object");
        mv.visitInsn(3);
        mv.visitInsn(3);
        mv.visitInsn(3);
        mv.visitMethodInsn(185, "org/objectweb/fractal/api/type/TypeFactory", "createFcItfType", "(Ljava/lang/String;Ljava/lang/String;ZZZ)Lorg/objectweb/fractal/api/type/InterfaceType;");
        mv.visitInsn(83);
        mv.visitMethodInsn(185, "org/objectweb/fractal/api/type/TypeFactory", "createFcType", "([Lorg/objectweb/fractal/api/type/InterfaceType;)Lorg/objectweb/fractal/api/type/ComponentType;");
        mv.visitFieldInsn(179, this.name, "internalComponentType", "Lorg/objectweb/fractal/api/type/ComponentType;");
        mv.visitLabel(l);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(178, this.name, "componentType", "Lorg/objectweb/fractal/api/type/ComponentType;");
        mv.visitFieldInsn(181, this.name, "type", "Lorg/objectweb/fractal/api/Type;");
        mv.visitFieldInsn(178, this.name, "componentType", "Lorg/objectweb/fractal/api/type/ComponentType;");
        mv.visitVarInsn(58, 2);
    }

    public void generateCreateControllers(MethodVisitor mv) throws ClassGenerationException {
        Tree controllerDesc;
        int i;
        Tree[] controllerArgs;
        Tree[] controllerDescs;
        HashMap<String, Tree> context = new HashMap<String, Tree>();
        int i2 = 0;
        while (i2 < this.interfaceTypes.getSize()) {
            String itfName = this.interfaceTypes.getSubTree(i2).getSubTree(0).toString();
            if (itfName.equals("attribute-controller")) {
                Tree itfSignature = this.interfaceTypes.getSubTree(i2).getSubTree(1);
                context.put("attributeControllerInterface", itfSignature);
                break;
            }
            ++i2;
        }
        try {
            Tree t = this.args.getSubTree(2).getSubTree(0).getSubTree(2);
            controllerDescs = this.loader.evalTree(t, context).getSubTrees();
            controllerArgs = new Tree[controllerDescs.length];
            i = 0;
            while (i < controllerDescs.length) {
                controllerDesc = controllerDescs[i];
                if (controllerDesc.getSize() > 0) {
                    controllerDescs[i] = controllerDesc.getSubTree(0);
                    if (controllerDesc.getSize() > 1) {
                        Tree[] trees = controllerDesc.getSubTrees();
                        Tree[] args = new Tree[trees.length - 1];
                        System.arraycopy(trees, 1, args, 0, args.length);
                        controllerArgs[i] = new Tree(args);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new ClassGenerationException(e, this.args.toString(), "Cannot find or evaluate the controller class descriptors");
        }
        String optimize = this.args.getSubTree(2).getSubTree(0).getSubTree(5).toString();
        if (!Arrays.asList(OPTIMIZATIONS).contains(optimize)) {
            throw new ClassGenerationException(null, this.args.toString(), "Invalid optimization level: " + optimize);
        }
        this.controllerClasses = new ArrayList();
        if (optimize.indexOf("Controllers") != -1) {
            String mergedClassName;
            Class mergedClass;
            Tree[] mergeClassDesc = new Tree[controllerDescs.length + 2];
            mergeClassDesc[0] = this.args.getSubTree(2).getSubTree(0).getSubTree(4);
            mergeClassDesc[1] = new Tree("java.lang.Object");
            String content = this.args.getSubTree(3).toString();
            if (optimize.indexOf("Content") != -1 && !content.equals("EMPTY")) {
                try {
                    this.contentClass = this.loader.loadClass(content, (Object)this.classLoader);
                }
                catch (ClassNotFoundException e) {
                    throw new ClassGenerationException(e, this.args.toString(), "Cannot find the '" + content + "' class");
                }
                mergeClassDesc[1] = new Tree(content);
            }
            int i3 = 0;
            while (i3 < controllerDescs.length) {
                Tree controllerDesc2 = controllerDescs[i3];
                try {
                    Class c = this.loader.loadClass(controllerDesc2, (Object)this.classLoader);
                    mergeClassDesc[i3 + 2] = new Tree(c.getName());
                }
                catch (ClassNotFoundException e) {
                    throw new ClassGenerationException(e, this.args.toString(), "Cannot find or generate the '" + controllerDesc2 + "' controller class");
                }
                ++i3;
            }
            try {
                mergedClass = this.loader.loadClass(new Tree(mergeClassDesc), (Object)this.classLoader);
                mergedClassName = Type.getInternalName((Class)mergedClass);
            }
            catch (ClassNotFoundException e) {
                throw new ClassGenerationException(e, this.args.toString(), "Cannot find or generate the merged controller class");
            }
            Tree interceptors = this.args.getSubTree(2).getSubTree(0).getSubTree(3);
            if (optimize.indexOf("Interceptors") > 0 && interceptors.getSize() > 0) {
                Tree classGen;
                ArrayList<String> itfList = new ArrayList<String>();
                ArrayList<Tree> itfNameList = new ArrayList<Tree>();
                int i4 = 0;
                while (i4 < this.interfaceTypes.getSize()) {
                    boolean isControl;
                    Tree itfType = this.interfaceTypes.getSubTree(i4);
                    String itfName = itfType.getSubTree(0).toString();
                    String itfSignature = itfType.getSubTree(1).toString();
                    boolean isClient = itfType.getSubTree(2).equals((Object)"true");
                    boolean bl = isControl = itfName.startsWith("/") || itfName.equals("component") || itfName.endsWith("-controller");
                    if (!(isClient || isControl || itfList.contains(itfSignature))) {
                        itfList.add(itfSignature);
                        itfNameList.add(new Tree(itfName));
                    }
                    ++i4;
                }
                int i5 = 0;
                while (i5 < itfList.size()) {
                    itfList.set(i5, (String)new Tree((String)itfList.get(i5)));
                    ++i5;
                }
                Tree[] itfTrees = itfList.toArray(new Tree[itfList.size()]);
                Tree[] itfNameTrees = itfNameList.toArray(new Tree[itfNameList.size()]);
                HashMap<String, Tree> itfCtxt = new HashMap<String, Tree>();
                itfCtxt.put("interfaceName", new Tree(itfNameTrees));
                try {
                    classGen = this.loader.evalTree(interceptors.getSubTree(0), itfCtxt);
                }
                catch (Exception e) {
                    throw new ClassGenerationException(e, this.args.toString(), "Cannot get the merged interceptor class generator descriptor");
                }
                try {
                    mergedClass = this.loader.loadClass(new Tree(new Tree[]{classGen, new Tree(mergedClass.getName()), new Tree(itfTrees), new Tree(new Tree[0]), new Tree("in")}), (Object)this.classLoader);
                    mergedClassName = Type.getInternalName((Class)mergedClass);
                }
                catch (ClassNotFoundException e) {
                    throw new ClassGenerationException(e, this.args.toString(), "Cannot find or generate the merged interceptor class");
                }
            }
            this.controllerClasses.add(mergedClass);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.name, "controllers", "Ljava/util/List;");
            mv.visitTypeInsn(187, mergedClassName);
            mv.visitInsn(89);
            mv.visitMethodInsn(183, mergedClassName, "<init>", "()V");
            mv.visitInsn(89);
            mv.visitTypeInsn(192, "org/objectweb/fractal/julia/loader/Initializable");
            this.generateCreateTreeCode(mv, new Tree(controllerArgs));
            mv.visitMethodInsn(185, "org/objectweb/fractal/julia/loader/Initializable", "initialize", "(Lorg/objectweb/fractal/julia/loader/Tree;)V");
            mv.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z");
            mv.visitInsn(87);
            if (optimize.indexOf("Content") != -1 && !content.equals("EMPTY")) {
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.name, "controllers", "Ljava/util/List;");
                mv.visitInsn(3);
                mv.visitMethodInsn(185, "java/util/List", "get", "(I)Ljava/lang/Object;");
                mv.visitFieldInsn(181, this.name, "content", "Ljava/lang/Object;");
            }
        } else {
            i = 0;
            while (i < controllerDescs.length) {
                String n;
                controllerDesc = controllerDescs[i];
                try {
                    Class c = this.loader.loadClass(controllerDesc, (Object)this.classLoader);
                    n = c.getName().replace('.', '/');
                    this.controllerClasses.add(c);
                }
                catch (ClassNotFoundException e) {
                    throw new ClassGenerationException(e, this.args.toString(), "Cannot find or generate the '" + controllerDesc + "' controller class");
                }
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.name, "controllers", "Ljava/util/List;");
                mv.visitTypeInsn(187, n);
                mv.visitInsn(89);
                mv.visitMethodInsn(183, n, "<init>", "()V");
                if (controllerArgs[i] != null) {
                    mv.visitInsn(89);
                    mv.visitTypeInsn(192, "org/objectweb/fractal/julia/loader/Initializable");
                    this.generateCreateTreeCode(mv, controllerArgs[i]);
                    mv.visitMethodInsn(185, "org/objectweb/fractal/julia/loader/Initializable", "initialize", "(Lorg/objectweb/fractal/julia/loader/Tree;)V");
                }
                mv.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z");
                mv.visitInsn(87);
                ++i;
            }
        }
        this.controllerTrees = new Tree[this.controllerClasses.size()];
        int l = 0;
        while (l < this.controllerTrees.length) {
            this.controllerTrees[l] = new Tree(((Class)this.controllerClasses.get(l)).getName());
            ++l;
        }
    }

    private void generateCreateTreeCode(MethodVisitor mv, Tree t) {
        String tree = "org/objectweb/fractal/julia/loader/Tree";
        if (t == null) {
            mv.visitInsn(1);
        } else if (t.getSize() == 0) {
            mv.visitTypeInsn(187, tree);
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)t.toString());
            mv.visitMethodInsn(183, tree, "<init>", "(Ljava/lang/String;)V");
        } else {
            mv.visitTypeInsn(187, tree);
            mv.visitInsn(89);
            mv.visitIntInsn(17, t.getSize());
            mv.visitTypeInsn(189, tree);
            int i = 0;
            while (i < t.getSize()) {
                mv.visitInsn(89);
                mv.visitIntInsn(17, i);
                this.generateCreateTreeCode(mv, t.getSubTree(i));
                mv.visitInsn(83);
                ++i;
            }
            mv.visitMethodInsn(183, tree, "<init>", "([L" + tree + ";)V");
        }
    }

    public void generateCreateContent(MethodVisitor mv) throws ClassGenerationException {
        String content = this.args.getSubTree(3).toString();
        if (content.equals("EMPTY")) {
            return;
        }
        if (this.contentClass == null) {
            try {
                this.contentClass = this.loader.loadClass(content, (Object)this.classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new ClassGenerationException(e, this.args.toString(), "Cannot find the '" + content + "' class");
            }
            content = content.replace('.', '/');
            Label end = new Label();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.name, "content", "Ljava/lang/Object;");
            mv.visitJumpInsn(199, end);
            mv.visitVarInsn(25, 0);
            mv.visitTypeInsn(187, content);
            mv.visitInsn(89);
            mv.visitMethodInsn(183, content, "<init>", "()V");
            mv.visitFieldInsn(181, this.name, "content", "Ljava/lang/Object;");
            mv.visitLabel(end);
        }
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.name, "interfaces", "Ljava/util/Map;");
        mv.visitLdcInsn((Object)"/content");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.name, "content", "Ljava/lang/Object;");
        mv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitInsn(87);
    }

    public void generateCreateInterfaces(MethodVisitor mv) throws ClassGenerationException {
        String optimize = this.args.getSubTree(2).getSubTree(0).getSubTree(5).toString();
        Tree interceptors = this.args.getSubTree(2).getSubTree(0).getSubTree(3);
        boolean interceptorsMerged = optimize.indexOf("Interceptors") != -1;
        Tree itfClassGen = this.args.getSubTree(2).getSubTree(0).getSubTree(0);
        boolean hasItfClassGen = !itfClassGen.equals((Object)"NONE");
        mv.visitInsn(1);
        mv.visitVarInsn(58, 3);
        int i = 0;
        while (i < this.interfaceTypes.getSize()) {
            String compItfClassName;
            Class compItfClass;
            Class itfClass;
            Tree itf = this.interfaceTypes.getSubTree(i);
            String itfName = itf.getSubTree(0).toString();
            String itfSignature = itf.getSubTree(1).toString();
            boolean isClient = itf.getSubTree(2).toString().equals("true");
            boolean isCollection = itf.getSubTree(4).toString().equals("true");
            boolean isControl = !isClient && (itfName.startsWith("/") || itfName.equals("component") || itfName.endsWith("-controller"));
            try {
                itfClass = this.loader.loadClass(itfSignature, (Object)this.classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new ClassGenerationException(e, this.args.toString(), "Cannot find the '" + itfSignature + "' class");
            }
            if (hasItfClassGen) {
                try {
                    compItfClass = this.loader.loadClass(this.generateTreeDescriptor(itfClassGen, itf), (Object)this.classLoader);
                    compItfClassName = compItfClass.getName().replace('.', '/');
                }
                catch (ClassNotFoundException e) {
                    throw new ClassGenerationException(e, this.args.toString(), "Cannot find or generate the ComponentInterface class for the '" + itfSignature + "' class");
                }
            } else {
                compItfClass = null;
                compItfClassName = null;
            }
            if (isClient) {
                mv.visitInsn(1);
                mv.visitVarInsn(58, 4);
            } else {
                int w;
                int u = -1;
                int v = -1;
                int j = 0;
                while (j < this.controllerClasses.size()) {
                    if (itfClass.isAssignableFrom((Class)this.controllerClasses.get(j))) {
                        u = j + 1;
                        break;
                    }
                    ++j;
                }
                if (this.contentClass != null && itfClass.isAssignableFrom(this.contentClass)) {
                    v = 0;
                }
                if (isControl || interceptorsMerged) {
                    w = u != -1 ? u : v;
                } else {
                    int n = w = v != -1 ? v : u;
                }
                if (w == -1 && isControl) {
                    throw new ClassGenerationException(null, this.args.toString(), "Implementation missing for control interface " + itfName + " of type " + itfSignature);
                }
                if (w != -1) {
                    if (w == 0) {
                        mv.visitVarInsn(25, 0);
                        mv.visitFieldInsn(180, this.name, "content", "Ljava/lang/Object;");
                    } else {
                        mv.visitVarInsn(25, 0);
                        mv.visitFieldInsn(180, this.name, "controllers", "Ljava/util/List;");
                        mv.visitIntInsn(17, w - 1);
                        mv.visitMethodInsn(185, "java/util/List", "get", "(I)Ljava/lang/Object;");
                    }
                } else {
                    mv.visitInsn(1);
                }
                mv.visitVarInsn(58, 4);
            }
            if (!(isControl || interceptors.getSize() <= 0 || !isClient && interceptorsMerged)) {
                Class ic;
                try {
                    String superClass = isClient ? "org.objectweb.fractal.julia.InterceptorInterface" : "java.lang.Object";
                    HashMap<String, Tree> itfCtxt = new HashMap<String, Tree>();
                    itfCtxt.put("interfaceName", new Tree(new Tree[]{new Tree(itfName)}));
                    Tree icDesc = new Tree(new Tree[]{this.loader.evalTree(interceptors.getSubTree(0), itfCtxt), new Tree(superClass), new Tree(new Tree[]{new Tree(itfSignature)}), new Tree(this.controllerTrees), new Tree(isClient ? "out" : "in")});
                    ic = this.loader.loadClass(icDesc, (Object)this.classLoader);
                }
                catch (IllegalClassDescriptorException e) {
                    ic = null;
                }
                catch (Exception e) {
                    throw new ClassGenerationException(e, this.args.toString(), "Cannot find or generate the interceptor class for the '" + itfSignature + "' interface");
                }
                if (ic != null) {
                    String icName = ic.getName().replace('.', '/');
                    mv.visitTypeInsn(187, icName);
                    mv.visitInsn(89);
                    mv.visitVarInsn(25, 4);
                    mv.visitMethodInsn(183, icName, "<init>", "(Ljava/lang/Object;)V");
                    mv.visitVarInsn(58, 4);
                    mv.visitVarInsn(25, 0);
                    mv.visitFieldInsn(180, this.name, "controllers", "Ljava/util/List;");
                    mv.visitVarInsn(25, 4);
                    mv.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z");
                    mv.visitInsn(87);
                }
            }
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.name, "interfaces", "Ljava/util/Map;");
            mv.visitLdcInsn((Object)(isCollection ? "/collection/" + itfName : itfName));
            if (hasItfClassGen) {
                mv.visitTypeInsn(187, compItfClassName);
                mv.visitInsn(89);
                mv.visitVarInsn(25, 3);
                mv.visitLdcInsn((Object)itfName);
                if (itfName.startsWith("/")) {
                    mv.visitInsn(1);
                } else {
                    mv.visitVarInsn(25, 2);
                    mv.visitLdcInsn((Object)itfName);
                    mv.visitMethodInsn(185, "org/objectweb/fractal/api/type/ComponentType", "getFcInterfaceType", "(Ljava/lang/String;)Lorg/objectweb/fractal/api/type/InterfaceType;");
                }
                mv.visitInsn(3);
                mv.visitVarInsn(25, 4);
                mv.visitMethodInsn(183, compItfClassName, "<init>", "(Lorg/objectweb/fractal/api/Component;Ljava/lang/String;Lorg/objectweb/fractal/api/Type;ZLjava/lang/Object;)V");
            } else {
                mv.visitVarInsn(25, 4);
            }
            if (itfName.equals("component")) {
                mv.visitInsn(89);
                mv.visitVarInsn(58, 3);
            }
            mv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            mv.visitInsn(87);
            if (!isControl) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.name, "internalInterfaces", "Ljava/util/Map;");
                mv.visitLdcInsn((Object)(isCollection ? "/collection/" + itfName : itfName));
                if (hasItfClassGen) {
                    mv.visitTypeInsn(187, compItfClassName);
                    mv.visitInsn(89);
                    mv.visitVarInsn(25, 3);
                    mv.visitLdcInsn((Object)itfName);
                    mv.visitFieldInsn(178, this.name, "internalComponentType", "Lorg/objectweb/fractal/api/type/ComponentType;");
                    mv.visitLdcInsn((Object)itfName);
                    mv.visitMethodInsn(185, "org/objectweb/fractal/api/type/ComponentType", "getFcInterfaceType", "(Ljava/lang/String;)Lorg/objectweb/fractal/api/type/InterfaceType;");
                    mv.visitInsn(4);
                    mv.visitVarInsn(25, 4);
                    mv.visitMethodInsn(183, compItfClassName, "<init>", "(Lorg/objectweb/fractal/api/Component;Ljava/lang/String;Lorg/objectweb/fractal/api/Type;ZLjava/lang/Object;)V");
                } else {
                    mv.visitVarInsn(25, 4);
                }
                mv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                mv.visitInsn(87);
            }
            ++i;
        }
        this.controllerDesc = this.args.getSubTree(2).getSubTree(1).toString();
        if (this.controllerDesc instanceof String) {
            mv.visitTypeInsn(187, "java/lang/String");
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)this.controllerDesc.toString());
            mv.visitMethodInsn(183, "java/lang/String", "<init>", "(Ljava/lang/String;)V");
            mv.visitVarInsn(58, 1);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.name, "interfaces", "Ljava/util/Map;");
            mv.visitLdcInsn((Object)"/controllerDesc");
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            mv.visitInsn(87);
            mv.visitTypeInsn(187, "java/lang/String");
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)this.controllerDesc.toString());
            mv.visitMethodInsn(183, "java/lang/String", "<init>", "(Ljava/lang/String;)V");
            mv.visitVarInsn(58, 1);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.name, "internalInterfaces", "Ljava/util/Map;");
            mv.visitLdcInsn((Object)"/controllerDesc");
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            mv.visitInsn(87);
        }
    }

    protected Tree generateTreeDescriptor(Tree itfClassGen, Tree itf) {
        String itfSignature = itf.getSubTree(1).toString();
        return new Tree(new Tree[]{itfClassGen, new Tree(new Tree[]{new Tree(itfSignature)})});
    }
}

