/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.ErrorManager;
import org.objectweb.fractal.adl.Loader;
import org.objectweb.fractal.adl.util.ClassLoaderHelper;
import org.objectweb.fractal.api.control.BindingController;

public abstract class AbstractLoader
implements BindingController,
Loader {
    public static final String LOADER_BINDING = "client-loader";
    public Loader clientLoader;
    public static final String ERROR_MANAGER_BINDING = "error-manager";
    private ErrorManager errorManager;
    private int nbLoadClass = 0;
    private int nbRealLoadClass = 0;
    static Map cacheLoadedClasses = new HashMap();
    private int nbIsAssignable = 0;
    private int nbRealIsAssignable = 0;
    static Map cacheIsAssignable = new HashMap();
    private int nbTimer = 0;
    private long totalTimer = 0L;

    public String[] listFc() {
        return new String[]{LOADER_BINDING, ERROR_MANAGER_BINDING};
    }

    public Object lookupFc(String s) {
        if (LOADER_BINDING.equals(s)) {
            return this.clientLoader;
        }
        if (ERROR_MANAGER_BINDING.equals(s)) {
            return this.errorManager;
        }
        return null;
    }

    public void bindFc(String s, Object o) {
        if (LOADER_BINDING.equals(s)) {
            this.clientLoader = (Loader)o;
            return;
        }
        if (ERROR_MANAGER_BINDING.equals(s)) {
            this.errorManager = (ErrorManager)o;
        }
    }

    public void unbindFc(String s) {
        if (LOADER_BINDING.equals(s)) {
            this.clientLoader = null;
            return;
        }
        if (ERROR_MANAGER_BINDING.equals(s)) {
            this.errorManager = null;
        }
    }

    public void reportError(ADLException adlException) throws ADLException {
        if (this.errorManager == null) {
            throw adlException;
        }
        this.errorManager.reportError(adlException);
    }

    private ClassLoader getClassLoader(Map context) {
        return ClassLoaderHelper.getClassLoader(this, context);
    }

    protected Class loadClass(Map context, String signature) throws ClassNotFoundException {
        ++this.nbLoadClass;
        Class<?> result = (Class<?>)cacheLoadedClasses.get(signature);
        if (result == null) {
            ++this.nbRealLoadClass;
            result = this.getClassLoader(context).loadClass(signature);
            cacheLoadedClasses.put(signature, result);
        }
        return result;
    }

    protected boolean isAssignable(Class toClass, Class fromClass) {
        return toClass.isAssignableFrom(fromClass);
    }

    protected void incrTimer(long t) {
        this.totalTimer += t;
        ++this.nbTimer;
    }

    public long printStats(long t) {
        long rest = this.clientLoader.printStats(t);
        float p = (float)this.totalTimer / (float)t * 100.0f;
        System.err.println(this.getClass().getName() + ": " + this.totalTimer + " (" + p + "%) milliseconds in " + this.nbTimer + " calls.");
        this.totalTimer = 0L;
        this.nbTimer = 0;
        return rest -= this.totalTimer;
    }

    public void cleanUpCaches() {
        this.clientLoader.cleanUpCaches();
    }
}

