/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.apply;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.AbstractNode;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Factory;
import org.objectweb.fractal.adl.FactoryFactory;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.apply.Applier;
import org.objectweb.fractal.adl.apply.Apply;
import org.objectweb.fractal.adl.apply.ApplyContainer;
import org.objectweb.fractal.adl.apply.BasicApplyContext;
import org.objectweb.fractal.adl.bindings.Binding;
import org.objectweb.fractal.adl.bindings.BindingContainer;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.components.ComponentHelper;
import org.objectweb.fractal.adl.components.ComponentLoaderItf;
import org.objectweb.fractal.adl.components.ResolveSharedComponentLoader;
import org.objectweb.fractal.adl.interfaces.Interface;
import org.objectweb.fractal.adl.interfaces.InterfaceContainer;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.util.Fractal;

public class ApplyLoader
extends AbstractLoader {
    public static final String COMPONENT_LOADER_BINDING = "component-loader";
    protected Factory factory;
    protected ComponentLoaderItf componentLoader;
    protected Map cacheOfApplierComponents = new HashMap();
    protected int nbNewAppliers;
    protected long timeNewAppliers;
    protected int nbCallAppliers;
    protected long timeCallAppliers;
    protected int nbMergeComponents;
    protected long timeMergeComponents;
    protected int nbResolveCC;
    protected long timeResolveCC;
    protected int nbVisited;
    protected int nbAlreadyVisited;
    List list = new ArrayList();

    public String[] listFc() {
        return new String[]{"client-loader", "error-manager", COMPONENT_LOADER_BINDING};
    }

    public Object lookupFc(String s) {
        if (COMPONENT_LOADER_BINDING.equals(s)) {
            return this.componentLoader;
        }
        return super.lookupFc(s);
    }

    public void bindFc(String s, Object o) {
        if (COMPONENT_LOADER_BINDING.equals(s)) {
            this.componentLoader = (ComponentLoaderItf)o;
            return;
        }
        super.bindFc(s, o);
    }

    public void unbindFc(String s) {
        if (COMPONENT_LOADER_BINDING.equals(s)) {
            this.componentLoader = null;
            return;
        }
        super.unbindFc(s);
    }

    public Definition load(String name, Map context) throws ADLException {
        this.nbNewAppliers = 0;
        this.timeNewAppliers = 0L;
        this.nbCallAppliers = 0;
        this.timeCallAppliers = 0L;
        this.nbMergeComponents = 0;
        this.timeMergeComponents = 0L;
        this.nbResolveCC = 0;
        this.timeResolveCC = 0L;
        this.nbVisited = 0;
        this.nbAlreadyVisited = 0;
        Definition result = this.clientLoader.load(name, context);
        long tb1 = System.currentTimeMillis();
        this.apply((Node)((Object)result), (ComponentContainer)((Object)result), context, new ArrayList());
        tb1 = System.currentTimeMillis() - tb1;
        long tb2 = System.currentTimeMillis();
        ComponentHelper.normalizeComponentContainer((ComponentContainer)((Object)result), new Object());
        tb2 = System.currentTimeMillis() - tb2;
        this.incrTimer(tb1 + tb2);
        return result;
    }

    protected void apply(Node node, ComponentContainer topLevelDefinition, Map context, List containers) throws ADLException {
        int i;
        List comps;
        if (node.astSetDecoration("ApplierLoaderVisitor", this) == this) {
            ++this.nbAlreadyVisited;
            return;
        }
        ++this.nbVisited;
        containers.add(node);
        if (node instanceof ComponentContainer && (comps = ((ComponentContainer)((Object)node)).listComponents()) != null) {
            int m = comps.size();
            for (i = 0; i < m; ++i) {
                Node component = null;
                try {
                    component = (Node)comps.get(i);
                }
                catch (IndexOutOfBoundsException ignored) {
                    break;
                }
                this.apply(component, topLevelDefinition, context, containers);
            }
        }
        if (node instanceof ApplyContainer) {
            Apply[] applies = ((ApplyContainer)((Object)node)).getApplys();
            for (i = 0; i < applies.length; ++i) {
                ((ApplyContainer)((Object)node)).removeApply(applies[i]);
            }
            for (i = 0; i < applies.length; ++i) {
                Apply apply = applies[i];
                String applyDefinition = apply.getDefinition();
                Applier applier = (Applier)this.cacheOfApplierComponents.get(applyDefinition);
                if (applier == null) {
                    long tb = System.currentTimeMillis();
                    context.put("NO_TRACE", "YES");
                    context.put("NO_CLEANUP", "YES");
                    if (this.factory == null) {
                        this.factory = FactoryFactory.getFactory("org.objectweb.fractal.adl.FractalBackend", context);
                    }
                    org.objectweb.fractal.api.Component applierComponent = (org.objectweb.fractal.api.Component)this.factory.newComponent(applyDefinition, context);
                    context.remove("NO_TRACE");
                    context.remove("NO_CLEANUP");
                    try {
                        Fractal.getLifeCycleController((org.objectweb.fractal.api.Component)applierComponent).startFc();
                    }
                    catch (NoSuchInterfaceException ignored) {
                    }
                    catch (IllegalLifeCycleException exception) {
                        throw new Error("", exception);
                    }
                    try {
                        applier = (Applier)applierComponent.getFcInterface("applier");
                    }
                    catch (NoSuchInterfaceException exception) {
                        this.reportError(new ADLException(applyDefinition + " has not an 'applier' server interface", (Node)((Object)apply), null));
                        break;
                    }
                    catch (ClassCastException exception) {
                        this.reportError(new ADLException(applyDefinition + " does not implement the Applier interface", (Node)((Object)apply), null));
                        break;
                    }
                    this.cacheOfApplierComponents.put(applyDefinition, applier);
                    this.timeNewAppliers += System.currentTimeMillis() - tb;
                    ++this.nbNewAppliers;
                }
                int depth = (Integer)((Node)((Object)apply)).astGetDecoration("DEPTH");
                ComponentContainer root = (ComponentContainer)containers.get(containers.size() - 1 - depth);
                BasicApplyContext applyContext = new BasicApplyContext(topLevelDefinition, root, node, apply, context);
                try {
                    long tb = System.currentTimeMillis();
                    AbstractNode.mode = 5;
                    applier.apply(applyContext);
                    AbstractNode.mode = 0;
                    this.timeCallAppliers += System.currentTimeMillis() - tb;
                    ++this.nbCallAppliers;
                }
                catch (ADLException exception) {
                    this.reportError(exception);
                    break;
                }
                Node result = applyContext.getResult();
                if (result == null) continue;
                long tb = System.currentTimeMillis();
                boolean mustResolveCC = ApplyLoader.merge(node, result);
                ApplyLoader.setDepth((ComponentContainer)((Object)node), depth);
                this.timeMergeComponents += System.currentTimeMillis() - tb;
                ++this.nbMergeComponents;
                if (mustResolveCC) {
                    tb = System.currentTimeMillis();
                    this.componentLoader.resolveComponentContainer(this.list, (ComponentContainer)((Object)node), context, new Object(), true);
                    containers.remove(containers.size() - 1);
                    ResolveSharedComponentLoader.resolveComponentContainer(containers, (ComponentContainer)((Object)node));
                    containers.add(node);
                    this.timeResolveCC += System.currentTimeMillis() - tb;
                    ++this.nbResolveCC;
                }
                containers.remove(containers.size() - 1);
                this.apply(node, topLevelDefinition, context, containers);
                containers.add(node);
            }
        }
        containers.remove(containers.size() - 1);
    }

    static boolean merge(Node node, Node result) throws ADLException {
        int i;
        boolean areComponentsAdded = false;
        if (result instanceof ApplyContainer) {
            node.astSetDecoration("ApplierLoaderVisitor", null);
            Apply[] applys = ((ApplyContainer)((Object)result)).getApplys();
            ApplyContainer nodeAC = (ApplyContainer)((Object)node);
            for (i = 0; i < applys.length; ++i) {
                nodeAC.addApply(applys[i]);
            }
        }
        if (result instanceof InterfaceContainer) {
            Interface[] interfaces = ((InterfaceContainer)((Object)result)).getInterfaces();
            InterfaceContainer nodeIC = (InterfaceContainer)((Object)node);
            for (i = 0; i < interfaces.length; ++i) {
                nodeIC.addInterface(interfaces[i]);
            }
        }
        if (result instanceof BindingContainer) {
            Binding[] bindings = ((BindingContainer)((Object)result)).getBindings();
            BindingContainer nodeBC = (BindingContainer)((Object)node);
            for (i = 0; i < bindings.length; ++i) {
                nodeBC.addBinding(bindings[i]);
            }
        }
        if (result instanceof ComponentContainer) {
            node.astSetDecoration("ApplierLoaderVisitor", null);
            Component[] resultComponents = ((ComponentContainer)((Object)result)).getComponents();
            ComponentContainer nodeCC = (ComponentContainer)((Object)node);
            Component[] nodeComponents = nodeCC.getComponents();
            for (int i2 = 0; i2 < resultComponents.length; ++i2) {
                Component resultComponent = resultComponents[i2];
                String name = resultComponent.getName();
                for (int j = 0; j < nodeComponents.length; ++j) {
                    Component nodeComponent = nodeComponents[j];
                    if (!nodeComponent.getName().equals(name)) continue;
                    nodeComponent.setDefinition(resultComponent.getDefinition());
                    areComponentsAdded |= ApplyLoader.merge((Node)((Object)nodeComponent), (Node)((Object)resultComponent));
                    resultComponent = null;
                    areComponentsAdded = true;
                    break;
                }
                if (resultComponent == null) continue;
                nodeCC.addComponent(resultComponent);
                areComponentsAdded = true;
            }
        }
        return areComponentsAdded;
    }

    protected static void setDepth(ComponentContainer container, int depth) {
        Integer depthInteger = null;
        List comps = container.listComponents();
        if (comps != null) {
            int m = comps.size();
            for (int i = 0; i < m; ++i) {
                Component comp = (Component)comps.get(i);
                if (ApplyLoader.isShared(comp.getDefinition())) {
                    if (((Node)((Object)comp)).astGetDecoration("DEPTH") != null) continue;
                    if (depthInteger == null) {
                        depthInteger = new Integer(depth);
                    }
                    ((Node)((Object)comp)).astSetDecoration("DEPTH", depthInteger);
                    continue;
                }
                ApplyLoader.setDepth(comp, depth + 1);
            }
        }
    }

    protected static boolean isShared(String definition) {
        return definition != null && definition.indexOf(47) != -1 && definition.indexOf(40) == -1;
    }
}

