/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.apply;

import java.util.Iterator;
import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractNode;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.apply.Applier;
import org.objectweb.fractal.adl.apply.ApplyContext;
import org.objectweb.fractal.adl.apply.ForEachAttributes;
import org.objectweb.fractal.adl.apply.Iterable;
import org.objectweb.fractal.api.control.BindingController;

public class ForEach
implements Applier,
ForEachAttributes,
BindingController {
    public static final String ITERABLE_BINDING = "iterable";
    protected String variableName;
    protected String variableMarker;
    protected Iterable iterable;

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
        this.variableMarker = "%{" + variableName + '}';
    }

    public String[] listFc() {
        return new String[]{ITERABLE_BINDING};
    }

    public Object lookupFc(String s) {
        if (ITERABLE_BINDING.equals(s)) {
            return this.iterable;
        }
        return null;
    }

    public void bindFc(String s, Object o) {
        if (ITERABLE_BINDING.equals(s)) {
            this.iterable = (Iterable)o;
        }
    }

    public void unbindFc(String s) {
        if (ITERABLE_BINDING.equals(s)) {
            this.iterable = null;
        }
    }

    public void apply(ApplyContext context) throws ADLException {
        Node currentNode = context.getCurrentNode();
        Node applyNode = (Node)((Object)context.getApply());
        String[] nodeTypes = applyNode.astGetNodeTypes();
        for (int nt = 0; nt < nodeTypes.length; ++nt) {
            Node[] nodes = applyNode.astGetNodes(nodeTypes[nt]);
            Iterator iter = this.iterable.iterator(context);
            while (iter.hasNext()) {
                String value = (String)iter.next();
                for (int i = 0; i < nodes.length; ++i) {
                    context.addNode(this.cloneNode(nodes[i], value));
                }
            }
        }
    }

    protected Node cloneNode(Node node, String index) {
        Node newNode = node.astNewInstance();
        newNode.astSetSource(node.astGetSource());
        ((AbstractNode)newNode).astSetDecorations((AbstractNode)node);
        Map attrs = node.astGetAttributes();
        for (String attr : attrs.keySet()) {
            String value = (String)attrs.get(attr);
            if (value == null) continue;
            attrs.put(attr, this.evaluate(value, index));
        }
        newNode.astSetAttributes(attrs);
        String[] nodeTypes = node.astGetNodeTypes();
        for (int i = 0; i < nodeTypes.length; ++i) {
            Node[] nodes = node.astGetNodes(nodeTypes[i]);
            for (int j = 0; j < nodes.length; ++j) {
                Node n = nodes[j];
                if (n == null) continue;
                newNode.astAddNode(this.cloneNode(n, index));
            }
        }
        return newNode;
    }

    protected String evaluate(String s, String index) {
        int i = s.indexOf(this.variableMarker);
        return i == -1 ? s : this.evaluate(s.substring(0, i) + index + s.substring(i + this.variableMarker.length()), index);
    }
}

