/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.arguments;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.components.ComponentLoader;

public class ArgumentComponentLoader
extends ComponentLoader {
    public Definition load(List loaded, String name, Map context) throws ADLException {
        int i = name.indexOf(40);
        if (i == -1) {
            return super.load(loaded, name, context);
        }
        if (!name.endsWith(")")) {
            this.reportError(new ADLException("Syntax error in definition name '" + name + "'", null));
        }
        ArrayList<String> keysAddedToContext = null;
        String n = name.substring(0, i);
        String args = name.substring(i + 1, name.length() - 1);
        if (args.length() != 0) {
            keysAddedToContext = new ArrayList<String>();
            List l = this.parseDefinitions(args);
            for (i = 0; i < l.size(); ++i) {
                String argval;
                String argname;
                String arg = (String)l.get(i);
                int j = arg.indexOf("=>");
                if (j != -1) {
                    argname = arg.substring(0, j);
                    argval = arg.substring(j + 2);
                } else {
                    argname = " arg " + i;
                    argval = arg;
                }
                context.put(argname, argval);
                keysAddedToContext.add(argname);
            }
        }
        Definition loadedDefinition = super.load(loaded, n, context);
        if (keysAddedToContext != null) {
            for (i = 0; i < keysAddedToContext.size(); ++i) {
                context.remove(keysAddedToContext.get(i));
            }
        }
        return loadedDefinition;
    }

    public List parseDefinitions(String nameList) {
        ArrayList<String> result = new ArrayList<String>();
        int begin = 0;
        int counter = 0;
        for (int end = 0; end < nameList.length(); ++end) {
            char c = nameList.charAt(end);
            if (c == '(') {
                ++counter;
                continue;
            }
            if (c == ')') {
                --counter;
                continue;
            }
            if (c != ',' || counter != 0) continue;
            result.add(nameList.substring(begin, end));
            begin = end + 1;
        }
        result.add(nameList.substring(begin));
        return result;
    }

    public boolean isShared(String definition) {
        return definition.indexOf(47) != -1 && definition.indexOf(40) == -1;
    }
}

