/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.bindings;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.bindings.Binding;
import org.objectweb.fractal.adl.bindings.BindingContainer;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.interfaces.Interface;
import org.objectweb.fractal.adl.interfaces.InterfaceContainer;

public class BindingLoader
extends AbstractLoader {
    public Definition load(String name, Map context) throws ADLException {
        Definition d = this.clientLoader.load(name, context);
        long tb = System.currentTimeMillis();
        this.checkNode(d, context, new Object());
        this.incrTimer(System.currentTimeMillis() - tb);
        return d;
    }

    private void checkNode(Object node, Map context, Object marker) throws ADLException {
        if (((Node)node).astSetDecoration("MARKER", marker) != marker) {
            return;
        }
        if (node instanceof BindingContainer) {
            int i;
            HashMap<String, Interface> itfMap = new HashMap<String, Interface>();
            if (node instanceof InterfaceContainer) {
                Interface[] itfs = ((InterfaceContainer)node).getInterfaces();
                for (i = 0; i < itfs.length; ++i) {
                    Interface itf = itfs[i];
                    itfMap.put("this." + itf.getName(), itf);
                }
            }
            if (node instanceof ComponentContainer) {
                Component[] comps = ((ComponentContainer)node).getComponents();
                for (i = 0; i < comps.length; ++i) {
                    Component comp = comps[i];
                    if (!(comp instanceof InterfaceContainer)) continue;
                    Interface[] itfs = ((InterfaceContainer)((Object)comp)).getInterfaces();
                    for (int j = 0; j < itfs.length; ++j) {
                        Interface itf = itfs[j];
                        itfMap.put(comp.getName() + "." + itf.getName(), itf);
                    }
                }
            }
            Binding[] bindings = ((BindingContainer)node).getBindings();
            for (i = 0; i < bindings.length; ++i) {
                Binding binding = bindings[i];
                this.checkBinding(binding, itfMap, context);
            }
            HashSet<String> fromItfs = new HashSet<String>();
            for (int i2 = 0; i2 < bindings.length; ++i2) {
                if (fromItfs.add(bindings[i2].getFrom())) continue;
                this.reportError(new ADLException("Multiple bindings from the same interface (" + bindings[i2].getFrom() + ')', (Node)((Object)bindings[i2])));
            }
        }
        if (node instanceof ComponentContainer) {
            Component[] comps = ((ComponentContainer)node).getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.checkNode(comps[i], context, marker);
            }
        }
    }

    private void checkBinding(Binding binding, Map itfs, Map context) throws ADLException {
        if (binding.getFrom() == null) {
            this.reportError(new ADLException("'from' interface missing", (Node)((Object)binding)));
        }
        if (binding.getTo() == null) {
            this.reportError(new ADLException("'to' interface missing", (Node)((Object)binding)));
        }
        Interface fromItf = this.getInterface(binding.getFrom(), itfs);
        Interface toItf = this.getInterface(binding.getTo(), itfs);
        if (binding.getFrom() != null && fromItf == null && !binding.getFrom().endsWith(".component") && !binding.getFrom().endsWith("-controller")) {
            this.reportError(new ADLException("No such interface '" + binding.getFrom() + "'", (Node)((Object)binding)));
        } else if (binding.getTo() != null && toItf == null && !binding.getTo().endsWith(".component") && !binding.getTo().endsWith("-controller")) {
            this.reportError(new ADLException("No such interface '" + binding.getTo() + "'", (Node)((Object)binding)));
        }
        if (fromItf != null && toItf != null) {
            this.checkBinding(binding, fromItf, toItf, context);
        }
    }

    void checkBinding(Binding binding, Interface fromItf, Interface toItf, Map context) throws ADLException {
    }

    Interface getInterface(String name, Map itfs) {
        return (Interface)itfs.get(name);
    }
}

