/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.caches;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractNode;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.arguments.ArgumentComponentLoader;

public class CacheArgumentComponentLoader
extends ArgumentComponentLoader {
    private Cache cache = new Cache();

    public long printStats(long t) {
        long rest = super.printStats(t);
        return rest;
    }

    public void cleanUpCaches() {
        super.cleanUpCaches();
        this.cache = new Cache();
    }

    public Definition load(String name, Map context) throws ADLException {
        Definition d = super.load(name, context);
        AbstractNode.mode = 3;
        d = (Definition)((Object)CacheArgumentComponentLoader.cloneNode((Node)((Object)d)));
        AbstractNode.mode = 0;
        return d;
    }

    public Definition load(List loaded, String name, Map context) throws ADLException {
        this.incrTimer(0L);
        CacheEntry ce = this.cache.get(name);
        if (ce == null) {
            ce = new CacheEntry();
            ce.definition = super.load(loaded, name, context);
            this.cache.put(name, ce);
        }
        ++ce.counter;
        return ce.definition;
    }

    static class Cache {
        int counter = 0;
        public Map cache = new HashMap();
        public Map keys = new HashMap();

        Cache() {
        }

        public CacheEntry get(String key) {
            return (CacheEntry)this.cache.get(key);
        }

        public void put(String key, CacheEntry ce) {
            if (this.counter == 500) {
                Iterator iter = this.cache.keySet().iterator();
                while (iter.hasNext()) {
                    String k = (String)iter.next();
                    CacheEntry c = (CacheEntry)this.cache.get(k);
                    if (c.counter != 1) continue;
                    iter.remove();
                }
                this.counter = 0;
            }
            ++this.counter;
            this.cache.put(key, ce);
            this.keys.put(key, key);
        }
    }

    static class CacheEntry {
        public int counter;
        public Definition definition;
        public Definition clone;

        CacheEntry() {
        }
    }
}

