/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.components;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;

public class ComponentHelper {
    private ComponentHelper() {
    }

    public static void normalizeComponentContainer(ComponentContainer container, Object marker) throws ADLException {
        List comps = container.listComponents();
        if (comps == null) {
            return;
        }
        if (((Node)((Object)container)).astSetDecoration("MARKER", marker) == marker) {
            return;
        }
        HashSet<String> names = new HashSet<String>();
        int m = comps.size();
        for (int i = 0; i < m; ++i) {
            Component comp = (Component)comps.get(i);
            String name = comp.getName();
            if (name == null) {
                throw new ADLException("Component name missing", (Node)((Object)comp));
            }
            if (!names.add(name)) {
                throw new ADLException("Duplicated component name '" + name + "'", (Node)((Object)comp));
            }
            ComponentHelper.normalizeComponentContainer(comp, marker);
        }
    }

    public static Component getComponent(ComponentContainer container, String name) {
        List comps = container.listComponents();
        if (comps != null) {
            int m = comps.size();
            for (int i = 0; i < m; ++i) {
                Component comp = (Component)comps.get(i);
                if (!comp.getName().equals(name)) continue;
                return comp;
            }
        }
        return null;
    }

    public static Component getPathComponent(ComponentContainer container, String path) {
        int p = path.indexOf(47);
        if (p == -1) {
            return ComponentHelper.getComponent(container, path);
        }
        Component parent = ComponentHelper.getComponent(container, path.substring(0, p));
        if (parent == null) {
            return null;
        }
        return ComponentHelper.getPathComponent(parent, path.substring(p + 1));
    }

    public static void replaceComponents(ComponentContainer container, Map replacements, Object marker) {
        List comps = container.listComponents();
        if (comps == null) {
            return;
        }
        if (((Node)((Object)container)).astSetDecoration("MARKER", marker) == marker) {
            return;
        }
        int m = comps.size();
        for (int i = 0; i < m; ++i) {
            Object comp = comps.get(i);
            Object replacement = replacements.get(comp);
            if (replacement != null) {
                comps.set(i, replacement);
                continue;
            }
            ComponentHelper.replaceComponents((Component)comp, replacements, marker);
        }
    }

    public static void replaceComponent(ComponentContainer container, Component oldComponent, Component newComponent, Object marker) {
        List comps = container.listComponents();
        if (comps == null) {
            return;
        }
        if (((Node)((Object)container)).astSetDecoration("MARKER", marker) == marker) {
            return;
        }
        int m = comps.size();
        for (int i = 0; i < m; ++i) {
            Object comp = comps.get(i);
            if (comp == oldComponent) {
                comps.set(i, newComponent);
                continue;
            }
            ComponentHelper.replaceComponent((Component)comp, oldComponent, newComponent, marker);
        }
    }
}

