/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.AbstractNode;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.NodeClassLoader;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.components.ComponentDefinition;
import org.objectweb.fractal.adl.components.ComponentHelper;
import org.objectweb.fractal.adl.components.ComponentLoaderAttributes;
import org.objectweb.fractal.adl.components.ComponentLoaderItf;
import org.objectweb.fractal.adl.util.ClassLoaderHelper;

public class ComponentLoader
extends AbstractLoader
implements ComponentLoaderItf,
ComponentLoaderAttributes {
    private Map NAME_ATTRIBUTES;
    private MergeClassLoader mergeClassLoader;
    static final int CLONE_NODE = 1;
    static final int CLONE_SUPER = 2;
    private String[] names = new String[]{"replaceComponents", "merge.compute_infos", "merge.create_nodes", "merge.init_nodes", "merge.replacements", "MergeClass"};
    private int NB_TIMERS = this.names.length;
    private int[] nbCalls = new int[this.NB_TIMERS];
    private long[] timers = new long[this.NB_TIMERS];
    int nbNewInstances;
    int nbMergeClasses;
    int nbNewClasses;

    public ComponentLoader() {
        this.NAME_ATTRIBUTES = new HashMap();
        this.NAME_ATTRIBUTES.put("component", "name");
        this.NAME_ATTRIBUTES.put("interface", "name");
        this.NAME_ATTRIBUTES.put("binding", "from");
        this.NAME_ATTRIBUTES.put("attribute", "name");
        this.NAME_ATTRIBUTES.put("coordinates", "name");
        this.NAME_ATTRIBUTES.put("apply", "name");
        this.mergeClassLoader = new MergeClassLoader(ClassLoaderHelper.getClassLoader(this));
    }

    public String getNameAttributes() {
        StringBuffer b = new StringBuffer();
        for (Map.Entry e : this.NAME_ATTRIBUTES.entrySet()) {
            b.append((String)e.getKey());
            b.append(' ');
            b.append((String)e.getValue());
            b.append(' ');
        }
        return b.toString();
    }

    public void setNameAttributes(String nameAttributes) {
        this.NAME_ATTRIBUTES.clear();
        String key = null;
        int p = nameAttributes.indexOf(32);
        while (p != -1) {
            String s = nameAttributes.substring(0, p);
            if (key == null) {
                key = s;
            } else {
                this.NAME_ATTRIBUTES.put(key, s);
                key = null;
            }
            nameAttributes = nameAttributes.substring(p + 1);
            p = nameAttributes.indexOf(32);
        }
    }

    public Definition load(String name, Map context) throws ADLException {
        return this.load(new ArrayList(), name, context);
    }

    public Definition load(List loaded, String name, Map context) throws ADLException {
        if (loaded.contains(name)) {
            throw new ADLException("Cycle in definition references: " + loaded, null);
        }
        List l = loaded;
        l.add(name);
        Definition d = this.clientLoader.load(name, context);
        if (d instanceof ComponentDefinition) {
            ComponentDefinition container = (ComponentDefinition)d;
            ComponentHelper.normalizeComponentContainer(container, new Object());
            this.resolveComponentContainer(l, container, context, new Object(), false);
            if (container.getExtends() != null) {
                List defs = this.parseDefinitions(container.getExtends());
                try {
                    d = (Definition)((Object)this.mergeDefinitions((Node)((Object)d), l, defs, context, false));
                }
                catch (ADLException e) {
                    throw new ADLException("Cannot load super definition(s)", (Node)((Object)container), e);
                }
                container = (ComponentDefinition)d;
                container.setExtends(null);
            }
        }
        l.remove(name);
        return d;
    }

    public void resolveComponentContainer(List loaded, ComponentContainer container, Map context, Object marker, boolean clone) throws ADLException {
        List comps = container.listComponents();
        if (comps == null) {
            return;
        }
        if (((Node)((Object)container)).astSetDecoration("ComponentLoaderVisitor", marker) == marker) {
            return;
        }
        int m = comps.size();
        for (int i = 0; i < m; ++i) {
            List defs;
            Component comp = (Component)comps.get(i);
            this.resolveComponentContainer(loaded, comp, context, marker, clone);
            String definition = comp.getDefinition();
            if (definition == null || (defs = this.parseDefinitions(definition)).size() == 1 && this.isShared((String)defs.get(0))) continue;
            comp.setDefinition(null);
            try {
                Node merged = this.mergeDefinitions((Node)((Object)comp), loaded, defs, context, clone);
                comps.set(i, merged);
                ((Component)((Object)merged)).setName(comp.getName());
                continue;
            }
            catch (ADLException e) {
                this.reportError(new ADLException("Cannot load referenced definition(s)", (Node)((Object)comp), e));
            }
        }
    }

    public List parseDefinitions(String nameList) {
        ArrayList<String> l = new ArrayList<String>(5);
        int p = nameList.indexOf(44);
        while (p != -1) {
            l.add(nameList.substring(0, p));
            nameList = nameList.substring(p + 1);
            p = nameList.indexOf(44);
        }
        l.add(nameList);
        return l;
    }

    public boolean isShared(String definition) {
        return definition.indexOf(47) != -1;
    }

    public Definition resolveDefinitions(List loaded, List nameList, Map context) throws ADLException {
        Definition d = this.load(loaded, (String)nameList.get(0), context);
        int m = nameList.size();
        for (int i = 1; i < m; ++i) {
            Definition e = this.load(loaded, (String)nameList.get(i), context);
            d = (Definition)((Object)this.merge((Node)((Object)e), (Node)((Object)d)));
        }
        return d;
    }

    public Node mergeDefinitions(Node node, List loaded, List nameList, Map context, boolean clone) throws ADLException {
        Definition d = this.load(loaded, (String)nameList.get(0), context);
        if (nameList.size() > 1) {
            int m = nameList.size();
            for (int i = 1; i < m; ++i) {
                Definition e = this.load(loaded, (String)nameList.get(i), context);
                AbstractNode.mode = 4;
                d = (Definition)((Object)this.merge((Node)((Object)e), (Node)((Object)d), 0));
                AbstractNode.mode = 0;
            }
        }
        AbstractNode.mode = 4;
        Node result = this.merge(node, (Node)((Object)d), clone ? 2 : 0);
        AbstractNode.mode = 0;
        return result;
    }

    public Node merge(Node elem, Node superElem) throws ADLException {
        return this.merge(elem, superElem, null);
    }

    public Node merge(Node elem, Node superElem, Map replacements) throws ADLException {
        MergeInfos infos = new MergeInfos();
        infos.mode = 2;
        long tb = System.currentTimeMillis();
        infos.computeMergeInfos(elem, superElem);
        this.incrTimer(1, System.currentTimeMillis() - tb);
        tb = System.currentTimeMillis();
        infos.createMergedNodes();
        this.incrTimer(2, System.currentTimeMillis() - tb);
        tb = System.currentTimeMillis();
        Node n = infos.initMergedNodes((MergeInfo)infos.infos.get(elem));
        this.incrTimer(3, System.currentTimeMillis() - tb);
        if (replacements != null) {
            tb = System.currentTimeMillis();
            for (Map.Entry e : infos.infos.entrySet()) {
                Object key = e.getKey();
                if (!(key instanceof Component) || ((Node)key).astGetDecoration("SHARED") == null) continue;
                replacements.put(key, ((MergeInfo)e.getValue()).result);
            }
            this.incrTimer(4, System.currentTimeMillis() - tb);
        }
        return n;
    }

    public Node merge(Node elem, Node superElem, int mode) throws ADLException {
        MergeInfos infos = new MergeInfos();
        infos.mode = mode;
        long tb = System.currentTimeMillis();
        infos.computeMergeInfos(elem, superElem);
        this.incrTimer(1, System.currentTimeMillis() - tb);
        tb = System.currentTimeMillis();
        infos.createMergedNodes();
        this.incrTimer(2, System.currentTimeMillis() - tb);
        tb = System.currentTimeMillis();
        Node n = infos.initMergedNodes((MergeInfo)infos.infos.get(elem));
        this.incrTimer(3, System.currentTimeMillis() - tb);
        return n;
    }

    protected void incrTimer(int timer, long t) {
        int n = timer;
        this.timers[n] = this.timers[n] + t;
        int n2 = timer;
        this.nbCalls[n2] = this.nbCalls[n2] + 1;
    }

    public long printStats(long t) {
        int i;
        long rest = super.printStats(t);
        for (i = 0; i < this.NB_TIMERS; ++i) {
            float p = (float)this.timers[i] / (float)t * 100.0f;
            System.err.println(this.getClass().getName() + '.' + this.names[i] + ": " + this.timers[i] + " (" + p + "%) milliseconds in " + this.nbCalls[i] + " calls.");
            rest -= this.timers[i];
        }
        System.err.println(this.getClass().getName() + ": " + this.nbNewInstances + " NEW NODE INSTANCES.");
        System.err.println(this.getClass().getName() + ": " + this.nbMergeClasses + " MERGE NODE CLASSES.");
        System.err.println(this.getClass().getName() + ": " + this.nbNewClasses + " NEW NODE CLASSES.");
        for (i = 0; i < this.NB_TIMERS; ++i) {
            this.nbCalls[i] = 0;
            this.timers[i] = 0L;
        }
        this.nbNewInstances = 0;
        this.nbNewClasses = 0;
        return rest;
    }

    public static Node cloneNode(Node node) {
        if (!(node instanceof ComponentContainer)) {
            return node;
        }
        Node newNode = node.astNewInstance();
        newNode.astSetSource(node.astGetSource());
        ((AbstractNode)newNode).astSetDecorations((AbstractNode)node);
        ((AbstractNode)newNode).astSetAttributes((AbstractNode)node);
        String[] nodeTypes = node.astGetNodeTypes();
        for (int i = 0; i < nodeTypes.length; ++i) {
            Node[] nodes = node.astGetNodes(nodeTypes[i]);
            for (int j = 0; j < nodes.length; ++j) {
                Node n = nodes[j];
                if (n == null) continue;
                newNode.astAddNode(ComponentLoader.cloneNode(n));
            }
        }
        return newNode;
    }

    private class MergeClassLoader
    extends NodeClassLoader {
        public MergeClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class mergeClass(String name, String astNodeName, Class[] classes) throws ClassNotFoundException {
            try {
                return this.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                ++ComponentLoader.this.nbNewClasses;
                long tb = System.currentTimeMillis();
                HashSet<String> itfs = new HashSet<String>();
                for (int i = 0; i < classes.length; ++i) {
                    Class<?>[] citfs = classes[i].getInterfaces();
                    for (int j = 0; j < citfs.length; ++j) {
                        itfs.add(Type.getInternalName(citfs[j]));
                    }
                }
                ClassWriter cw = this.generateClass(name, astNodeName, Type.getInternalName(AbstractNode.class), itfs.toArray(new String[itfs.size()]));
                Class result = this.defineClass(name, cw.toByteArray());
                ComponentLoader.this.incrTimer(5, System.currentTimeMillis() - tb);
                return result;
            }
        }
    }

    private static class MergeInfo {
        List nodes = new ArrayList(2);
        Node result;
        boolean done;
        String[] nodeTypes;
        Set nodeTypeSet;

        private MergeInfo() {
        }
    }

    class MergeInfos {
        Map infos = new HashMap();
        int mode;

        MergeInfos() {
        }

        void computeMergeInfos(Node elem, Node superElem) throws ADLException {
            MergeInfo info = (MergeInfo)this.infos.get(elem);
            if (info == null) {
                info = new MergeInfo();
                this.infos.put(elem, info);
                info.nodes.add(elem);
            }
            if (elem == superElem) {
                info.result = elem;
                info.done = true;
                return;
            }
            if (info.nodeTypeSet == null) {
                info.nodeTypeSet = new HashSet<String>(Arrays.asList(elem.astGetNodeTypes()));
            }
            Set nodeTypeSet = info.nodeTypeSet;
            if (info.nodes.contains(superElem)) {
                return;
            }
            info.nodes.add(superElem);
            if (info.nodes.size() > 2) {
                System.err.println("info.nodes.size() > 2 !!!!");
            }
            nodeTypeSet.addAll(Arrays.asList(superElem.astGetNodeTypes()));
            String[] nodeTypes = nodeTypeSet.toArray(new String[nodeTypeSet.size()]);
            info.nodeTypes = nodeTypes;
            for (String nodeType : nodeTypes) {
                int k;
                String nameAttr;
                Node[] superNodes = superElem.astGetNodes(nodeType);
                Node[] nodes = elem.astGetNodes(nodeType);
                if (superNodes == null) {
                    superNodes = new Node[]{};
                }
                if (nodes == null) {
                    nodes = new Node[]{};
                }
                if ((nameAttr = (String)ComponentLoader.this.NAME_ATTRIBUTES.get(nodeType)) == null) {
                    if (superNodes.length > 0 && superNodes[0] != null) {
                        if (nodes.length == 0 || nodes[0] == null) {
                            this.computeSuperMergeInfos(superNodes[0]);
                            continue;
                        }
                        this.computeMergeInfos(nodes[0], superNodes[0]);
                        continue;
                    }
                    if (nodes.length <= 0 || nodes[0] == null) continue;
                    this.computeMergeInfos(nodes[0]);
                    continue;
                }
                String[] nodeNames = new String[nodes.length];
                for (int l = 0; l < nodes.length; ++l) {
                    nodeNames[l] = nodes[l].astGetAttribute(nameAttr);
                }
                String[] superNodeNames = new String[superNodes.length];
                for (k = 0; k < superNodes.length; ++k) {
                    superNodeNames[k] = superNodes[k].astGetAttribute(nameAttr);
                }
                for (k = 0; k < superNodes.length; ++k) {
                    String superName = superNodeNames[k];
                    int index = -1;
                    for (int l = 0; l < nodes.length; ++l) {
                        if (!nodeNames[l].equals(superName)) continue;
                        index = l;
                        break;
                    }
                    if (index == -1) {
                        this.computeSuperMergeInfos(superNodes[k]);
                        continue;
                    }
                    this.computeMergeInfos(nodes[index], superNodes[k]);
                }
                for (int l = 0; l < nodes.length; ++l) {
                    int index = -1;
                    for (int k2 = 0; k2 < superNodes.length; ++k2) {
                        if (!superNodeNames[k2].equals(nodeNames[l])) continue;
                        index = k2;
                        break;
                    }
                    if (index != -1) continue;
                    this.computeMergeInfos(nodes[l]);
                }
            }
        }

        void computeMergeInfos(Node node) throws ADLException {
            MergeInfo info;
            if (node == null) {
                System.err.println("NODE NULL");
            }
            if ((info = (MergeInfo)this.infos.get(node)) != null) {
                return;
            }
            info = new MergeInfo();
            this.infos.put(node, info);
            info.done = true;
            info.result = node;
        }

        void computeSuperMergeInfos(Node node) throws ADLException {
            MergeInfo info;
            if (node == null) {
                System.err.println("NODE NULL");
            }
            if ((info = (MergeInfo)this.infos.get(node)) != null) {
                return;
            }
            info = new MergeInfo();
            this.infos.put(node, info);
            info.done = true;
            info.result = this.mode == 2 ? ComponentLoader.cloneNode(node) : node;
        }

        void createMergedNodes() throws ADLException {
            for (MergeInfo info : this.infos.values()) {
                if (info.result != null) continue;
                Node elem = (Node)info.nodes.get(0);
                Class<?> elemClass = elem.getClass();
                ClassLoader elemClassLoader = elemClass.getClassLoader();
                ArrayList classes = new ArrayList(1 + info.nodes.size());
                classes.add(elemClass);
                boolean ok = true;
                int m = info.nodes.size();
                for (int j = 1; j < m; ++j) {
                    Class<?> sec = info.nodes.get(j).getClass();
                    if (sec.getClassLoader() != elemClassLoader) {
                        ok = false;
                    }
                    classes.add(sec);
                }
                if (classes.size() > 2) {
                    System.err.println("CreateNodes: classes.size() == " + classes.size());
                }
                if (ok) {
                    try {
                        ++ComponentLoader.this.nbNewInstances;
                        info.result = (Node)elem.getClass().newInstance();
                        continue;
                    }
                    catch (Exception e) {
                        throw new ADLException("Cannot merge ASTs", elem, e);
                    }
                }
                try {
                    int hash = elemClass.hashCode();
                    int m2 = classes.size();
                    for (int j = 1; j < m2; ++j) {
                        hash = 17 * (hash + classes.get(j).hashCode());
                    }
                    String code = Integer.toHexString(hash);
                    String name = "org.objectweb.fractal.adl.merged.Merged" + code;
                    ++ComponentLoader.this.nbMergeClasses;
                    Class merged = ComponentLoader.this.mergeClassLoader.mergeClass(name, elem.astGetType(), classes.toArray(new Class[classes.size()]));
                    ++ComponentLoader.this.nbNewInstances;
                    info.result = (Node)merged.newInstance();
                }
                catch (Exception e) {
                    throw new ADLException("Cannot merge AST classes", elem, e);
                }
            }
        }

        Node initMergedNodes(MergeInfo info) {
            Node result;
            if (info.done) {
                return info.result;
            }
            info.done = true;
            Node elem = (Node)info.nodes.get(0);
            if (elem == (result = info.result)) {
                System.err.println(info + ": elem == result");
            }
            result.astSetSource(elem.astGetSource());
            AbstractNode an = (AbstractNode)result;
            int mi = info.nodes.size();
            for (int i = 0; i < mi; ++i) {
                AbstractNode node = (AbstractNode)info.nodes.get(i);
                an.astSetAttributes(node);
                an.astSetDecorations(node);
            }
            ArrayList<Node> resultNodes = new ArrayList<Node>();
            String[] nodeTypes = info.nodeTypes;
            if (nodeTypes == null) {
                System.err.println(info + ": nodeTypes is null !!!!");
            } else {
                for (String nodeType : nodeTypes) {
                    int j;
                    String nameAttr = (String)ComponentLoader.this.NAME_ATTRIBUTES.get(nodeType);
                    Node[] nodes = elem.astGetNodes(nodeType);
                    if (nodes == null) {
                        nodes = new Node[]{};
                    }
                    String[] nodeNames = new String[nodes.length];
                    for (j = 0; j < nodes.length; ++j) {
                        if (nodes[j] == null) continue;
                        resultNodes.add(nodes[j]);
                        if (nameAttr == null) continue;
                        nodeNames[j] = nodes[j].astGetAttribute(nameAttr);
                    }
                    if (info.nodes.size() > 2) {
                        System.err.println("InitNodes: info.nodes.size() > 2 !!!!");
                    }
                    int m = info.nodes.size();
                    for (j = 1; j < m; ++j) {
                        Node superElem = (Node)info.nodes.get(j);
                        Node[] superNodes = superElem.astGetNodes(nodeType);
                        if (superNodes == null) continue;
                        if (nameAttr == null) {
                            if (superNodes.length <= 0 || superNodes[0] == null) continue;
                            if (nodes.length == 0 || nodes[0] == null) {
                                resultNodes.add(superNodes[0]);
                                continue;
                            }
                            resultNodes.set(0, nodes[0]);
                            continue;
                        }
                        for (int k = 0; k < superNodes.length; ++k) {
                            String superName = superNodes[k].astGetAttribute(nameAttr);
                            int index = -1;
                            for (int l = 0; l < nodes.length; ++l) {
                                if (!nodeNames[l].equals(superName)) continue;
                                index = l;
                                break;
                            }
                            if (index == -1) {
                                resultNodes.add(superNodes[k]);
                                continue;
                            }
                            resultNodes.set(index, nodes[index]);
                        }
                    }
                    m = resultNodes.size();
                    for (j = 0; j < m; ++j) {
                        result.astAddNode(this.initMergedNodes((MergeInfo)this.infos.get(resultNodes.get(j))));
                    }
                    resultNodes.clear();
                }
            }
            return info.result;
        }
    }
}

