/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.implementations;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.fractal.adl.implementations.ImplementationBuilder;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.Type;
import org.objectweb.fractal.api.factory.GenericFactory;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.util.Fractal;

public class FractalImplementationBuilder
implements ImplementationBuilder {
    static int nbTimer = 0;
    static long totalTimer = 0L;

    public Object createComponent(Object type, String name, String definition, Object controllerDesc, Object contentDesc, Object context) throws Exception {
        Object[] objectArray;
        long tb = System.currentTimeMillis();
        ClassLoader loader = null;
        if (context instanceof Map) {
            loader = (ClassLoader)((Map)context).get("classloader");
        }
        Component bootstrap = null;
        if (context != null) {
            bootstrap = (Component)((Map)context).get("bootstrap");
        }
        if (bootstrap == null) {
            if (loader != null) {
                HashMap<String, ClassLoader> ctxt = new HashMap<String, ClassLoader>();
                ctxt.put("classloader", loader);
                bootstrap = Fractal.getBootstrapComponent(ctxt);
            } else {
                bootstrap = Fractal.getBootstrapComponent();
            }
        }
        GenericFactory genericFactory = Fractal.getGenericFactory(bootstrap);
        ComponentType componentType = (ComponentType)type;
        if (loader == null) {
            objectArray = controllerDesc;
        } else {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = loader;
            objectArray = objectArray2;
            objectArray2[1] = controllerDesc;
        }
        Component result = genericFactory.newFcInstance((Type)componentType, (Object)objectArray, contentDesc);
        try {
            Fractal.getNameController((Component)result).setFcName(name);
        }
        catch (NoSuchInterfaceException ignored) {
            // empty catch block
        }
        FractalImplementationBuilder.incrTimer(System.currentTimeMillis() - tb);
        return result;
    }

    static void incrTimer(long t) {
        totalTimer += t;
        ++nbTimer;
    }

    public static void printStats() {
        System.err.println("FractalImplementationBuilder: " + totalTimer + " milliseconds in " + nbTimer + " calls.");
        nbTimer = 0;
        totalTimer = 0L;
    }
}

