/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.implementations;

import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.attributes.Attributes;
import org.objectweb.fractal.adl.attributes.AttributesContainer;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.implementations.Controller;
import org.objectweb.fractal.adl.implementations.ControllerContainer;
import org.objectweb.fractal.adl.implementations.Implementation;
import org.objectweb.fractal.adl.implementations.ImplementationContainer;
import org.objectweb.fractal.adl.interfaces.Interface;
import org.objectweb.fractal.adl.interfaces.InterfaceContainer;
import org.objectweb.fractal.adl.types.TypeInterface;

public class ImplementationLoader
extends AbstractLoader {
    public Definition load(String name, Map context) throws ADLException {
        Definition d = this.clientLoader.load(name, context);
        long tb = System.currentTimeMillis();
        this.checkNode(d, context);
        this.incrTimer(System.currentTimeMillis() - tb);
        return d;
    }

    private void checkNode(Object node, Map context) throws ADLException {
        if (node instanceof ImplementationContainer) {
            this.checkImplementationContainer((ImplementationContainer)node, context);
        }
        if (node instanceof ControllerContainer) {
            this.checkControllerContainer((ControllerContainer)node);
        }
        if (node instanceof ComponentContainer) {
            Component[] comps = ((ComponentContainer)node).getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.checkNode(comps[i], context);
            }
        }
    }

    private void checkImplementationContainer(ImplementationContainer container, Map context) throws ADLException {
        Implementation impl = container.getImplementation();
        if (impl != null) {
            Attributes attrs;
            Class c;
            String className = impl.getClassName();
            if (className == null) {
                this.reportError(new ADLException("Implementation class name missing", (Node)((Object)impl)));
                return;
            }
            try {
                c = this.loadClass(context, className);
            }
            catch (ClassNotFoundException e) {
                this.reportError(new ADLException("Invalid signature '" + className + "'", (Node)((Object)impl), e));
                return;
            }
            if (container instanceof InterfaceContainer) {
                Interface[] itfs = ((InterfaceContainer)((Object)container)).getInterfaces();
                for (int i = 0; i < itfs.length; ++i) {
                    Class d;
                    TypeInterface itf;
                    if (!(itfs[i] instanceof TypeInterface) || !(itf = (TypeInterface)itfs[i]).getRole().equals("server")) continue;
                    try {
                        d = this.loadClass(context, itf.getSignature());
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (this.isAssignable(d, c)) continue;
                    this.reportError(new ADLException("The implementation class does not implement the \"" + itf.getSignature() + "\" server interface of the component", (Node)((Object)impl)));
                }
            }
            if (container instanceof AttributesContainer && (attrs = ((AttributesContainer)((Object)container)).getAttributes()) != null) {
                Class d;
                try {
                    d = this.loadClass(context, attrs.getSignature());
                }
                catch (Exception e) {
                    return;
                }
                if (!this.isAssignable(d, c)) {
                    this.reportError(new ADLException("The implementation class does not implement the \"" + attrs.getSignature() + "\" attribute controller interface of the component", (Node)((Object)impl)));
                }
            }
        }
    }

    private void checkControllerContainer(ControllerContainer container) throws ADLException {
        Controller ctrl = container.getController();
        if (ctrl != null && ctrl.getDescriptor() == null) {
            this.reportError(new ADLException("Controller descriptor missing", (Node)((Object)ctrl)));
        }
    }
}

