/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.cmdline.lib;

import java.io.PrintStream;
import org.objectweb.util.cmdline.api.Application;
import org.objectweb.util.cmdline.api.CommandLine;
import org.objectweb.util.cmdline.api.Console;
import org.objectweb.util.cmdline.lib.DefaultCommandLineHolder;
import org.objectweb.util.cmdline.lib.DefaultConsole;
import org.objectweb.util.cmdline.lib.DefaultOptionSilentMessage;
import org.objectweb.util.cmdline.lib.DefaultOptionVersion;
import org.objectweb.util.misc.api.ExceptionWrapper;

public abstract class ApplicationBase
extends DefaultCommandLineHolder
implements Application {
    private Console console_;

    public ApplicationBase() {
        this(null, false, true);
    }

    public ApplicationBase(CommandLine commandLine) {
        this(commandLine, false, true);
    }

    public ApplicationBase(CommandLine commandLine, boolean withDefaultOptions) {
        this(commandLine, false, withDefaultOptions);
    }

    public ApplicationBase(CommandLine commandLine, boolean silentMessage, boolean withDefaultOptions) {
        super(commandLine);
        this.setConsole(new DefaultConsole(this.getIdentity(), silentMessage));
        if (withDefaultOptions) {
            if (withDefaultOptions && commandLine != null) {
                commandLine.addOption(new DefaultOptionVersion(this));
            }
            if (commandLine != null) {
                commandLine.addOption(new DefaultOptionSilentMessage(this.console_));
            }
        }
    }

    protected void report_property(String propertyName) {
        this.getConsole().getErrorStream().println("System property " + propertyName + " = " + System.getProperty(propertyName));
    }

    public String getIdentity() {
        return this.getClass().getName();
    }

    public Console getConsole() {
        return this.console_;
    }

    public void setConsole(Console console) {
        this.console_ = console;
        this.getCommandLine().setConsole(console);
    }

    public String getMailingList() {
        return "openccm@objectweb.org";
    }

    public String[] getVersionInformation() {
        return new String[]{this.getIdentity(), "", "Copyright (C) 2000-2003 INRIA & USTL - LIFL - GOAL", "This is free software; you can redistribute it and/or", "modify it under the terms of the GNU Lesser General Public", "License as published by the Free Software Foundation; either", "version 2.1 of the License, or any later version.", "", "This is distributed in the hope that it will be useful,", "but WITHOUT ANY WARRANTY; without even the implied warranty of", "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU", "Lesser General Public License for more details.", "", "You should have received a copy of the GNU Lesser General Public", "License along with this library; if not, write to the Free Software", "Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA"};
    }

    public void report_exception(Exception exception) {
        PrintStream err = this.getConsole().getErrorStream();
        err.print("Please report the following exception trace to ");
        err.println(this.getMailingList());
        this.report_property("os.name");
        this.report_property("os.version");
        this.report_property("java.vendor");
        this.report_property("java.version");
        exception.printStackTrace();
    }

    public void runMain(String[] args) {
        try {
            String[] arguments = this.getCommandLine().parse(args);
            int status = this.start(arguments);
            System.exit(status);
        }
        catch (ExceptionWrapper exc) {
            this.report_exception(exc.getException());
        }
        catch (Exception exc) {
            this.report_exception(exc);
        }
    }

    public abstract int start(String[] var1);
}

