/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.cmdline.lib;

import java.io.PrintStream;
import org.objectweb.util.cmdline.api.Console;

public class DefaultConsole
implements Console {
    private PrintStream outputStream_;
    private PrintStream errorStream_;
    private String messageHeader_;
    private boolean silentMessage_;

    public DefaultConsole() {
        this("", false);
    }

    public DefaultConsole(String header) {
        this(header, false);
    }

    public DefaultConsole(String header, boolean silent) {
        this(System.out, System.err, header, silent);
    }

    public DefaultConsole(PrintStream output, PrintStream error, String header, boolean silent) {
        this.outputStream_ = output;
        this.errorStream_ = error;
        this.messageHeader_ = header;
        this.silentMessage_ = silent;
    }

    public PrintStream getOutputStream() {
        return this.outputStream_;
    }

    public void setOutputStream(PrintStream output) {
        this.outputStream_ = output;
    }

    public PrintStream getErrorStream() {
        return this.errorStream_;
    }

    public void setErrorStream(PrintStream error) {
        this.errorStream_ = error;
    }

    public String getMessageHeader() {
        return this.messageHeader_;
    }

    public void setMessageHeader(String header) {
        this.messageHeader_ = header;
    }

    public boolean getSilentMessage() {
        return this.silentMessage_;
    }

    public void setSilentMessage(boolean flag) {
        this.silentMessage_ = flag;
    }

    public void message(String text) {
        if (!this.silentMessage_) {
            this.getOutputStream().println(this.messageHeader_ + ": " + text);
        }
    }

    public void error(String text) {
        this.getErrorStream().println(this.messageHeader_ + ": " + text);
    }
}

