/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.explorer.attributes;

import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.objectweb.fractal.explorer.attributes.AttributeDescriptor;
import org.objectweb.fractal.explorer.attributes.AttributeMonitoringThread;
import org.objectweb.fractal.explorer.attributes.AttributeValueBooleanCellEditor;
import org.objectweb.fractal.explorer.attributes.AttributeValueCellRenderer;
import org.objectweb.fractal.explorer.attributes.AttributeValueDefaultCellEditor;
import org.objectweb.fractal.explorer.attributes.AttributesTableColumnModel;
import org.objectweb.fractal.explorer.attributes.AttributesTableModel;
import org.objectweb.fractal.explorer.attributes.AttributesTableModelBuilder;
import org.objectweb.fractal.explorer.panel.MonitorCellEditor;
import org.objectweb.fractal.explorer.panel.MonitorCellRenderer;

public class AttributesTable
extends JTable {
    protected Object attributeObject = null;
    private TableCellEditor monitorEditor = null;
    private TableCellRenderer monitorRenderer = null;
    private TableCellEditor attributeValueDefaultEditor = null;
    private TableCellEditor attributeValueBooleanEditor = null;
    private TableCellRenderer attributeValueRenderer = null;
    static /* synthetic */ Class class$java$lang$String;

    public AttributesTable(Object selectedNode, JPanel owner) {
        this.attributeObject = selectedNode;
        this.setColumnModel(new AttributesTableColumnModel());
        this.setModel(AttributesTableModelBuilder.buildAttributesTableModel(this.attributeObject));
        this.dataModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                int row = e.getFirstRow();
                int column = e.getColumn();
                if (column == 1) {
                    if (AttributesTable.this.getValueAt(row, 2).equals(AttributesTableModel.MONITOR_ACTIONS[1])) {
                        return;
                    }
                    String methodName = "set" + AttributesTable.this.getValueAt(row, 0);
                    Object newValue = AttributesTable.this.dataModel.getValueAt(row, column);
                    boolean invoke = false;
                    Class<Object> invokeType = null;
                    if (newValue instanceof String) {
                        invokeType = class$java$lang$String == null ? (class$java$lang$String = AttributesTable.class$("java.lang.String")) : class$java$lang$String;
                        invoke = true;
                    } else if (newValue instanceof Integer) {
                        invokeType = Integer.TYPE;
                        invoke = true;
                    } else if (newValue instanceof Boolean) {
                        invokeType = Boolean.TYPE;
                        invoke = true;
                    } else if (newValue instanceof Short) {
                        invokeType = Short.TYPE;
                        invoke = true;
                    } else if (newValue instanceof Long) {
                        invokeType = Long.TYPE;
                        invoke = true;
                    } else if (newValue instanceof Double) {
                        invokeType = Double.TYPE;
                        invoke = true;
                    } else if (newValue instanceof Float) {
                        invokeType = Float.TYPE;
                        invoke = true;
                    }
                    if (invoke) {
                        Class<?> attributeClass = AttributesTable.this.attributeObject.getClass();
                        try {
                            attributeClass.getMethod(methodName, invokeType).invoke(AttributesTable.this.attributeObject, newValue);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        });
        this.monitorEditor = new MonitorCellEditor(new JCheckBox());
        this.monitorRenderer = new MonitorCellRenderer();
        this.attributeValueDefaultEditor = new AttributeValueDefaultCellEditor(new JTextField());
        this.attributeValueBooleanEditor = new AttributeValueBooleanCellEditor(new JCheckBox());
        this.attributeValueRenderer = new AttributeValueCellRenderer();
        this.getColumn("AttributeValue").setCellRenderer(this.attributeValueRenderer);
        this.getColumn("Monitor").setCellRenderer(this.monitorRenderer);
    }

    public boolean getDragEnabled() {
        return false;
    }

    public TableCellEditor getCellEditor(int row, int col) {
        if (col == 1) {
            Object value = this.getValueAt(row, col);
            if (value instanceof Boolean) {
                return this.attributeValueBooleanEditor;
            }
            return this.attributeValueDefaultEditor;
        }
        if (col == 2) {
            return this.monitorEditor;
        }
        return super.getCellEditor(row, col);
    }

    public String getToolTipText(MouseEvent e) {
        String tip = null;
        Point p = e.getPoint();
        int rowIndex = this.rowAtPoint(p);
        int colIndex = this.columnAtPoint(p);
        int realColumnIndex = this.convertColumnIndexToModel(colIndex);
        if (realColumnIndex == 1) {
            TableModel model = this.getModel();
            String attributeName = (String)model.getValueAt(rowIndex, 0);
            if (this.isCellEditable(rowIndex, colIndex)) {
                Object attributeValue = model.getValueAt(rowIndex, 1);
                if (attributeValue instanceof Boolean) {
                    boolean boolValue = (Boolean)attributeValue;
                    tip = "Click to set the '" + attributeName + "' attribute to '" + !boolValue + "'";
                } else {
                    tip = "Click to modify the '" + attributeName + "' attribute";
                }
            } else {
                tip = "Attribute '" + attributeName + "' is non-modifiable";
            }
        } else if (realColumnIndex == 2) {
            TableModel model = this.getModel();
            String attributeName = (String)model.getValueAt(rowIndex, 0);
            String option = model.getValueAt(rowIndex, 2).toString();
            tip = "Click to " + option + " monitoring the '" + attributeName + "' attribute";
        }
        return tip;
    }

    public void destroyAttributeMonitors() {
        AttributesTableModel aModel = (AttributesTableModel)this.dataModel;
        AttributeDescriptor[] descriptors = aModel.getAttributeDescriptors();
        for (int i = 0; i < descriptors.length; ++i) {
            if (descriptors[i] != null && descriptors[i].hasMonitor()) {
                AttributeMonitoringThread monitor = (AttributeMonitoringThread)descriptors[i].getMonitor();
                monitor.running = false;
            }
            descriptors[i] = null;
        }
    }

    public Object getAttributeObject() {
        return this.attributeObject;
    }
}

