/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.explorer.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.Factory;
import org.objectweb.fractal.adl.FactoryFactory;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.api.control.SuperController;
import org.objectweb.fractal.api.type.InterfaceType;

public class GraphInformations {
    public static Component getRootComponent(String nameAppli) {
        try {
            Factory f = FactoryFactory.getFactory((String)"org.objectweb.fractal.adl.FractalBackend");
            Object o = f.newComponent(nameAppli, new HashMap());
            return (Component)o;
        }
        catch (ADLException e) {
            System.out.println("Application " + nameAppli + " not found");
            return null;
        }
    }

    public static boolean isPrimitiveComponent(Component component) {
        try {
            ContentController cc = (ContentController)component.getFcInterface("content-controller");
            Component[] subComponents = cc.getFcSubComponents();
            return subComponents.length == 0;
        }
        catch (NoSuchInterfaceException e) {
            return true;
        }
    }

    public static String getComponentType(Component component) {
        try {
            ContentController cc = (ContentController)component.getFcInterface("content-controller");
            Component[] subComponents = cc.getFcSubComponents();
            if (subComponents.length == 0) {
                return "primitif";
            }
            return "composite";
        }
        catch (NoSuchInterfaceException e) {
            return "primitif";
        }
    }

    public static boolean isSharedComponent(Component component) {
        try {
            SuperController sc = (SuperController)component.getFcInterface("super-controller");
            Component[] superComponents = sc.getFcSuperComponents();
            return superComponents.length > 1;
        }
        catch (NoSuchInterfaceException e) {
            return false;
        }
    }

    public static Component[] getSubComponents(Component component) {
        try {
            if (!GraphInformations.isPrimitiveComponent(component)) {
                ContentController cc = (ContentController)component.getFcInterface("content-controller");
                return cc.getFcSubComponents();
            }
        }
        catch (NoSuchInterfaceException e) {
            return null;
        }
        return null;
    }

    public static String getComponentState(Component component) {
        try {
            LifeCycleController lc = (LifeCycleController)component.getFcInterface("lifecycle-controller");
            return lc.getFcState();
        }
        catch (NoSuchInterfaceException e) {
            return "unknown state";
        }
    }

    public static boolean isStarted(Component component) {
        return GraphInformations.getComponentState(component).equals("STARTED");
    }

    public static Interface[] getSortExtItf(Component component) {
        Object[] listExtItfObj = component.getFcInterfaces();
        Interface[] listItfExtItf = new Interface[listExtItfObj.length];
        ArrayList<Object> listExtItf = new ArrayList<Object>();
        for (int i = 0; i < listExtItfObj.length; ++i) {
            listExtItf.add(i, listExtItfObj[i]);
        }
        Collections.sort(listExtItf, new SortInterface());
        for (int j = 0; j < listExtItf.size(); ++j) {
            listItfExtItf[j] = (Interface)listExtItf.get(j);
        }
        return listItfExtItf;
    }

    public static Interface[] getIntItf(Component component) {
        try {
            ContentController cc = (ContentController)component.getFcInterface("content-controller");
            Object[] listIntItfObj = cc.getFcInternalInterfaces();
            Interface[] listIntItf = new Interface[listIntItfObj.length];
            for (int i = 0; i < listIntItfObj.length; ++i) {
                listIntItf[i] = (Interface)listIntItfObj[i];
            }
            return listIntItf;
        }
        catch (NoSuchInterfaceException e) {
            System.out.println("No internal interfaces");
            return null;
        }
    }

    public static String getInterfaceName(Interface itf) {
        if (itf == null) {
            return "unknown";
        }
        if (GraphInformations.isControlInterface(itf)) {
            if (itf.getFcItfName().equals("component")) {
                return "C";
            }
            if (itf.getFcItfName().equals("factory")) {
                return "F";
            }
            return itf.getFcItfName().substring(0, 1).toUpperCase() + "C";
        }
        return itf.getFcItfName();
    }

    public static boolean isClientInterface(Interface itf) {
        InterfaceType itType = (InterfaceType)itf.getFcItfType();
        return itType.isFcClientItf();
    }

    public static boolean isControlInterface(Interface itf) {
        return itf.getFcItfName().endsWith("-controller") || itf.getFcItfName().equals("component") || itf.getFcItfName().equals("factory");
    }

    public static boolean isCollectionInterface(Interface itf) {
        InterfaceType itType = (InterfaceType)itf.getFcItfType();
        return itType.isFcCollectionItf();
    }

    public static boolean isOptional(Interface itf) {
        InterfaceType itType = (InterfaceType)itf.getFcItfType();
        return itType.isFcOptionalItf();
    }

    public static List getItfCollection(Component component) {
        Interface[] listExtItf = GraphInformations.getSortExtItf(component);
        ArrayList<InterfaceType> listItfCollection = new ArrayList<InterfaceType>();
        ArrayList<String> listNameCollection = new ArrayList<String>();
        for (int i = 0; i < listExtItf.length; ++i) {
            InterfaceType itType;
            String nameItf;
            if (!GraphInformations.isCollectionInterface(listExtItf[i]) || listNameCollection.contains(nameItf = (itType = (InterfaceType)listExtItf[i].getFcItfType()).getFcItfName())) continue;
            listNameCollection.add(nameItf);
            listItfCollection.add(itType);
        }
        return listItfCollection;
    }

    public static String getPortType(Interface itf) {
        if (GraphInformations.isClientInterface(itf)) {
            if (GraphInformations.isCollectionInterface(itf)) {
                return "collection";
            }
            return "client";
        }
        if (GraphInformations.isControlInterface(itf)) {
            return "controler";
        }
        return "server";
    }

    public static String getSignature(Interface itf) {
        InterfaceType itType = (InterfaceType)itf.getFcItfType();
        return itType.getFcItfSignature();
    }

    public static Component getTargetComponent(Component component, Interface itf) {
        try {
            BindingController bc = (BindingController)component.getFcInterface("binding-controller");
            Interface destItf = (Interface)bc.lookupFc(itf.getFcItfName());
            if (destItf != null) {
                return destItf.getFcItfOwner();
            }
            return null;
        }
        catch (NoSuchInterfaceException e) {
            return null;
        }
    }

    public static Interface getTargetInterface(Component component, Interface itf) {
        try {
            BindingController bc = (BindingController)component.getFcInterface("binding-controller");
            return (Interface)bc.lookupFc(itf.getFcItfName());
        }
        catch (NoSuchInterfaceException e) {
            return null;
        }
    }

    public static List getServerNeighbors(Component primitiveComponent) {
        if (GraphInformations.isSharedComponent(primitiveComponent)) {
            return new ArrayList();
        }
        try {
            SuperController sc = (SuperController)primitiveComponent.getFcInterface("super-controller");
            Component[] listSuperComponents = sc.getFcSuperComponents();
            Component superComponent = listSuperComponents[0];
            Component[] listSubComponents = GraphInformations.getSubComponents(superComponent);
            ArrayList<Component> neighborsList = new ArrayList<Component>();
            for (int i = 0; i < listSubComponents.length; ++i) {
                Component subComponent = listSubComponents[i];
                Interface[] listExtItf = GraphInformations.getSortExtItf(subComponent);
                for (int j = 0; j < listExtItf.length; ++j) {
                    Component targetComponent;
                    if (!GraphInformations.isClientInterface(listExtItf[j]) || !(targetComponent = GraphInformations.getTargetComponent(subComponent, listExtItf[j])).equals(primitiveComponent) || neighborsList.contains(subComponent)) continue;
                    neighborsList.add(subComponent);
                }
            }
            return neighborsList;
        }
        catch (NoSuchInterfaceException e) {
            return new ArrayList();
        }
    }

    public static List getClientNeighbors(Component primitiveComponent) {
        if (GraphInformations.isSharedComponent(primitiveComponent)) {
            return new ArrayList();
        }
        ArrayList<Component> neighborsList = new ArrayList<Component>();
        Interface[] listExtItf = GraphInformations.getSortExtItf(primitiveComponent);
        for (int i = 0; i < listExtItf.length; ++i) {
            Component targetComponent;
            if (!GraphInformations.isClientInterface(listExtItf[i]) || neighborsList.contains(targetComponent = GraphInformations.getTargetComponent(primitiveComponent, listExtItf[i])) || GraphInformations.getTargetInterface(primitiveComponent, listExtItf[i]).isFcInternalItf()) continue;
            neighborsList.add(targetComponent);
        }
        return neighborsList;
    }

    public static class SortInterface
    implements Comparator {
        protected int compare(Interface itf1, Interface itf2) {
            return itf1.getFcItfName().compareTo(itf2.getFcItfName());
        }

        public int compare(Object o1, Object o2) {
            return this.compare((Interface)o1, (Interface)o2);
        }
    }
}

