/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.explorer.icon;

import javax.swing.Icon;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.api.control.SuperController;
import org.objectweb.fractal.explorer.FcExplorer;
import org.objectweb.fractal.explorer.icon.InterfaceIconProvider;

public class LifeCycleComponentIconProvider
extends InterfaceIconProvider {
    protected void loadFc(String name) {
        this.getIcons().put(name, new Icon[]{this.load("icons/Fc" + name + "Started.png"), this.load("icons/Fc" + name + "Stopped.png")});
    }

    public LifeCycleComponentIconProvider() {
        this.loadFc("Primitive");
        this.loadFc("Composite");
        this.loadFc("Shared");
    }

    protected Icon[] loadIcon(Component cpt) {
        try {
            SuperController sc = FcExplorer.getSuperController(cpt);
            if (sc.getFcSuperComponents().length > 1) {
                return (Icon[])this.getIcons().get("Shared");
            }
        }
        catch (NoSuchInterfaceException e) {
            // empty catch block
        }
        try {
            FcExplorer.getContentController(cpt);
            return (Icon[])this.getIcons().get("Composite");
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            return (Icon[])this.getIcons().get("Primitive");
        }
    }

    public Object newIcon(Object object) {
        Component ci = (Component)object;
        Icon[] lcc_icons = this.loadIcon(ci);
        if (lcc_icons == null) {
            return null;
        }
        LifeCycleController lcc = null;
        try {
            lcc = FcExplorer.getLifeCycleController(ci);
        }
        catch (NoSuchInterfaceException e) {
            return lcc_icons[0];
        }
        String status = lcc.getFcState();
        if (status.equals("STARTED")) {
            return lcc_icons[0];
        }
        if (status.equals("STOPPED")) {
            return lcc_icons[1];
        }
        return null;
    }
}

