/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.explorer.menu;

import java.awt.Dimension;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.util.explorer.api.MenuItem;
import org.objectweb.util.explorer.api.MenuItemTreeView;
import org.objectweb.util.explorer.api.Tree;
import org.objectweb.util.explorer.api.TreeView;
import org.objectweb.util.explorer.swing.gui.api.DialogAction;
import org.objectweb.util.explorer.swing.gui.api.ElementBox;
import org.objectweb.util.explorer.swing.gui.lib.DefaultDialogBox;
import org.objectweb.util.explorer.swing.gui.lib.TreeBox;

public class RemoveSubComponentAction
implements MenuItem,
DialogAction {
    protected TreeBox treeBox_;
    protected ContentController contentInterface_;

    public int getStatus(TreeView treeView) {
        ContentController contentInterface = (ContentController)treeView.getSelectedObject();
        Component component = ((Interface)contentInterface).getFcItfOwner();
        try {
            LifeCycleController lcc = (LifeCycleController)component.getFcInterface("lifecycle-controller");
            String status = lcc.getFcState();
            if (status.equals("STARTED")) {
                return 2;
            }
        }
        catch (NoSuchInterfaceException e) {
            // empty catch block
        }
        return 1;
    }

    public void actionPerformed(MenuItemTreeView e) throws Exception {
        this.contentInterface_ = (ContentController)e.getSelectedObject();
        Component treeComponent = e.getTree().duplicate(false);
        Tree treeItf = (Tree)treeComponent.getFcInterface("tree");
        treeItf.addEntry((Object)"Content Interface", (Object)this.contentInterface_, 1);
        this.treeBox_ = new TreeBox(treeComponent);
        this.treeBox_.setPreferredSize(new Dimension(450, 350));
        DefaultDialogBox dialog = new DefaultDialogBox("Select a component to remove");
        dialog.setValidateAction((DialogAction)this);
        dialog.addElementBox((ElementBox)this.treeBox_);
        dialog.show();
    }

    public void executeAction() throws Exception {
        Object o = this.treeBox_.getObject();
        try {
            Component subComponent = (Component)o;
            this.contentInterface_.removeFcSubComponent(subComponent);
        }
        catch (ClassCastException e1) {
            throw new Exception("You must select a ComponentIdentity !");
        }
    }
}

