/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.explorer.menu;

import javax.swing.JOptionPane;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.Type;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.explorer.FcExplorer;
import org.objectweb.fractal.explorer.context.ClientInterfaceWrapper;
import org.objectweb.util.explorer.api.MenuItem;
import org.objectweb.util.explorer.api.MenuItemTreeView;
import org.objectweb.util.explorer.api.TreeView;

public class UnbindAction
implements MenuItem {
    public int getStatus(TreeView treeView) {
        boolean started = false;
        ClientInterfaceWrapper cirw = (ClientInterfaceWrapper)treeView.getSelectedObject();
        Interface ir = cirw.getItf();
        Component component = ir.getFcItfOwner();
        try {
            LifeCycleController lcc = FcExplorer.getLifeCycleController(component);
            String status = lcc.getFcState();
            if (status.equals("STARTED")) {
                started = true;
            }
        }
        catch (NoSuchInterfaceException e1) {
            e1.printStackTrace();
        }
        Interface bindInterface = null;
        try {
            BindingController bc = FcExplorer.getBindingController(component);
            bindInterface = (Interface)bc.lookupFc(ir.getFcItfName());
        }
        catch (Exception e) {
            return 3;
        }
        if (bindInterface != null && !started) {
            return 1;
        }
        if (bindInterface != null && started) {
            return 2;
        }
        if (bindInterface == null) {
            return 3;
        }
        return 2;
    }

    public void actionPerformed(MenuItemTreeView e) throws Exception {
        InterfaceType it;
        ClientInterfaceWrapper irWrapper = (ClientInterfaceWrapper)e.getSelectedObject();
        Interface ir = irWrapper.getItf();
        Component ci = ir.getFcItfOwner();
        BindingController bc = FcExplorer.getBindingController(ci);
        bc.unbindFc(ir.getFcItfName());
        StringBuffer message = new StringBuffer();
        message.append("\"" + ir.getFcItfName() + "\" interface has been successfully unbound !\n");
        Type t = ci.getFcType();
        if (ComponentType.class.isAssignableFrom(t.getClass()) && !(it = (InterfaceType)ir.getFcItfType()).isFcOptionalItf() && !it.isFcCollectionItf()) {
            message.append("This interface is mandatory, so, rebind it before starting the component again.");
        }
        JOptionPane.showMessageDialog(null, message.toString(), "Unbind success", 1);
    }
}

