/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.explorer.panel;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.explorer.FcExplorer;
import org.objectweb.fractal.explorer.context.ClientCollectionInterfaceContainer;
import org.objectweb.fractal.explorer.context.ClientInterfaceWrapper;
import org.objectweb.fractal.explorer.lib.SignatureWrapper;
import org.objectweb.fractal.explorer.panel.TableClientCollectionWrapper;
import org.objectweb.util.explorer.api.Entry;
import org.objectweb.util.explorer.api.Table;
import org.objectweb.util.explorer.api.TreeView;
import org.objectweb.util.explorer.core.common.api.ContextContainer;
import org.objectweb.util.explorer.core.naming.lib.DefaultEntry;

public class ComponentTable
implements Table {
    protected Entry getBoundInterface(Interface itf, BindingController bc) {
        if (bc != null) {
            try {
                Interface bindInterface = (Interface)bc.lookupFc(itf.getFcItfName());
                if (bindInterface != null) {
                    return new DefaultEntry((Object)FcExplorer.getPrefixedName(bindInterface), (Object)bindInterface);
                }
            }
            catch (NoSuchInterfaceException e) {
                return null;
            }
        }
        return null;
    }

    public String[] getHeaders(TreeView treeView) {
        return new String[]{"Interface", "Type", "Connected"};
    }

    public Object[][] getRows(TreeView treeView) {
        Hashtable<String, ClientCollectionInterfaceContainer> collections = new Hashtable<String, ClientCollectionInterfaceContainer>();
        Vector<Object[]> rows = new Vector<Object[]>();
        Component component = (Component)treeView.getSelectedObject();
        BindingController bc = null;
        try {
            bc = FcExplorer.getBindingController(component);
        }
        catch (Exception e) {
            // empty catch block
        }
        ComponentType cType = (ComponentType)component.getFcType();
        InterfaceType[] iTypes = cType.getFcInterfaceTypes();
        for (int i = 0; i < iTypes.length; ++i) {
            if (!FcExplorer.isClientCollection(iTypes[i])) continue;
            ClientCollectionInterfaceContainer cc = new ClientCollectionInterfaceContainer(iTypes[i], component);
            collections.put(iTypes[i].getFcItfName(), cc);
        }
        Object[] interfaces = component.getFcInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Interface itf;
            if (component.equals(interfaces[i]) || FcExplorer.isController(itf = (Interface)interfaces[i])) continue;
            String signature = ((InterfaceType)itf.getFcItfType()).getFcItfSignature();
            InterfaceType iType = (InterfaceType)itf.getFcItfType();
            if (FcExplorer.isClientCollection(itf)) {
                String name = FcExplorer.getName(itf);
                ((ContextContainer)collections.get(iType.getFcItfName())).addEntry((Object)name, (Object)new TableClientCollectionWrapper(itf));
                continue;
            }
            if (FcExplorer.isClient(itf)) {
                rows.add(new Object[]{new DefaultEntry((Object)FcExplorer.getName(itf), (Object)new ClientInterfaceWrapper(itf)), new DefaultEntry((Object)signature, (Object)new SignatureWrapper(signature)), this.getBoundInterface(itf, bc)});
                continue;
            }
            rows.add(new Object[]{new DefaultEntry((Object)FcExplorer.getName(itf), (Object)itf), new DefaultEntry((Object)signature, (Object)new SignatureWrapper(signature)), null});
        }
        Enumeration i = collections.elements();
        while (i.hasMoreElements()) {
            ClientCollectionInterfaceContainer collection = (ClientCollectionInterfaceContainer)((Object)i.nextElement());
            Entry[] entries = collection.getEntries(null);
            String signature = collection.getItf().getFcItfSignature();
            if (entries.length == 0) {
                rows.add(new Object[]{new DefaultEntry((Object)collection.getItf().getFcItfName(), (Object)collection), new DefaultEntry((Object)signature, (Object)new SignatureWrapper(signature)), null});
                continue;
            }
            for (int j = 0; j < entries.length; ++j) {
                Interface itf = ((TableClientCollectionWrapper)entries[j].getValue()).getItf();
                rows.add(new Object[]{entries[j], new DefaultEntry((Object)signature, (Object)new SignatureWrapper(signature)), this.getBoundInterface(itf, bc)});
            }
        }
        Object[][] contenu = new Object[rows.size()][2];
        for (int i2 = 0; i2 < rows.size(); ++i2) {
            contenu[i2] = (Object[])rows.get(i2);
        }
        return contenu;
    }
}

