/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.explorer.panel;

import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.util.explorer.api.Table;
import org.objectweb.util.explorer.api.TreeView;

public class ComponentTypeTable
implements Table {
    protected String getType(InterfaceType itfType) {
        if (itfType.getFcItfName().endsWith("-controller")) {
            return "Controller";
        }
        return itfType.isFcClientItf() ? "Client" : "Server";
    }

    protected Object[] getValues(InterfaceType itfType) {
        Object[] row = new Object[]{itfType.getFcItfName(), itfType.getFcItfSignature(), this.getType(itfType), itfType.isFcCollectionItf() ? "Collection" : "Single", itfType.isFcOptionalItf() ? "Optional" : "Mandatory"};
        return row;
    }

    public String[] getHeaders(TreeView treeView) {
        return new String[]{"Name", "Signature", "Type", "Cardinality", "Contingency"};
    }

    public Object[][] getRows(TreeView treeView) {
        ComponentType ct = (ComponentType)treeView.getSelectedObject();
        InterfaceType[] objects = ct.getFcInterfaceTypes();
        Object[][] values = new Object[objects.length][5];
        int j = 0;
        for (int i = 0; i < objects.length; ++i) {
            values[j++] = this.getValues(objects[i]);
        }
        return values;
    }
}

