/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.explorer.panel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.util.explorer.api.Panel;
import org.objectweb.util.explorer.api.TreeView;

public class LifeCycleControllerComponentPanel
implements Panel {
    protected TreeView treeView_ = null;
    protected JPanel panel_ = new JPanel();

    public LifeCycleControllerComponentPanel() {
        this.panel_.setBackground(Color.white);
    }

    public Object getPanel() {
        return this.panel_;
    }

    public void selected(TreeView treeView) {
        this.treeView_ = treeView;
        Component ci = (Component)treeView.getSelectedObject();
        try {
            LifeCycleController lifeCycleController = (LifeCycleController)ci.getFcInterface("lifecycle-controller");
            String value = null;
            String status = lifeCycleController.getFcState();
            Box box_ = Box.createVerticalBox();
            box_.add(Box.createVerticalStrut(10));
            Box labelBox = Box.createHorizontalBox();
            labelBox.setAlignmentX(0.5f);
            labelBox.add(Box.createHorizontalGlue());
            JLabel labelValue = new JLabel("Component status : " + status);
            labelBox.add(labelValue);
            labelBox.add(Box.createHorizontalGlue());
            box_.add(labelBox);
            if (status.equals("STARTED")) {
                value = "Stop";
            } else if (status.equals("STOPPED")) {
                value = "Start";
            }
            box_.add(Box.createVerticalStrut(10));
            Box buttonBox = Box.createHorizontalBox();
            buttonBox.add(Box.createHorizontalGlue());
            JButton bt = new JButton(new StartStopAction(value, lifeCycleController));
            bt.setPreferredSize(new Dimension(100, 20));
            buttonBox.add(bt);
            buttonBox.add(Box.createHorizontalGlue());
            box_.add(buttonBox);
            box_.add(Box.createVerticalGlue());
            this.panel_.add(box_);
        }
        catch (NoSuchInterfaceException e) {
            e.printStackTrace();
        }
    }

    public void unselected(TreeView treeView) {
    }

    protected class StartStopAction
    extends AbstractAction {
        protected LifeCycleController lifeCycleController_;
        protected String value_;

        public StartStopAction(String value, LifeCycleController lcc) {
            super(value);
            this.value_ = value;
            this.lifeCycleController_ = lcc;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (this.value_.equals("Start")) {
                    this.lifeCycleController_.startFc();
                } else if (this.value_.equals("Stop")) {
                    this.lifeCycleController_.stopFc();
                }
            }
            catch (IllegalLifeCycleException e1) {
                e1.printStackTrace();
            }
            LifeCycleControllerComponentPanel.this.treeView_.getTree().refreshAll();
        }
    }
}

