/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.explorer.panel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import org.objectweb.fractal.explorer.attributes.AttributeDescriptor;
import org.objectweb.fractal.explorer.attributes.AttributeMonitoringThread;
import org.objectweb.fractal.explorer.attributes.AttributesTable;
import org.objectweb.fractal.explorer.attributes.AttributesTableModel;

public class MonitorCellEditor
extends DefaultCellEditor {
    protected JButton button = new JButton();
    private String label = null;
    private boolean initialized = false;
    private MonitorEditorActionListener actionListener = null;
    int row;
    int column;

    public MonitorCellEditor(JCheckBox checkBox) {
        super(checkBox);
        this.button.setOpaque(true);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row1, int column1) {
        if (!this.initialized) {
            this.button.setFont(table.getFont());
            this.actionListener = new MonitorEditorActionListener(table);
            this.button.addActionListener(this.actionListener);
            this.initialized = true;
        }
        this.row = row1;
        this.column = column1;
        this.button.setBackground(table.getBackground());
        this.label = value == null ? "" : value.toString();
        this.button.setText(this.label);
        this.button.setFont(table.getFont());
        return this.button;
    }

    private class MonitorEditorActionListener
    implements ActionListener {
        private JTable table = null;

        public MonitorEditorActionListener(JTable table) {
            this.table = table;
        }

        public void actionPerformed(ActionEvent evt) {
            String state = this.table.getValueAt(MonitorCellEditor.this.row, MonitorCellEditor.this.column).toString();
            if (state.equals(AttributesTableModel.MONITOR_ACTIONS[0])) {
                JOptionPane pane = new JOptionPane("Monitoring period [ms]", -1, 2, null);
                pane.setWantsInput(true);
                JDialog dialog = pane.createDialog(this.table, "Enter monitoring period");
                dialog.show();
                Object monitoringPeriod = pane.getInputValue();
                if (monitoringPeriod != JOptionPane.UNINITIALIZED_VALUE) {
                    Integer newFrequency = null;
                    String attributeName = null;
                    try {
                        attributeName = this.table.getValueAt(MonitorCellEditor.this.row, 0).toString();
                        newFrequency = Integer.valueOf(monitoringPeriod.toString());
                    }
                    catch (Exception e) {
                        this.showFrequencyErrorMessage();
                        MonitorCellEditor.this.fireEditingCanceled();
                        return;
                    }
                    AttributesTableModel model = (AttributesTableModel)this.table.getModel();
                    AttributeDescriptor attribute = model.getAttributeDescriptor(MonitorCellEditor.this.row);
                    if (!attribute.hasMonitor()) {
                        AttributesTable aTable = (AttributesTable)this.table;
                        AttributeMonitoringThread monitor = new AttributeMonitoringThread(newFrequency, aTable.getAttributeObject(), attributeName, this.table, MonitorCellEditor.this.row);
                        attribute.setMonitor(monitor);
                        monitor.start();
                        MonitorCellEditor.this.fireEditingStopped();
                        return;
                    }
                    System.err.println("monitor already added for this attribute");
                    MonitorCellEditor.this.fireEditingCanceled();
                    return;
                }
            } else if (state.equals(AttributesTableModel.MONITOR_ACTIONS[1])) {
                AttributesTableModel model = (AttributesTableModel)this.table.getModel();
                AttributeDescriptor attribute = model.getAttributeDescriptor(MonitorCellEditor.this.row);
                AttributeMonitoringThread monitor = (AttributeMonitoringThread)attribute.getMonitor();
                if (monitor != null) {
                    monitor.running = false;
                    attribute.setMonitor(null);
                    MonitorCellEditor.this.fireEditingStopped();
                    return;
                }
                MonitorCellEditor.this.fireEditingCanceled();
                return;
            }
            MonitorCellEditor.this.fireEditingCanceled();
        }

        private void showFrequencyErrorMessage() {
            JOptionPane.showMessageDialog(this.table, "Monitoring period must be an INTEGER", "Wrong monitoring period", 0);
        }
    }
}

