/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.explorer.rmi;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.objectweb.fractal.rmi.registry.NamingService;
import org.objectweb.fractal.rmi.registry.Registry;
import org.objectweb.util.explorer.api.MenuItem;
import org.objectweb.util.explorer.api.MenuItemTreeView;
import org.objectweb.util.explorer.api.TreeView;
import org.objectweb.util.explorer.core.common.api.ContextContainer;
import org.objectweb.util.explorer.swing.gui.api.DialogAction;
import org.objectweb.util.explorer.swing.gui.api.DialogBox;
import org.objectweb.util.explorer.swing.gui.api.ElementBox;
import org.objectweb.util.explorer.swing.gui.lib.DefaultDialogBox;
import org.objectweb.util.explorer.swing.gui.lib.LabelBox;

public class ConnectToRegistryAction
implements MenuItem,
DialogAction {
    protected LabelBox host_;
    protected LabelBox port_;
    protected ContextContainer cc_;

    protected void createBox(DialogBox dialogBox) {
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.host_ = new LabelBox("Host name", hostName != null ? hostName : "");
        dialogBox.addElementBox((ElementBox)this.host_);
        this.port_ = new LabelBox("Port", "1234");
        dialogBox.addElementBox((ElementBox)this.port_);
    }

    public int getStatus(TreeView treeView) {
        return 1;
    }

    public void actionPerformed(MenuItemTreeView menuItemTreeView) throws Exception {
        this.cc_ = (ContextContainer)menuItemTreeView.getSelectedObject();
        DefaultDialogBox dialog = new DefaultDialogBox("Connect to a registry");
        this.createBox((DialogBox)dialog);
        dialog.setValidateAction((DialogAction)this);
        dialog.show();
    }

    public void executeAction() throws Exception {
        String hostName = this.host_.getLabel();
        int port = Integer.parseInt(this.port_.getLabel());
        String name = "Registry " + hostName + ":" + port;
        NamingService ns = Registry.getRegistry((String)hostName, (int)port);
        try {
            ns.list();
            this.cc_.addEntry((Object)name, (Object)ns);
        }
        catch (Exception e) {
            throw new Exception("This NamingService is not available!");
        }
    }
}

