/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.plugin.java.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.objectweb.util.explorer.api.Context;
import org.objectweb.util.explorer.api.Entry;
import org.objectweb.util.explorer.core.common.lib.ClassesInheritance;
import org.objectweb.util.explorer.core.naming.lib.DefaultEntry;
import org.objectweb.util.explorer.plugin.java.reflect.ClassVisibility;
import org.objectweb.util.explorer.plugin.java.reflect.ClassVisibilityConfig;
import org.objectweb.util.explorer.plugin.java.reflect.MemberComparator;
import org.objectweb.util.explorer.plugin.java.reflect.TreeInheritance;

public class ClassContext
implements Context {
    protected MemberComparator comparator_ = new MemberComparator();

    protected void addFields(Field[] fields, List entryList, ClassVisibilityConfig config) {
        Arrays.sort(fields, this.comparator_);
        boolean displayType = config.get("attribute.type");
        boolean displayDeclaringClass = config.get("attribute.declaring-class") && config.get("flat-view");
        for (int i = 0; i < fields.length; ++i) {
            if (!ClassVisibility.hasToBeAdded(fields[i].getModifiers(), config, "attribute")) continue;
            StringBuffer name = new StringBuffer(fields[i].getName());
            if (displayType) {
                name.append(": " + ClassVisibility.getTypeName(fields[i].getType()));
            }
            if (displayDeclaringClass) {
                name.append(" (from " + ClassVisibility.getTypeName(fields[i].getDeclaringClass()) + ")");
            }
            entryList.add(new DefaultEntry((Object)name.toString(), (Object)fields[i]));
        }
    }

    protected void addMethods(Method[] methods, List entryList, ClassVisibilityConfig config) {
        Arrays.sort(methods, this.comparator_);
        boolean displayParams = config.get("method.params");
        boolean displayReturnType = config.get("method.return-type");
        boolean displayDeclaringClass = config.get("method.declaring-class") && config.get("flat-view");
        for (int i = 0; i < methods.length; ++i) {
            if (!ClassVisibility.hasToBeAdded(methods[i].getModifiers(), config, "method")) continue;
            StringBuffer name = new StringBuffer(methods[i].getName() + "(");
            if (displayParams) {
                Class<?>[] params = methods[i].getParameterTypes();
                for (int j = 0; j < params.length; ++j) {
                    name.append(ClassVisibility.getTypeName(params[j]));
                    if (j >= params.length - 1) continue;
                    name.append(", ");
                }
            }
            name.append(")");
            if (displayReturnType) {
                name.append(": " + ClassVisibility.getTypeName(methods[i].getReturnType()));
            }
            if (displayDeclaringClass) {
                name.append(" (from " + ClassVisibility.getTypeName(methods[i].getDeclaringClass()) + ")");
            }
            entryList.add(new DefaultEntry((Object)name.toString(), (Object)methods[i]));
        }
    }

    protected void addInnerClass(Class[] classes, List entryList, ClassVisibilityConfig config) {
        Arrays.sort(classes, this.comparator_);
        boolean displayDeclaringClass = config.get("inner_class.declaring-class") && config.get("flat-view");
        for (int i = 0; i < classes.length; ++i) {
            if (!ClassVisibility.hasToBeAdded(classes[i].getModifiers(), config, "inner_class")) continue;
            StringBuffer name = new StringBuffer(classes[i].getName().substring(classes[i].getName().lastIndexOf(36) + 1));
            if (displayDeclaringClass) {
                name.append(" (from " + ClassVisibility.getTypeName(classes[i].getDeclaringClass()) + ")");
            }
            entryList.add(new DefaultEntry((Object)name.toString(), (Object)classes[i]));
        }
    }

    public Entry[] getEntries(Object object) {
        Class theClass = (Class)object;
        ClassVisibilityConfig config = (ClassVisibilityConfig)ClassVisibility.config_.get(theClass.getName());
        if (config == null) {
            config = (ClassVisibilityConfig)ClassVisibility.config_.get("_default_config_");
        }
        Vector<DefaultEntry> entryList = new Vector<DefaultEntry>();
        if (config.get("tree-inheritance")) {
            if (!config.get("flat-view")) {
                entryList.add(new DefaultEntry((Object)"Tree inheritance", (Object)new TreeInheritance(theClass)));
                this.addFields(theClass.getDeclaredFields(), entryList, config);
                this.addMethods(theClass.getDeclaredMethods(), entryList, config);
                this.addInnerClass(theClass.getDeclaredClasses(), entryList, config);
            } else {
                ClassesInheritance classesInheritance = new ClassesInheritance(theClass);
                List classesList = classesInheritance.getInheritClasses();
                Vector<Field> fields = new Vector<Field>();
                Vector<Method> methods = new Vector<Method>();
                Vector innerClasses = new Vector();
                Iterator it = classesList.iterator();
                while (it.hasNext()) {
                    Class element = (Class)it.next();
                    if (element.isInterface()) continue;
                    fields.addAll(Arrays.asList(element.getDeclaredFields()));
                    methods.addAll(Arrays.asList(element.getDeclaredMethods()));
                    innerClasses.addAll(Arrays.asList(element.getDeclaredClasses()));
                }
                this.addFields(fields.toArray(new Field[0]), entryList, config);
                this.addMethods(methods.toArray(new Method[0]), entryList, config);
                this.addInnerClass(innerClasses.toArray(new Class[0]), entryList, config);
            }
        } else {
            this.addFields(theClass.getDeclaredFields(), entryList, config);
            this.addMethods(theClass.getDeclaredMethods(), entryList, config);
            this.addInnerClass(theClass.getDeclaredClasses(), entryList, config);
        }
        return entryList.toArray(new Entry[0]);
    }
}

