/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.plugin.java.reflect;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.util.explorer.plugin.java.reflect.ClassVisibilityConfig;

public class ClassVisibility {
    public static Map config_ = ClassVisibility.initMap();
    public static final String DEFAULT_CONFIG = "_default_config_";

    public static boolean hasToBeAdded(int modifier, ClassVisibilityConfig config, String type) {
        boolean addElement = false;
        if (Modifier.isPrivate(modifier) && config.get(type + "." + "private") || Modifier.isProtected(modifier) && config.get(type + "." + "protected") || Modifier.isPublic(modifier) && config.get(type + "." + "public") || !Modifier.isPrivate(modifier) && !Modifier.isProtected(modifier) && !Modifier.isPublic(modifier) && config.get(type + "." + "package")) {
            if (Modifier.isStatic(modifier) && Modifier.isFinal(modifier) && config.get(type + "." + "static") && config.get(type + "." + "final")) {
                addElement = true;
            } else if (Modifier.isStatic(modifier) && !Modifier.isFinal(modifier) && config.get(type + "." + "static")) {
                addElement = true;
            } else if (Modifier.isFinal(modifier) && !Modifier.isStatic(modifier) && config.get(type + "." + "final")) {
                addElement = true;
            } else if (Modifier.isAbstract(modifier) && config.get(type + "." + "abstract")) {
                addElement = true;
            } else if (!(Modifier.isStatic(modifier) || Modifier.isFinal(modifier) || Modifier.isAbstract(modifier))) {
                addElement = true;
            }
        }
        return addElement;
    }

    public static String getTypeName(Class theClass) {
        if (theClass != null) {
            StringBuffer name = new StringBuffer();
            int dimension = 0;
            if (theClass.isArray()) {
                while (theClass.isArray()) {
                    ++dimension;
                    theClass = theClass.getComponentType();
                }
            }
            if (theClass.isPrimitive()) {
                name.append(theClass.getName());
            } else if (theClass.getName().lastIndexOf(46) != -1) {
                name.append(theClass.getName().substring(theClass.getName().lastIndexOf(46) + 1));
            } else {
                name.append(theClass.getName());
            }
            for (int i = 0; i < dimension; ++i) {
                name.append("[]");
            }
            return name.toString();
        }
        return "";
    }

    public static Map initMap() {
        config_ = new HashMap();
        config_.put(DEFAULT_CONFIG, ClassVisibility.createNewDefaultConfig());
        return config_;
    }

    public static ClassVisibilityConfig createNewDefaultConfig() {
        ClassVisibilityConfig defaultConfig = new ClassVisibilityConfig();
        defaultConfig.put("attribute.public", true);
        defaultConfig.put("attribute.static", true);
        defaultConfig.put("attribute.final", true);
        defaultConfig.put("attribute.type", true);
        defaultConfig.put("attribute.declaring-class", true);
        defaultConfig.put("method.public", true);
        defaultConfig.put("method.static", true);
        defaultConfig.put("method.abstract", true);
        defaultConfig.put("method.params", true);
        defaultConfig.put("method.return-type", true);
        defaultConfig.put("method.declaring-class", true);
        defaultConfig.put("inner_class.public", true);
        defaultConfig.put("inner_class.static", true);
        defaultConfig.put("inner_class.final", true);
        defaultConfig.put("inner_class.declaring-class", true);
        return defaultConfig;
    }
}

