/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.components.bpel.runnable;

import de.schlichtherle.io.FileInputStream;
import de.schlichtherle.io.FileOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import javax.wsdl.Definition;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.objectweb.fdf.components.util.api.Formatter;
import org.objectweb.fdf.components.wsdl.WSDLHelper;
import org.objectweb.fdf.util.logging.AbstractLogging;
import org.w3c.dom.Document;

public class WSDLPatcher
extends AbstractLogging
implements Runnable {
    protected String host;
    protected String port;
    protected String archive;
    protected String name;
    protected Formatter formatter;
    protected String wsdl;

    public void run() {
        this.host = this.formatter.format(this.host);
        this.port = this.formatter.format(this.port);
        this.archive = this.formatter.format(this.archive);
        this.name = this.formatter.format(this.name);
        String archiveFileName = this.archive.substring(this.archive.lastIndexOf(de.schlichtherle.io.File.separator) + 1);
        try {
            String tmpdir = System.getProperty("java.io.tmpdir");
            de.schlichtherle.io.File source = new de.schlichtherle.io.File(this.archive);
            de.schlichtherle.io.File destination = new de.schlichtherle.io.File(tmpdir + de.schlichtherle.io.File.separator + archiveFileName);
            destination.archiveCopyAllFrom((File)source);
            this.wsdl = destination + "/" + this.name + "/" + this.name + ".wsdl";
            FileInputStream fis = new FileInputStream(this.wsdl);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse((InputStream)fis);
            fis.close();
            WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
            WSDLWriter writer = WSDLFactory.newInstance().newWSDLWriter();
            Definition def = reader.readWSDL(null, doc);
            SOAPAddress address = WSDLHelper.getPortAddress(WSDLHelper.getFirstPort(def));
            String addressLocation = address.getLocationURI();
            addressLocation = this.formatter.format(addressLocation);
            address.setLocationURI(addressLocation);
            FileOutputStream out = new FileOutputStream(this.wsdl);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            writer.writeWSDL(def, (OutputStream)bout);
            out.write(bout.toByteArray());
            bout.close();
            out.close();
            de.schlichtherle.io.File.update((de.schlichtherle.io.File)destination);
            this.logger.print(this.archive + " patched!");
        }
        catch (Exception ex) {
            this.logger.print("Unable to patch " + this.wsdl + " : " + ex.getClass().getName() + "\n\t" + ex.getMessage());
        }
    }

    protected String getWhoIAm() {
        return "WSDLPatcher(" + this.archive + ")";
    }
}

