/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.components.deployment.explorer;

import java.awt.Component;
import java.awt.Graphics;
import java.util.HashMap;
import javax.swing.Icon;
import org.objectweb.fdf.components.deployment.api.Deployment;
import org.objectweb.fdf.components.deployment.explorer.StatusIconProvider;
import org.objectweb.fdf.components.deployment.explorer.StringIcon;

public class StatusIcon
implements Icon {
    protected static HashMap icons;
    protected Deployment deployment;

    protected Icon getIcon() {
        Deployment.Status status = this.deployment.getStatus();
        Icon statusIcon = (Icon)icons.get(status);
        if (statusIcon == null) {
            statusIcon = (Icon)icons.get(Deployment.Status.UNKNOWN);
        }
        return statusIcon;
    }

    public StatusIcon(Deployment deployment) {
        this.deployment = deployment;
    }

    public int getIconHeight() {
        return this.getIcon().getIconHeight();
    }

    public int getIconWidth() {
        return this.getIcon().getIconWidth();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.getIcon().paintIcon(c, g, x, y);
    }

    static {
        String basePath = "resources/icons/org-objectweb-fdf-components-deployment-api-Deployment-Status-";
        icons = new HashMap();
        icons.put(Deployment.Status.UNKNOWN, new StringIcon("?"));
        icons.put(Deployment.Status.UNINSTALLING, StatusIconProvider.newImageIcon(basePath + "UNINSTALLING.png"));
        icons.put(Deployment.Status.UNINSTALLED, new StringIcon("U"));
        icons.put(Deployment.Status.INSTALLING, StatusIconProvider.newImageIcon(basePath + "INSTALLING.png"));
        icons.put(Deployment.Status.INSTALLED, new StringIcon("I"));
        icons.put(Deployment.Status.STARTING, StatusIconProvider.newImageIcon(basePath + "STARTING.png"));
        icons.put(Deployment.Status.STARTED, new StringIcon("S"));
        icons.put(Deployment.Status.STOPPING, StatusIconProvider.newImageIcon(basePath + "STOPPING.png"));
    }
}

