/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.components.deployment.explorer;

import java.util.HashSet;
import java.util.Set;
import org.objectweb.fdf.components.deployment.api.Deployment;
import org.objectweb.fdf.components.deployment.runnable.AbstractRunner;
import org.objectweb.fdf.explorer.ExplorerGUI;
import org.objectweb.fdf.explorer.RefreshGuiThread;
import org.objectweb.fdf.explorer.RefreshTree;
import org.objectweb.fdf.util.fractal.FractalHelper;
import org.objectweb.util.explorer.api.Tree;

public class ThreadRunner
extends RefreshGuiThread {
    protected static Set allRunningDeployments = new HashSet();
    private static RefreshTree rt;
    protected String message;

    public ThreadRunner(AbstractRunner runner, String action, Tree tree) {
        super((Runnable)runner, tree);
        Deployment deployment = runner.getDeployment();
        this.message = action + ' ' + FractalHelper.getComponentName(deployment);
        allRunningDeployments.add(deployment);
    }

    public void run() {
        if (rt == null) {
            rt = new RefreshTree(this.tree);
            rt.start();
        }
        ExplorerGUI.traceMessage(this.message + " ...");
        rt.increment();
        super.run();
        rt.decrement();
        ExplorerGUI.traceMessage(this.message + " done.");
    }

    public static void cleanUp() {
        int nb = allRunningDeployments.size();
        Deployment[] deployments = allRunningDeployments.toArray(new Deployment[nb]);
        for (int i = 0; i < nb; ++i) {
            Deployment deployment = deployments[i];
            String componentName = FractalHelper.getComponentName(deployment);
            if (deployment.getStatus() != Deployment.Status.UNINSTALLED) {
                ExplorerGUI.traceMessage("uninstall " + componentName + " ...");
                deployment.uninstall();
                ExplorerGUI.traceMessage("uninstall " + componentName + " done.");
            }
            if (deployment.getStatus() == Deployment.Status.UNINSTALLED) continue;
            ExplorerGUI.traceMessage("stop " + componentName + " ...");
            deployment.stop();
            ExplorerGUI.traceMessage("stop " + componentName + " done.");
        }
    }
}

