/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.components.deployment.lib.automaton;

import org.objectweb.fdf.components.deployment.api.Deployment;
import org.objectweb.fdf.components.deployment.lib.common.BasicDeployment;

public class BasicAutomaton
extends BasicDeployment {
    protected Deployment deployment;
    protected int counter_installed = 0;
    protected int counter_started = 0;

    protected void logAlreadyDone(String action) {
        this.info("already " + action + '!');
    }

    protected void logNotDone(String action) {
        this.info("not " + action + '!');
    }

    protected void logInvalidStatus(String action) {
        this.error(new Error("invalid status for " + action + '!'));
    }

    protected void logInvalidAction(String action) {
        this.error(new Error("can't " + action + '!'));
    }

    protected BasicAutomaton() {
    }

    protected BasicAutomaton(Deployment.Status status) {
        super(status);
    }

    protected String getWhoIAm() {
        return super.getWhoIAm() + "(ci=" + this.counter_installed + ",cs=" + this.counter_started + ')';
    }

    public synchronized void install() {
        if (this.getStatus() == Deployment.Status.STARTED) {
            ++this.counter_installed;
            this.logAlreadyDone("installed");
            return;
        }
        if (this.getStatus() == Deployment.Status.INSTALLED) {
            this.logAlreadyDone("installed");
            ++this.counter_installed;
            return;
        }
        if (this.getStatus() == Deployment.Status.UNINSTALLED) {
            super.installing();
            this.deployment.install();
            ++this.counter_installed;
            super.install();
        } else {
            this.logInvalidStatus("install");
        }
    }

    public synchronized void start() {
        if (this.getStatus() == Deployment.Status.STARTED) {
            ++this.counter_started;
            this.logAlreadyDone("started");
            return;
        }
        if (this.getStatus() == Deployment.Status.UNINSTALLED) {
            this.install();
        }
        if (this.getStatus() == Deployment.Status.INSTALLED) {
            super.starting();
            this.deployment.start();
            ++this.counter_started;
            super.start();
        } else {
            this.logInvalidStatus("start");
        }
    }

    public synchronized void stop() {
        if (this.getStatus() == Deployment.Status.INSTALLED) {
            this.logAlreadyDone("stopped");
            return;
        }
        if (this.getStatus() == Deployment.Status.STARTED) {
            --this.counter_started;
            if (this.counter_started == 0) {
                super.stopping();
                this.deployment.stop();
                super.stop();
            } else {
                this.logNotDone("stop");
            }
        } else {
            this.logInvalidStatus("stop");
        }
    }

    public synchronized void uninstall() {
        if (this.getStatus() == Deployment.Status.UNINSTALLED) {
            this.logAlreadyDone("uninstalled");
            return;
        }
        if (this.getStatus() == Deployment.Status.STARTED) {
            if (this.counter_installed > 1) {
                --this.counter_installed;
                this.logNotDone("uninstall");
                return;
            }
            this.stop();
        }
        if (this.getStatus() == Deployment.Status.INSTALLED) {
            --this.counter_installed;
            if (this.counter_installed == 0) {
                if (this.counter_started != 0) {
                    this.warning("uninstall() when the started counter != 0 !!!");
                }
                super.uninstalling();
                this.deployment.uninstall();
                super.uninstall();
            } else {
                this.logNotDone("uninstall");
            }
        } else {
            this.logInvalidStatus("uninstall");
        }
    }
}

