/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.components.deployment.lib.collection;

import java.util.LinkedHashMap;
import java.util.Map;
import org.objectweb.fdf.components.deployment.api.Deployment;
import org.objectweb.fdf.components.deployment.lib.common.BasicDeployment;
import org.objectweb.fdf.components.deployment.runnable.InstallRunner;
import org.objectweb.fdf.components.deployment.runnable.StartRunner;
import org.objectweb.fdf.components.deployment.runnable.StopRunner;
import org.objectweb.fdf.components.deployment.runnable.UninstallRunner;
import org.objectweb.fdf.util.runnable.api.RunnableHandler;
import org.objectweb.fdf.util.runnable.api.RunnableManager;

public class DeploymentCollectionManager
extends BasicDeployment {
    protected Map deployments = new LinkedHashMap();
    protected RunnableManager runnableManager;

    protected Deployment[] getDeployments() {
        return this.deployments.values().toArray(new Deployment[this.deployments.size()]);
    }

    protected void waitForAllHandlers(RunnableHandler[] handlers) {
        for (int i = 0; i < handlers.length; ++i) {
            handlers[i].waitFor();
        }
    }

    protected DeploymentCollectionManager() {
        super(Deployment.Status.UNINSTALLED);
    }

    public void install() {
        super.installing();
        Deployment[] deployments = this.getDeployments();
        RunnableHandler[] handlers = new RunnableHandler[deployments.length];
        for (int i = 0; i < deployments.length; ++i) {
            handlers[i] = this.runnableManager.submit(new InstallRunner(deployments[i]));
        }
        this.waitForAllHandlers(handlers);
        super.install();
    }

    public void start() {
        super.starting();
        Deployment[] deployments = this.getDeployments();
        RunnableHandler[] handlers = new RunnableHandler[deployments.length];
        for (int i = 0; i < deployments.length; ++i) {
            handlers[i] = this.runnableManager.submit(new StartRunner(deployments[i]));
        }
        this.waitForAllHandlers(handlers);
        super.start();
    }

    public void stop() {
        super.stopping();
        Deployment[] deployments = this.getDeployments();
        RunnableHandler[] handlers = new RunnableHandler[deployments.length];
        for (int i = 0; i < deployments.length; ++i) {
            handlers[i] = this.runnableManager.submit(new StopRunner(deployments[i]));
        }
        this.waitForAllHandlers(handlers);
        super.stop();
    }

    public void uninstall() {
        super.uninstalling();
        Deployment[] deployments = this.getDeployments();
        RunnableHandler[] handlers = new RunnableHandler[deployments.length];
        for (int i = 0; i < deployments.length; ++i) {
            handlers[i] = this.runnableManager.submit(new UninstallRunner(deployments[i]));
        }
        this.waitForAllHandlers(handlers);
        super.uninstall();
    }
}

