/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.components.fdf.lib.runnable;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.objectweb.fdf.components.deployment.api.Deployment;
import org.objectweb.fdf.components.fdf.lib.runnable.Benchmark;
import org.objectweb.fdf.components.fdf.lib.runnable.Registry;
import org.objectweb.fdf.parser.common.FDFClassLoader;
import org.objectweb.fdf.util.io.FilenameHelper;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.Factory;
import org.objectweb.fractal.adl.FactoryFactory;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.NameController;
import org.objectweb.fractal.rmi.registry.NamingService;
import org.objectweb.fractal.util.Fractal;

public class Launcher
extends Benchmark
implements Runnable {
    protected String configuration;
    protected String procedure;
    protected String software;
    protected String uid;
    protected String host;
    protected String port;
    protected String virtual_nodes;
    protected static boolean ALREADY_LOADED = false;

    public void run() {
        try {
            URL url;
            this.begin_loading = this.getTime();
            File definitionFile = new File(this.configuration);
            FDFClassLoader fdfCl = new FDFClassLoader(Thread.currentThread().getContextClassLoader());
            String definitionName = FilenameHelper.getDefinitionName(definitionFile, fdfCl);
            String filename = definitionFile.getAbsolutePath();
            String tmpDefinitionName = definitionName.replace('.', File.separatorChar);
            if (!filename.substring(0, filename.lastIndexOf(46)).endsWith(tmpDefinitionName)) {
                throw new Error("Wrong definition name ('" + filename.substring(1, filename.lastIndexOf(46)) + "' expected, instead of '" + definitionName + "'): " + filename);
            }
            try {
                String tmp = definitionName.replace('.', File.separatorChar) + ".fractal";
                if (filename.lastIndexOf(tmp) < 0 && filename.lastIndexOf(tmp = definitionName.replace('.', File.separatorChar) + '.' + fdfCl.getExtension()) < 0) {
                    System.err.println("Can't load: the chosen file is not of extension .fractal or ." + fdfCl.getExtension());
                    return;
                }
                String filepath = filename.substring(0, filename.lastIndexOf(tmp));
                url = new URL("file:" + filepath);
            }
            catch (IOException exc) {
                System.err.println("Can't load: " + exc.toString());
                return;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            FDFClassLoader classLoader = new FDFClassLoader(new URL[]{url}, Thread.currentThread().getContextClassLoader());
            context.put("classloader", classLoader);
            context.put("local-tmp-dir", System.getProperties().get("java.io.tmpdir"));
            Component c = null;
            Registry registry = new Registry();
            Factory f = FactoryFactory.getFactory((String)"org.objectweb.fractal.adl.FractalBackend");
            String name = "FDF.LOAD-CONFIG(" + definitionName + ")";
            if (this.host.equals("")) {
                c = (Component)f.newComponent(name, context);
            } else {
                NamingService ns = registry.getRegistry(this.host, this.port);
                if (!this.virtual_nodes.equals("")) {
                    String[] servers_list = this.virtual_nodes.split(" ");
                    for (int i = 0; i < servers_list.length; ++i) {
                        context.put(servers_list[i], ns.lookup(servers_list[i]));
                    }
                } else {
                    System.err.println(" PROCEEDING LOCAL FDF DEPLOYMENT...");
                }
                c = registry.getRegistry(this.host, this.port).lookup(this.uid);
                if (c == null) {
                    c = (Component)f.newComponent(name, context);
                    Component[] subComponents = Fractal.getContentController((Component)c).getFcSubComponents();
                    registry.bind(this.uid, subComponents[1]);
                }
            }
            this.end_loading = this.getTime();
            String softwarePath = definitionName + "/" + this.software;
            Component software = this.getSubComponent(c, softwarePath);
            Deployment deployment = (Deployment)software.getFcInterface("deployment");
            System.err.println("  => Executing  " + this.procedure.toUpperCase());
            if (this.procedure.equalsIgnoreCase("install")) {
                deployment.install();
            } else if (this.procedure.equalsIgnoreCase("start")) {
                deployment.start();
            } else if (this.procedure.equalsIgnoreCase("stop")) {
                deployment.stop();
            } else if (this.procedure.equalsIgnoreCase("uninstall")) {
                deployment.uninstall();
            }
            this.end_execution = this.getTime();
            this.printResults();
        }
        catch (ADLException e) {
            e.printStackTrace();
        }
        catch (NoSuchInterfaceException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Component getSubComponent(Component c, String path) throws NoSuchInterfaceException {
        String[] cut = path.split("/");
        Component current = c;
        Component res = null;
        for (String componentName : cut) {
            ContentController cc = (ContentController)current.getFcInterface("content-controller");
            Component[] comps = cc.getFcSubComponents();
            res = null;
            boolean found = false;
            for (Component comp : comps) {
                NameController nc = (NameController)comp.getFcInterface("name-controller");
                String compName = nc.getFcName();
                if (!compName.equals(componentName)) continue;
                found = true;
                res = comp;
                current = comp;
                break;
            }
            if (found) continue;
            throw new Error("No such component: " + componentName);
        }
        return res;
    }
}

