/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.components.file.lib;

import de.schlichtherle.io.File;
import de.schlichtherle.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.objectweb.fdf.components.util.api.Formatter;
import org.objectweb.fdf.components.util.lib.AbstractParameter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ReadXMLInArchive
extends AbstractParameter {
    private String result = null;
    protected String archive;
    protected String xml;
    protected String xPathQuery;
    protected Formatter formatter;

    public String getValue() {
        try {
            if (this.result != null) {
                return this.result;
            }
            this.archive = this.formatter.format(this.archive);
            this.xml = this.formatter.format(this.xml);
            this.xPathQuery = this.formatter.format(this.xPathQuery);
            FileInputStream fis = new FileInputStream(this.archive + File.separator + this.xml);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse((InputStream)fis);
            doc.getDocumentElement().normalize();
            this.result = XPathAPI.eval((Node)doc, (String)this.xPathQuery).toString();
            return this.result;
        }
        catch (FileNotFoundException e) {
            System.out.println("Can't read descriptor: " + this.archive + File.separator + this.xml);
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            System.out.println("Parse exception: " + e.getMessage());
            e.printStackTrace();
        }
        catch (SAXException e) {
            System.out.println("Can't parse document: " + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("IOException while getting name of " + this.archive + ": " + e.getMessage());
            e.printStackTrace();
        }
        catch (TransformerException e) {
            System.out.println("Can't evaluate XPath expression on document: " + e.getMessage());
            e.printStackTrace();
        }
        return "UNDEFINED";
    }
}

