/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.components.file.runnable;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.objectweb.fdf.components.util.api.Formatter;
import org.objectweb.fdf.util.logging.AbstractLogging;

public class CreateFile
extends AbstractLogging
implements Runnable {
    static final String CLASSPATH_URI_PREFIX = "classpath:";
    protected String templateFilename;
    protected String outputFilename;
    protected Formatter formatter;

    public void run() {
        InputStreamReader reader = null;
        this.templateFilename = this.formatter.format(this.templateFilename);
        this.outputFilename = this.formatter.format(this.outputFilename);
        if (this.templateFilename.startsWith(CLASSPATH_URI_PREFIX)) {
            reader = new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream(this.templateFilename.substring(CLASSPATH_URI_PREFIX.length())));
        } else {
            try {
                reader = new FileReader(new File(this.templateFilename));
            }
            catch (FileNotFoundException e) {
                this.error(new Error("Can't open file: " + this.templateFilename, e));
            }
        }
        BufferedReader bufferedReader = new BufferedReader(reader);
        File prop = new File(this.outputFilename);
        FileWriter writer = null;
        try {
            writer = new FileWriter(prop);
        }
        catch (IOException e) {
            this.error(new Error("Can't create file: " + this.outputFilename, e));
        }
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                writer.write(this.formatter.format(line) + '\n');
            }
        }
        catch (IOException e) {
            this.error(new Error("Can't write in file: " + this.outputFilename, e));
        }
        try {
            writer.close();
        }
        catch (IOException e) {
            this.error(new Error("Can't close file: " + this.outputFilename, e));
        }
        try {
            ((Reader)reader).close();
        }
        catch (IOException e) {
            this.error(new Error("Can't close file: " + this.templateFilename, e));
        }
    }

    protected String getWhoIAm() {
        return "CreateFile";
    }
}

