/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.components.internet.lib;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import org.objectweb.fdf.components.internet.lib.AbstractInternet;
import org.objectweb.fdf.components.internet.lib.JSchUserInfo;
import org.objectweb.fdf.util.logging.AbstractLogging;

public class JSchSoftware
extends AbstractLogging {
    private JSch jsch;
    private Session session;
    private Channel channel;

    protected void initJSch(AbstractInternet ai) {
        this.jsch = new JSch();
        try {
            if (new File(ai.user.getPrivateKey()).exists()) {
                this.jsch.addIdentity(ai.user.getPrivateKey());
            } else {
                this.warning("Private key file " + ai.user.getPrivateKey() + " not found, password will be used!");
            }
        }
        catch (JSchException e) {
            this.warning("Private key is not valid, password will be used!");
        }
    }

    protected void initSession(AbstractInternet ai) {
        try {
            this.session = this.jsch.getSession(ai.user.getLogin(), ai.hostname.getHostname(), ai.port.getPort());
        }
        catch (JSchException e) {
            throw new Error("initSession - Could not get session", e);
        }
        this.session.setUserInfo((UserInfo)new JSchUserInfo(ai));
        try {
            this.session.connect();
        }
        catch (JSchException e) {
            throw new Error("initSession - Could not connect to session", e);
        }
    }

    public void initChannel(String channelKind) {
        try {
            this.channel = this.session.openChannel(channelKind);
        }
        catch (JSchException e) {
            throw new Error("initChannel - Could not open channel", e);
        }
    }

    protected JSchSoftware() {
    }

    public JSchSoftware(AbstractInternet ai, String channelKind) {
        super(ai);
        this.initJSch(ai);
        this.initSession(ai);
        this.initChannel(channelKind);
    }

    protected String getWhoIAm() {
        return "JSchSoftware";
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void disconnect() {
        this.channel.disconnect();
        this.session.disconnect();
    }
}

