/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.components.java.rmi.lib;

import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import org.objectweb.fdf.components.util.api.Formatter;
import org.objectweb.fdf.util.logging.AbstractLogging;

public class RegistryWrapper
extends AbstractLogging
implements Registry {
    protected String hostname;
    protected Formatter formatter;
    private Registry registry;

    protected Registry getRegistry() throws RemoteException {
        if (this.registry == null) {
            String host = this.formatter.format(this.hostname);
            int port = 1099;
            this.registry = LocateRegistry.getRegistry(host, port);
        }
        return this.registry;
    }

    protected String getWhoIAm() {
        return "Java RMI Registry(host=" + this.hostname + ",port=1099)";
    }

    public Remote lookup(String name) throws RemoteException, NotBoundException, AccessException {
        return this.getRegistry().lookup(name);
    }

    public void bind(String name, Remote obj) throws RemoteException, AlreadyBoundException, AccessException {
        this.getRegistry().bind(name, obj);
    }

    public void unbind(String name) throws RemoteException, NotBoundException, AccessException {
        this.getRegistry().unbind(name);
    }

    public void rebind(String name, Remote obj) throws RemoteException, AccessException {
        this.getRegistry().rebind(name, obj);
    }

    public String[] list() throws RemoteException, AccessException {
        return this.getRegistry().list();
    }
}

