/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.components.petals.lib;

import java.net.MalformedURLException;
import java.net.URL;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import org.objectweb.fdf.components.deployment.api.Deployment;
import org.objectweb.fdf.components.petals.lib.AbstractJBIComponent;
import org.objectweb.fdf.components.petals.util.JBIJMXConnectorUtil;

public class JBIComponent
extends AbstractJBIComponent
implements Deployment {
    private ObjectName beanNameInstaller;
    private ObjectName beanNameEngine;

    public Deployment.Status getStatus() {
        return this.status;
    }

    public void install() {
        this.formatAttributes();
        try {
            new URL(this.file);
        }
        catch (MalformedURLException e) {
            this.error(new Error("JBIComponent.install() - invalid file URI", e));
        }
        Object[] objects = new Object[]{this.file};
        String[] strings = new String[]{"java.lang.String"};
        JMXConnector connector = this.getJMXConnector();
        MBeanServerConnection connection = this.getMBeanServerConnection(connector);
        try {
            this.beanNameInstaller = (ObjectName)this.invoke(connection, JBIJMXConnectorUtil.getInstallationServiceMBeanName(connection), "loadNewInstaller", objects, strings);
        }
        catch (Exception e) {
            this.error(new Error("JBIComponent.install() - unable to get InstallationServiceMBean", e));
        }
        this.beanNameEngine = (ObjectName)this.invoke(connection, this.beanNameInstaller, "install", new Object[0], new String[0]);
        this.closeConnector(connector);
        this.status = Deployment.Status.INSTALLED;
    }

    public void start() {
        Object[] objects = new Object[]{};
        String[] strings = new String[]{};
        JMXConnector connector = this.getJMXConnector();
        MBeanServerConnection connection = this.getMBeanServerConnection(connector);
        ObjectName bean = null;
        try {
            bean = JBIJMXConnectorUtil.getComponentMBeanName(connection, this.beanNameEngine.getKeyProperty("name"));
        }
        catch (Exception e) {
            this.error(new Error("JBIComponent.start() - unable to recover JBI component", e));
        }
        this.invoke(connection, bean, "start", objects, strings);
        this.closeConnector(connector);
        this.status = Deployment.Status.STARTED;
    }

    public void stop() {
        Object[] objects = new Object[]{};
        String[] strings = new String[]{};
        JMXConnector connector = this.getJMXConnector();
        MBeanServerConnection connection = this.getMBeanServerConnection(connector);
        ObjectName objectName = null;
        try {
            objectName = JBIJMXConnectorUtil.getComponentMBeanName(connection, this.beanNameEngine.getKeyProperty("name"));
        }
        catch (Exception e) {
            this.error(new Error("JBIComponent.stop() - unable to recover JBI component", e));
        }
        this.invoke(connection, objectName, "stop", objects, strings);
        this.closeConnector(connector);
        this.status = Deployment.Status.INSTALLED;
    }

    public void uninstall() {
        JMXConnector connector = this.getJMXConnector();
        MBeanServerConnection connection = this.getMBeanServerConnection(connector);
        this.invoke(connection, this.beanNameEngine, "shutDown", new Object[0], new String[0]);
        this.invoke(connection, this.beanNameInstaller, "uninstall", new Object[0], new String[0]);
        Object[] objects = new Object[]{this.beanNameInstaller.getKeyProperty("name"), new Boolean(true)};
        String[] strings = new String[]{"java.lang.String", "boolean"};
        try {
            this.invoke(connection, JBIJMXConnectorUtil.getInstallationServiceMBeanName(connection), "unloadInstaller", objects, strings);
        }
        catch (Exception e) {
            this.error(new Error("JBIComponent.uninstall() - unable to get InstallationServiceMBean", e));
        }
        this.closeConnector(connector);
        this.status = Deployment.Status.UNINSTALLED;
    }

    protected String getWhoIAm() {
        return "JBIComponent(" + this.file + ")";
    }
}

