/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.components.petals.lib;

import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import org.objectweb.fdf.components.deployment.api.Deployment;
import org.objectweb.fdf.components.petals.lib.AbstractJBIComponent;
import org.objectweb.fdf.components.petals.util.JBIJMXConnectorUtil;

public class ServiceAssembly
extends AbstractJBIComponent
implements Deployment {
    protected String name;

    protected void performAction(String id, String action) {
        try {
            JMXConnector connector = JBIJMXConnectorUtil.getConnection(this.host, this.port, this.userName, this.password);
            MBeanServerConnection connection = connector.getMBeanServerConnection();
            Object[] objects = new Object[]{id};
            String[] strings = new String[]{"java.lang.String"};
            connection.invoke(JBIJMXConnectorUtil.getDeploymentServiceMBeanName(connection), action, objects, strings);
            connector.close();
        }
        catch (Exception e) {
            this.error(new Error("ServiceAssembly: error during the " + action + " procedure of " + this.name));
        }
    }

    protected String getWhoIAm() {
        return "ServiceAssembly(" + this.file + ")";
    }

    public Deployment.Status getStatus() {
        return this.status;
    }

    public void install() {
        this.formatAttributes();
        this.name = this.formatter.format(this.name);
        this.performAction(this.file, "deploy");
        this.status = Deployment.Status.INSTALLED;
    }

    public void start() {
        this.performAction(this.name, "start");
        this.status = Deployment.Status.STARTED;
    }

    public void stop() {
        this.performAction(this.name, "stop");
        this.status = Deployment.Status.INSTALLED;
    }

    public void uninstall() {
        this.performAction(this.name, "shutDown");
        this.performAction(this.name, "undeploy");
        this.status = Deployment.Status.UNINSTALLED;
    }
}

