/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.components.petals.runnable;

import java.io.FileWriter;
import java.io.IOException;
import org.objectweb.fdf.components.internet.api.Hostname;
import org.objectweb.fdf.components.util.api.Parameter;
import org.objectweb.fdf.util.fractal.FractalHelper;
import org.objectweb.fractal.api.Component;

public class ConfigureDomain
implements Runnable {
    public static final String CONTAINER_NAME_PROPERTY_NAME = "container-name";
    public static final String PETALS_PORT_PROPERTY_NAME = "petals-port";
    public static final String RMI_PORT_PROPERTY_NAME = "rmi-port";
    public static final String JMX_USER_PROPERTY_NAME = "jmx-user";
    public static final String JMX_PASSWORD_PROPERTY_NAME = "jmx-password";
    public static final String JMX_PORT_PROPERTY_NAME = "jmx-port";
    public static final String JORAM_DOMAINPORT_PROPERTY_NAME = "joram-domainport";
    public static final String JORAM_TCPPORT_PROPERTY_NAME = "joram-tcpport";
    public static final String DREAM_PORT_PROPERTY_NAME = "dream-port";
    private boolean generated = false;
    protected String filename;
    protected Component self;

    public synchronized void run() {
        if (!this.generated) {
            this.generateConfiguration();
            this.generated = true;
        }
    }

    private void generateConfiguration() {
        Component[] parents = FractalHelper.getSuperComponents(this.self);
        StringBuffer result = new StringBuffer();
        result.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        result.append("<tns:topology xmlns:tns=\"http://petals.ow2.org/topology\"\n");
        result.append("        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        result.append("        xsi:schemaLocation=\"http://petals.ow2.org/topology petalsTopology.xsd\">\n");
        for (int i = 0; i < parents.length; ++i) {
            String componentName = FractalHelper.getComponentName(parents[i]);
            if (!componentName.startsWith("domain")) continue;
            result.append(this.getDomainConfiguration(parents[i]));
        }
        result.append("</tns:topology>\n");
        try {
            FileWriter fw = new FileWriter(this.filename);
            fw.write(result.toString());
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getMulticastConfiguration(Component c) {
        String componentName = FractalHelper.getComponentName(c);
        if (!componentName.startsWith("multicast")) {
            return "";
        }
        String ip = ((Parameter)FractalHelper.getInterface(FractalHelper.getSubComponentByName(c, "multicast-ip"), "parameter")).getValue();
        String port = ((Parameter)FractalHelper.getInterface(FractalHelper.getSubComponentByName(c, "multicast-port"), "parameter")).getValue();
        StringBuffer result = new StringBuffer();
        result.append("    <tns:multicast>\n");
        result.append("      <tns:ip>" + ip + "</tns:ip>\n");
        result.append("      <tns:port>" + port + "</tns:port>\n");
        result.append("    </tns:multicast>\n");
        return result.toString();
    }

    private String getContainerConfiguration(Component c) {
        String componentName = FractalHelper.getComponentName(c);
        if (!componentName.startsWith("petals")) {
            return "";
        }
        String containerName = "UNDEFINED";
        String petalsPort = "UNDEFINED";
        String jmxUser = "UNDEFINED";
        String jmxPassword = "UNDEFINED";
        String jmxPort = "UNDEFINED";
        String rmiPort = "UNDEFINED";
        String joramDomainport = "UNDEFINED";
        String joramTcpport = "UNDEFINED";
        String dreamPort = "UNDEFINED";
        String host = ((Hostname)FractalHelper.getInterface(FractalHelper.getSubComponentByName(c, "host"), "hostname")).getHostname();
        FractalHelper.getInterface(FractalHelper.getSubComponentByName(c, "host"), "hostname");
        Component[] properties = FractalHelper.getSubComponents(FractalHelper.getSubComponentByName(c, "properties"));
        for (int i = 0; i < properties.length; ++i) {
            String propertyName = FractalHelper.getComponentName(properties[i]);
            String value = ((Parameter)FractalHelper.getInterface(properties[i], "parameter")).getValue();
            if (propertyName.equals(CONTAINER_NAME_PROPERTY_NAME)) {
                containerName = value;
            }
            if (propertyName.equals(PETALS_PORT_PROPERTY_NAME)) {
                petalsPort = value;
            }
            if (propertyName.equals(JMX_USER_PROPERTY_NAME)) {
                jmxUser = value;
            }
            if (propertyName.equals(RMI_PORT_PROPERTY_NAME)) {
                rmiPort = value;
            }
            if (propertyName.equals(JMX_PASSWORD_PROPERTY_NAME)) {
                jmxPassword = value;
            }
            if (propertyName.equals(JMX_PORT_PROPERTY_NAME)) {
                jmxPort = value;
            }
            if (propertyName.equals(JORAM_DOMAINPORT_PROPERTY_NAME)) {
                joramDomainport = value;
            }
            if (propertyName.equals(JORAM_TCPPORT_PROPERTY_NAME)) {
                joramTcpport = value;
            }
            if (!propertyName.equals(DREAM_PORT_PROPERTY_NAME)) continue;
            dreamPort = value;
        }
        StringBuffer result = new StringBuffer();
        result.append("      <tns:container name=\"" + containerName + "\">\n");
        result.append("        <tns:host>" + host + "</tns:host>\n");
        result.append("        <tns:configuration>\n");
        result.append("          <tns:user>" + jmxUser + "</tns:user>\n");
        result.append("          <tns:password>" + jmxPassword + "</tns:password>\n");
        result.append("          <tns:networkservice>\n");
        result.append("            <tns:port>" + petalsPort + "</tns:port>\n");
        result.append("          </tns:networkservice>\n");
        result.append("          <tns:jmxservice>\n");
        result.append("            <tns:rmiport>" + rmiPort + "</tns:rmiport>\n");
        result.append("            <tns:jndiport>" + jmxPort + "</tns:jndiport>\n");
        result.append("          </tns:jmxservice>\n");
        result.append("          <tns:joramservice>\n");
        result.append("            <tns:domainPort>" + joramDomainport + "</tns:domainPort>\n");
        result.append("            <tns:tcpPort>" + joramTcpport + "</tns:tcpPort>\n");
        result.append("          </tns:joramservice>\n");
        result.append("          <tns:dreamservice>\n");
        result.append("            <tns:port>" + dreamPort + "</tns:port>\n");
        result.append("          </tns:dreamservice>\n");
        result.append("        </tns:configuration>\n");
        result.append("      </tns:container>\n");
        return result.toString();
    }

    private String getSubDomainConfiguration(Component c) {
        String componentName = FractalHelper.getComponentName(c);
        if (!componentName.startsWith("sub-domain")) {
            return "";
        }
        String subDomainName = ((Parameter)FractalHelper.getInterface(FractalHelper.getSubComponentByName(c, "subdomain-name"), "parameter")).getValue();
        StringBuffer result = new StringBuffer();
        result.append("    <tns:sub-domain name=\"" + subDomainName + "\">\n");
        Component[] subComponents = FractalHelper.getSubComponents(c);
        for (int i = 0; i < subComponents.length; ++i) {
            result.append(this.getContainerConfiguration(subComponents[i]));
        }
        result.append("    </tns:sub-domain>\n");
        return result.toString();
    }

    private String getDomainConfiguration(Component c) {
        String domainName = ((Parameter)FractalHelper.getInterface(FractalHelper.getSubComponentByName(c, "domain-name"), "parameter")).getValue();
        String mode = ((Parameter)FractalHelper.getInterface(FractalHelper.getSubComponentByName(c, "mode"), "parameter")).getValue();
        StringBuffer result = new StringBuffer();
        result.append("  <tns:domain mode=\"" + mode + "\" name=\"" + domainName + "\">\n");
        Component multicastComponent = FractalHelper.getSubComponentByName(c, "multicast");
        result.append(this.getMulticastConfiguration(multicastComponent));
        Component[] subComponents = FractalHelper.getSubComponents(c);
        for (int i = 0; i < subComponents.length; ++i) {
            result.append(this.getSubDomainConfiguration(subComponents[i]));
        }
        result.append("  </tns:domain>\n");
        return result.toString();
    }
}

