/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.components.protocol.lib.common;

import org.objectweb.fdf.components.protocol.api.Protocol;
import org.objectweb.fdf.components.protocol.lib.common.AbstractProtocol;
import org.objectweb.fdf.util.printer.api.Printer;

public class DetectorProtocol
extends AbstractProtocol
implements Printer {
    protected Protocol protocol;
    protected Printer output;
    protected String echoCommand;
    protected String marker = "ABCDEFGHIJKLMNOPQ...";
    private int counter = 0;

    protected boolean isMarker(String line) {
        return line.equals(this.marker);
    }

    protected String getWhoIAm() {
        return "DetectorProtocol";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String command) {
        if (command != null) {
            this.info("send - " + command);
            this.protocol.send(command);
        }
        this.protocol.send(this.echoCommand + ' ' + this.marker);
        DetectorProtocol detectorProtocol = this;
        synchronized (detectorProtocol) {
            while (this.counter == 0) {
                try {
                    this.wait();
                }
                catch (Exception exc) {
                    throw new Error("", exc);
                }
            }
            --this.counter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object object) {
        if (object instanceof String && this.isMarker((String)object)) {
            DetectorProtocol detectorProtocol = this;
            synchronized (detectorProtocol) {
                ++this.counter;
                this.notify();
            }
        } else {
            this.output.print(object);
        }
    }
}

