/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.components.protocol.lib.telnet;

import java.io.InputStream;
import org.objectweb.fdf.util.printer.api.Printer;
import thor.net.DefaultTelnetTerminalHandler;
import thor.net.TelnetConstants;

class TelnetTerminalHandler
extends DefaultTelnetTerminalHandler
implements TelnetConstants,
Runnable {
    protected InputStream input;
    protected StringBuffer buffer;
    protected Printer output;

    public TelnetTerminalHandler(InputStream input, Printer output) {
        this.input = input;
        this.buffer = new StringBuffer();
        this.output = output;
    }

    public void LineFeed() {
        this.output.print(this.buffer.toString());
        this.buffer = new StringBuffer();
    }

    public void CarriageReturn() {
    }

    public void BackSpace() {
        this.buffer.append('\b');
    }

    public void HorizontalTab() {
        this.buffer.append('\t');
    }

    public void FormFeed() {
        this.buffer.append('\f');
    }

    public void ClearScreen() {
    }

    public void VerticalTab() {
        this.buffer.append('\u000b');
    }

    public void run() {
        try {
            while (true) {
                int ch;
                if ((ch = this.input.read()) < 0) {
                    return;
                }
                if (ch <= 1) continue;
                this.buffer.append((char)ch);
            }
        }
        catch (Exception e) {
            this.output.print(e);
            return;
        }
    }
}

