/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.components.tuscany.runnable;

import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.ArchiveException;
import de.schlichtherle.io.FileInputStream;
import de.schlichtherle.io.FileOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.objectweb.fdf.components.tuscany.api.Filter;
import org.objectweb.fdf.components.tuscany.lib.FileList;
import org.objectweb.fdf.components.util.api.Formatter;
import org.objectweb.fdf.components.util.api.Parameter;
import org.objectweb.fdf.util.logging.AbstractLogging;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLTransformer
extends AbstractLogging
implements Runnable {
    protected String archive = "";
    protected String pattern = "";
    protected Map filters = new HashMap();
    protected Formatter formatter;

    public void transform(String inputFile) {
        try {
            String tempXSL = inputFile + ".tmp";
            TransformerFactory tFactory = TransformerFactory.newInstance();
            if (tFactory.getFeature("http://javax.xml.transform.sax.SAXSource/feature") && tFactory.getFeature("http://javax.xml.transform.sax.SAXResult/feature")) {
                ArrayList<TransformerHandler> tList = new ArrayList<TransformerHandler>();
                FileOutputStream fileOut = new FileOutputStream(tempXSL);
                SAXTransformerFactory saxTFactory = (SAXTransformerFactory)tFactory;
                Set parameterSet = this.filters.keySet();
                Iterator it = parameterSet.iterator();
                this.info("Trying to Apply XSL Transformation on file " + inputFile);
                while (it.hasNext()) {
                    this.info("Adding XSLT Engine Filter");
                    String key = (String)it.next();
                    Filter f = (Filter)this.filters.get(key);
                    String schema = f.getSchema();
                    InputStream schemaIn = Thread.currentThread().getContextClassLoader().getResourceAsStream(schema);
                    TransformerHandler tHandler = saxTFactory.newTransformerHandler(new StreamSource(schemaIn));
                    Transformer t = tHandler.getTransformer();
                    Map parameters = f.getParameters();
                    Set s = parameters.keySet();
                    Iterator itp = s.iterator();
                    block8: while (true) {
                        try {
                            while (itp.hasNext()) {
                                String paramKey = (String)itp.next();
                                Parameter p = (Parameter)parameters.get(paramKey);
                                try {
                                    t.setParameter(p.getKey(), p.getValue());
                                    continue block8;
                                }
                                catch (IllegalArgumentException e) {
                                }
                            }
                            break;
                        }
                        catch (NullPointerException e) {
                            this.info("Filter without parameters");
                            break;
                        }
                    }
                    tList.add(tHandler);
                }
                for (int k = 1; k < tList.size(); ++k) {
                    ((TransformerHandler)tList.get(k - 1)).setResult(new SAXResult((ContentHandler)tList.get(k)));
                }
                ((TransformerHandler)tList.get(tList.size() - 1)).setResult(new StreamResult(new OutputStreamWriter((OutputStream)fileOut)));
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                SAXParser jaxpParser = factory.newSAXParser();
                XMLReader reader = jaxpParser.getXMLReader();
                if (reader == null) {
                    reader = XMLReaderFactory.createXMLReader();
                }
                reader.setContentHandler((ContentHandler)tList.get(0));
                FileInputStream fileIn = new FileInputStream(inputFile);
                InputSource sourceIn = new InputSource((InputStream)fileIn);
                sourceIn.setSystemId(inputFile);
                this.info("Patch XML file");
                reader.parse(sourceIn);
                fileOut.close();
                fileIn.close();
                de.schlichtherle.io.File destination = new de.schlichtherle.io.File(inputFile);
                de.schlichtherle.io.File source = new de.schlichtherle.io.File(tempXSL);
                de.schlichtherle.io.File.cp((File)source, (File)destination);
                source.delete();
                de.schlichtherle.io.File.update();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayException) {
            this.info("Pipe empty ; Nothing to parse");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String getWhoIAm() {
        return "XSLT Engine";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!this.filters.isEmpty()) {
            this.archive = this.formatter.format(this.archive);
            this.pattern = this.formatter.format(this.pattern);
            de.schlichtherle.io.File.setDefaultArchiveDetector((ArchiveDetector)ArchiveDetector.ALL);
            de.schlichtherle.io.File f = new de.schlichtherle.io.File(this.archive);
            FileList l = new FileList(this.pattern);
            Collection<String> c = l.listDir(f);
            Iterator<String> i = c.iterator();
            try {
                while (i.hasNext()) {
                    String s = i.next();
                    this.transform(s);
                }
            }
            finally {
                try {
                    de.schlichtherle.io.File.umount();
                }
                catch (ArchiveException e) {
                    e.printStackTrace();
                }
            }
        }
        this.info("Configuration empty ; Nothing to do");
    }
}

