/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.components.wsdl;

import com.ibm.wsdl.xml.WSDLReaderImpl;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;

public class WSDLHelper {
    public static String getPortLocation(Definition wsdl, String portName) throws WSDLException {
        Port port = WSDLHelper.getPort(wsdl, portName);
        return WSDLHelper.getPortAddress(port).getLocationURI();
    }

    public static Port getPort(Definition wsdl, String portName) throws WSDLException {
        Map services = wsdl.getServices();
        for (QName name : services.keySet()) {
            Map ports = ((Service)services.get(name)).getPorts();
            if (!ports.containsKey(portName)) continue;
            return (Port)ports.get(portName);
        }
        throw new WSDLException("CONFIGURATION_ERROR", "Port " + portName + " not found");
    }

    public static Port getFirstPort(Definition wsdl) {
        return (Port)((Service)wsdl.getServices().values().iterator().next()).getPorts().values().iterator().next();
    }

    public static SOAPAddress getPortAddress(Port port) throws WSDLException {
        for (Object obj : port.getExtensibilityElements()) {
            if (!(obj instanceof SOAPAddress)) continue;
            return (SOAPAddress)obj;
        }
        throw new WSDLException("CONFIGURATION_ERROR", "No SOAPAdress defined for Port " + port.getName());
    }

    public static BindingOperation getOperation(Definition wsdl, String name) {
        for (Binding b : wsdl.getBindings().values()) {
            for (BindingOperation op : b.getBindingOperations()) {
                if (!op.getName().equals(name)) continue;
                return op;
            }
        }
        return null;
    }

    public static String getSOAPAction(Definition wsdl, String name) {
        List ops = ((Binding)wsdl.getBindings().entrySet().iterator().next().getValue()).getBindingOperations();
        for (BindingOperation op : ops) {
            System.out.println("Operation : " + op.getName());
            if (!op.getName().equals(name)) continue;
            List ext = op.getExtensibilityElements();
            for (Object object : ext) {
                if (object instanceof SOAPOperation) {
                    return ((SOAPOperation)object).getSoapActionURI();
                }
                System.out.println("extType : " + object.getClass().getName());
            }
            return null;
        }
        return null;
    }

    public static Definition definitionFromRessource(String wsdlFile) throws FileNotFoundException, WSDLException {
        URL wsdlRessource = WSDLHelper.class.getClassLoader().getResource(wsdlFile);
        if (wsdlRessource == null) {
            throw new FileNotFoundException(wsdlFile);
        }
        return new WSDLReaderImpl().readWSDL(wsdlRessource.toString());
    }

    public static QName getReplyName(Definition definition, QName requestName) {
        BindingOperation op = WSDLHelper.getOperation(definition, requestName.getLocalPart());
        return new QName(requestName.getNamespaceURI(), op.getBindingOutput().getName(), requestName.getPrefix());
    }
}

