/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import org.objectweb.fdf.parser.api.PreprocessedClassLoader;
import org.objectweb.fdf.parser.common.FDFClassLoader;
import org.objectweb.fdf.util.fractal.FractalHelper;
import org.objectweb.fdf.util.io.FilenameHelper;
import org.objectweb.fdf.util.printer.api.Printer;
import org.objectweb.fdf.util.printer.lib.gui.GUI;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.Factory;
import org.objectweb.util.explorer.api.Tree;
import org.objectweb.util.explorer.parser.api.ParserConfiguration;
import org.objectweb.util.explorer.swing.api.Explorer;
import org.objectweb.util.explorer.swing.api.StatusBar;
import org.objectweb.util.explorer.swing.api.ViewPanel;
import org.objectweb.util.explorer.swing.lib.DefaultTreePanel;

public class ExplorerGUI
implements Runnable {
    protected static ExplorerGUI singleton;
    protected static PreprocessedClassLoader classLoader;
    protected String frameTitle;
    protected String explorerConfigurationFiles;
    protected String initialRole;
    protected org.objectweb.fractal.api.Component explorerEngine;
    protected Factory factory;
    protected Printer printer;
    protected GUI gui;
    protected JFrame frame;
    protected Tree explorerTree;

    protected Object getExplorerEngineInterface(String name) {
        return FractalHelper.getInterface(this.explorerEngine, name);
    }

    public ExplorerGUI() {
        singleton = this;
    }

    public void run() {
        if (this.explorerConfigurationFiles != null) {
            ParserConfiguration parser = (ParserConfiguration)this.getExplorerEngineInterface("parser-configuration");
            StringTokenizer st = new StringTokenizer(this.explorerConfigurationFiles, "; ");
            while (st.hasMoreTokens()) {
                String theFile = st.nextToken();
                parser.addPropertyFile(theFile);
            }
            parser.parse();
        }
        Explorer explorer = (Explorer)this.getExplorerEngineInterface("explorer");
        explorer.setCurrentRoles(new String[]{this.initialRole});
        this.explorerTree = (Tree)this.getExplorerEngineInterface("tree");
        this.frame = new JFrame(this.frameTitle);
        JMenuBar menuBar = new JMenuBar();
        this.frame.setJMenuBar(menuBar);
        explorer.setMenuBar(menuBar);
        JPanel panel = new JPanel(new BorderLayout());
        this.frame.getContentPane().add(panel);
        JToolBar toolBar = new JToolBar();
        panel.add((Component)toolBar, "North");
        explorer.setToolBar(toolBar);
        panel.add((Component)new JSplitPane(0, true, new JSplitPane(1, true, (Component)new DefaultTreePanel(explorer.getTree()), ((ViewPanel)this.getExplorerEngineInterface("view-panel")).getViewPanel()), (JComponent)this.gui.getGUI()), "Center");
        panel.add((Component)((StatusBar)this.getExplorerEngineInterface("status-bar")).getStatusBar(), "South");
        this.frame.setDefaultCloseOperation(3);
        this.frame.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.frame.setLocation((screenSize.width - this.frame.getWidth()) / 2, (screenSize.height - this.frame.getHeight()) / 2);
        this.frame.setVisible(true);
    }

    public void addComponent(org.objectweb.fractal.api.Component component) {
        this.explorerTree.addEntry((Object)FractalHelper.getComponentName(component), (Object)component, 1);
    }

    public static void traceMessage(String message) {
        ExplorerGUI.singleton.printer.print(message);
    }

    public static void loadADL(File file) {
        org.objectweb.fractal.api.Component component;
        URL url;
        String definitionName;
        String filename = file.getPath();
        ExplorerGUI.traceMessage("loading " + filename + "...");
        try {
            definitionName = FilenameHelper.getDefinitionName(file, classLoader);
        }
        catch (IOException exc) {
            ExplorerGUI.traceMessage("Can't load: " + exc.toString());
            return;
        }
        String tmpDefinitionName = definitionName.replace('.', File.separatorChar);
        if (!filename.substring(0, filename.lastIndexOf(46)).endsWith(tmpDefinitionName)) {
            throw new Error("Wrong definition name ('" + filename.substring(1, filename.lastIndexOf(46)) + "' expected, instead of '" + definitionName + "'): " + filename);
        }
        try {
            String tmp = definitionName.replace('.', File.separatorChar) + ".fractal";
            if (filename.lastIndexOf(tmp) < 0 && filename.lastIndexOf(tmp = definitionName.replace('.', File.separatorChar) + '.' + classLoader.getExtension()) < 0) {
                ExplorerGUI.traceMessage("Can't load: the chosen file is not of extension .fractal or ." + classLoader.getExtension());
                return;
            }
            String filepath = filename.substring(0, filename.lastIndexOf(tmp));
            url = new URL("file:" + filepath);
        }
        catch (IOException exc) {
            ExplorerGUI.traceMessage("Can't load: " + exc.toString());
            return;
        }
        FDFClassLoader classLoader = new FDFClassLoader(new URL[]{url}, Thread.currentThread().getContextClassLoader());
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("classloader", classLoader);
        context.put("local-tmp-dir", System.getProperties().get("java.io.tmpdir"));
        try {
            component = (org.objectweb.fractal.api.Component)ExplorerGUI.singleton.factory.newComponent("org.objectweb.fdf.explorer.LoadFromExplorer(" + definitionName.replace('.', '-') + ',' + definitionName + ')', context);
        }
        catch (ADLException exception) {
            ExplorerGUI.traceMessage("Can't create components: " + exception.toString());
            exception.printStackTrace(System.err);
            return;
        }
        catch (Error exception) {
            ExplorerGUI.traceMessage(exception.getMessage());
            return;
        }
        catch (Throwable exception) {
            ExplorerGUI.traceMessage("Can't create components: " + exception.toString());
            exception.printStackTrace(System.err);
            return;
        }
        try {
            FractalHelper.getLifeCycleController(component).startFc();
        }
        catch (Exception ignored) {
            ExplorerGUI.traceMessage("Info: The lifecycle controller does not exist or fail.");
        }
        singleton.addComponent((org.objectweb.fractal.api.Component)FractalHelper.getInterface(component, "loaded-component"));
        ExplorerGUI.traceMessage(filename + " loaded.");
    }

    static {
        classLoader = new FDFClassLoader();
    }
}

