/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.explorer.fractal;

import java.util.ArrayList;
import org.objectweb.fdf.util.fractal.FractalHelper;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.util.explorer.api.Context;
import org.objectweb.util.explorer.api.Entry;
import org.objectweb.util.explorer.core.naming.lib.DefaultEntry;

public class ComponentContext
implements Context {
    private static final long serialVersionUID = -5437429600873929837L;

    protected static Object computeChild(Component component) {
        int nbPublicInterfaces = 0;
        Interface firstPublicInterface = null;
        Object[] interfaces = component.getFcInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Interface itf = (Interface)interfaces[i];
            if (!FractalHelper.isPublicInterface(itf)) continue;
            ++nbPublicInterfaces;
            if (firstPublicInterface != null) continue;
            firstPublicInterface = itf;
        }
        int nbPublicSubComponents = 0;
        Component[] subComponents = FractalHelper.getSubComponents(component);
        for (int i = 0; i < subComponents.length; ++i) {
            if (!FractalHelper.isPublicName(FractalHelper.getComponentName(subComponents[i]))) continue;
            ++nbPublicSubComponents;
        }
        if (nbPublicInterfaces > 0) {
            return firstPublicInterface;
        }
        return component;
    }

    protected static Entry[] getEntries(Component component, Interface excludeInterface) {
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<DefaultEntry> entries = new ArrayList<DefaultEntry>();
        Object[] interfaces = component.getFcInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            String key;
            Interface itf = (Interface)interfaces[i];
            if (itf == excludeInterface || !FractalHelper.isPublicInterface(itf) || keys.contains(key = itf.getFcItfName())) continue;
            keys.add(key);
            entries.add(new DefaultEntry((Object)key, (Object)itf));
        }
        Component[] subComponents = FractalHelper.getSubComponents(component);
        for (int i = 0; i < subComponents.length; ++i) {
            Component subComponent = subComponents[i];
            String componentName = FractalHelper.getComponentName(subComponent);
            if (!FractalHelper.isPublicName(componentName) || keys.contains(componentName)) continue;
            keys.add(componentName);
            entries.add(new DefaultEntry((Object)componentName, ComponentContext.computeChild(subComponent)));
        }
        return entries.toArray(new Entry[entries.size()]);
    }

    public Entry[] getEntries(Object object) {
        return ComponentContext.getEntries((Component)object, null);
    }
}

