/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.util.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.objectweb.fdf.parser.api.PreprocessedClassLoader;
import org.objectweb.fdf.parser.common.ParseException;

public class FilenameHelper {
    protected FilenameHelper() {
    }

    public static int lastIndexOfPathSeparator(String filename) {
        return Math.max(filename.lastIndexOf(47), filename.lastIndexOf(92));
    }

    public static String getPath(String filename) {
        int index = FilenameHelper.lastIndexOfPathSeparator(filename);
        return index == -1 ? "" : filename.substring(0, index);
    }

    public static String getFilename(String filename) {
        return filename.substring(FilenameHelper.lastIndexOfPathSeparator(filename) + 1);
    }

    public static String getDefinitionName(File file, PreprocessedClassLoader classloader) throws IOException {
        String fileExt = file.getName().substring(file.getName().lastIndexOf("."));
        FileInputStream is = new FileInputStream(file);
        if (fileExt.equals(".fractal")) {
            return FilenameHelper.getDefinitionNameFractal(is);
        }
        return FilenameHelper.getDefinitionNameElse(is, classloader);
    }

    protected static String getDefinitionNameFractal(InputStream is) throws IOException {
        String definitionName = null;
        BufferedReader buffer = new BufferedReader(new InputStreamReader(is));
        boolean definitionRead = false;
        String line = null;
        while (definitionName == null && (line = buffer.readLine()) != null) {
            int index = 0;
            if (!definitionRead) {
                index = line.indexOf("<definition");
                boolean bl = definitionRead = index != -1;
            }
            if (!definitionRead || (index = line.indexOf("name", index)) == -1) continue;
            index += 5;
            int begin = -1;
            while (definitionName == null && index < line.length()) {
                char c = line.charAt(index);
                switch (c) {
                    case ' ': {
                        break;
                    }
                    case '\"': {
                        if (begin == -1) {
                            begin = index + 1;
                            break;
                        }
                        definitionName = line.substring(begin, index);
                        break;
                    }
                }
                ++index;
            }
        }
        buffer.close();
        return definitionName;
    }

    protected static String getDefinitionNameElse(InputStream is, PreprocessedClassLoader classloader) throws IOException {
        try {
            return classloader.getDefinition(is);
        }
        catch (ParseException e) {
            throw new IOException("Parse Error");
        }
    }
}

