/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: PropertyManager.java 9171 2011-10-13 14:30:56Z richardd $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.agent.common.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

/**
 * Manager to get Properties from a property file specified
 * 
 * @author Julien Vey
 */
public class PropertyManager {

    /**
     * the path of the property file
     */
    private static String Property_file;

    /**
     * the properties corresponding to the given file
     */
    private Properties prop;

    /**
     * @param FileUrl
     *            The property file URL
     */
    public PropertyManager(String FileUrl) {
        setProperty_file(FileUrl);
        prop = new Properties();
        try {
            FileInputStream in = new FileInputStream(Property_file);
            prop.load(in);
            in.close();
        } catch (FileNotFoundException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

    }

    /**
     * @param key
     *            The property to get from the property file
     * @return The value of the property
     */
    public String getProperty(String key) {
        return prop.getProperty(key);
    }

    /**
     * @return the property_file
     */
    public static String getProperty_file() {
        return Property_file;
    }

    /**
     * @param propertyFile
     *            the property_file to set
     */
    public static void setProperty_file(String propertyFile) {
        Property_file = propertyFile;
    }
}
