/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Activator.java 9171 2011-10-13 14:30:56Z richardd $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.agent.remote.configuration;

import java.util.Hashtable;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.ow2.jonas.lib.bootstrap.JProp;

/**
 * Activator which will configure the discovery service
 * 
 * @author Julien Vey
 */
public class Activator implements BundleActivator {

    /**
     * Discovery properties file name
     */
    public static final String DISCOVERY_PROPS_FILE = "discovery.properties";

    /**
     * Zookeeper host key
     */
    public static final String ZOOKEEPER_HOST_KEY = "zookeeper.host";

    /**
     * Zookeeper port key
     */
    public static final String ZOOKEEPER_PORT_KEY = "zookeeper.port";

    /* (non-Javadoc)
     * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
     */
    public void start(BundleContext bundleContext) throws Exception {
        ServiceReference configAdminServiceRef = bundleContext.getServiceReference(ConfigurationAdmin.class.getName());

        if (configAdminServiceRef != null) {
            ConfigurationAdmin configAdmin = (ConfigurationAdmin) bundleContext.getService(configAdminServiceRef);

            Configuration cfg = configAdmin.getConfiguration("org.apache.cxf.dosgi.discovery.zookeeper", null);
            Hashtable<String, Object> props = new Hashtable<String, Object>();

            JProp jprops = JProp.getInstance(DISCOVERY_PROPS_FILE);

            props.put("zookeeper.host", jprops.getValue(ZOOKEEPER_HOST_KEY));
            props.put("zookeeper.port", jprops.getValue(ZOOKEEPER_PORT_KEY));

            cfg.update(props);

        }

    }

    /* (non-Javadoc)
     * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
     */
    public void stop(BundleContext context) throws Exception {

    }

}
